/*******************************************************************************
 * The information contained in this file is confidential and proprietary to
 * QLogic Corporation.  No part of this file may be reproduced or
 * distributed, in any form or by any means for any purpose, without the
 * express written permission of QLogic Corporation.
 *
 * (c) COPYRIGHT 2016 QLogic Corporation, ALL RIGHTS RESERVED.
 *******************************************************************************/

#ifndef __QFLE3_ECORE_LINK_H__ 
#define __QFLE3_ECORE_LINK_H__ 




#ifndef _In_
#define _In_
#endif
#ifndef _Out_
#define _Out_
#endif

/***********************************************************/
/*                  CLC Call backs functions               */
/***********************************************************/
/* CLC device structure */
struct qfle3_adapter;

extern vmk_uint32 elink_cb_fio_free_counter(struct qfle3_adapter *adapter);
extern vmk_uint32 elink_cb_reg_read(struct qfle3_adapter *adapter, vmk_uint32 reg_addr);
extern void elink_cb_reg_write(struct qfle3_adapter *adapter, vmk_uint32 reg_addr, vmk_uint32 val);
/* wb_write - pointer to 2 32 bits vars to be passed to the DMAE*/
extern void elink_cb_reg_wb_write(struct qfle3_adapter *adapter, vmk_uint32 offset,
				vmk_uint32 *wb_write, vmk_uint16 len);
extern void elink_cb_reg_wb_read(struct qfle3_adapter *adapter, vmk_uint32 offset,
			       vmk_uint32 *wb_write, vmk_uint16 len);

/* mode - 0( LOW ) /1(HIGH)*/
extern vmk_uint8 elink_cb_gpio_write(struct qfle3_adapter *adapter,
			    vmk_uint16 gpio_num,
			    vmk_uint8 mode, vmk_uint8 port);
extern vmk_uint8 elink_cb_gpio_mult_write(struct qfle3_adapter *adapter,
			    vmk_uint8 pins,
			    vmk_uint8 mode);

extern vmk_uint32 elink_cb_gpio_read(struct qfle3_adapter *adapter, vmk_uint16 gpio_num, vmk_uint8 port);
extern vmk_uint8 elink_cb_gpio_int_write(struct qfle3_adapter *adapter,
				vmk_uint16 gpio_num,
				vmk_uint8 mode, vmk_uint8 port);

extern vmk_uint32 elink_cb_fw_command(struct qfle3_adapter *adapter, vmk_uint32 command, vmk_uint32 param);

/* Delay */
extern void elink_cb_udelay(struct qfle3_adapter *adapter, vmk_uint32 microsecond);

/* This function is called every 1024 bytes downloading of phy firmware.
Driver can use it to print to screen indication for download progress */
extern void elink_cb_download_progress(struct qfle3_adapter *adapter, vmk_uint32 cur, vmk_uint32 total);

/* Each log type has its own parameters */
typedef enum elink_log_id {
	ELINK_LOG_ID_UNQUAL_IO_MODULE	= 0, /* vmk_uint8 port, const char* vendor_name, const char* vendor_pn */
	ELINK_LOG_ID_OVER_CURRENT	= 1, /* vmk_uint8 port */
	ELINK_LOG_ID_PHY_UNINITIALIZED	= 2, /* vmk_uint8 port */
	ELINK_LOG_ID_MDIO_ACCESS_TIMEOUT= 3, /* No params */
	ELINK_LOG_ID_NON_10G_MODULE	= 4, /* vmk_uint8 port */
}elink_log_id_t;

typedef enum elink_status {
	ELINK_STATUS_OK = 0,
	ELINK_STATUS_ERROR,
	ELINK_STATUS_TIMEOUT,
	ELINK_STATUS_NO_LINK,
	ELINK_STATUS_INVALID_IMAGE,
	ELINK_OP_NOT_SUPPORTED = 122
} elink_status_t;
#ifndef EDEBUG
extern void elink_cb_event_log(struct qfle3_adapter *adapter, const elink_log_id_t log_id, ...);
#endif
extern void elink_cb_load_warpcore_microcode(void);

extern vmk_uint8 elink_cb_path_id(struct qfle3_adapter *adapter);

extern void elink_cb_notify_link_changed(struct qfle3_adapter *adapter);

#define ELINK_EVENT_LOG_LEVEL_ERROR 	1
#define ELINK_EVENT_LOG_LEVEL_WARNING 	2
#define ELINK_EVENT_ID_SFP_UNQUALIFIED_MODULE 	1
#define ELINK_EVENT_ID_SFP_POWER_FAULT 		2

#ifndef ARRAY_SIZE
#define ARRAY_SIZE(x) (sizeof(x)/sizeof(x[0]))
#endif
/* Debug prints */


#define ELINK_DEBUG_P0(adapter, fmt, ...) 		QFLE3_DBG(QFLE3_DBG_LINK, fmt, ##__VA_ARGS__)
#define ELINK_DEBUG_P1(adapter, fmt, ...) 		QFLE3_DBG(QFLE3_DBG_LINK, fmt, ##__VA_ARGS__)
#define ELINK_DEBUG_P2(adapter, fmt, ...)	QFLE3_DBG(QFLE3_DBG_LINK, fmt, ##__VA_ARGS__)
#define ELINK_DEBUG_P3(adapter, fmt, ...) \
					QFLE3_DBG(QFLE3_DBG_LINK, fmt, ##__VA_ARGS__)


/***********************************************************/
/*                         Defines                         */
/***********************************************************/
#define ELINK_DEFAULT_PHY_DEV_ADDR	3
#define ELINK_E2_DEFAULT_PHY_DEV_ADDR	5


#define DUPLEX_FULL			1
#define DUPLEX_HALF			2

#define ELINK_FLOW_CTRL_AUTO		PORT_FEATURE_FLOW_CONTROL_AUTO
#define ELINK_FLOW_CTRL_TX		PORT_FEATURE_FLOW_CONTROL_TX
#define ELINK_FLOW_CTRL_RX		PORT_FEATURE_FLOW_CONTROL_RX
#define ELINK_FLOW_CTRL_BOTH		PORT_FEATURE_FLOW_CONTROL_BOTH
#define ELINK_FLOW_CTRL_NONE		PORT_FEATURE_FLOW_CONTROL_NONE

#define ELINK_NET_SERDES_IF_XFI		1
#define ELINK_NET_SERDES_IF_SFI		2
#define ELINK_NET_SERDES_IF_KR		3
#define ELINK_NET_SERDES_IF_DXGXS	4

#define ELINK_SPEED_AUTO_NEG		0
#define ELINK_SPEED_10			10
#define ELINK_SPEED_100			100
#define ELINK_SPEED_1000		1000
#define ELINK_SPEED_2500		2500
#define ELINK_SPEED_10000		10000
#define ELINK_SPEED_20000		20000

#define ELINK_I2C_DEV_ADDR_A0			0xa0
#define ELINK_I2C_DEV_ADDR_A2			0xa2

#define ELINK_SFP_EEPROM_PAGE_SIZE			16
#define ELINK_SFP_EEPROM_VENDOR_NAME_ADDR		0x14
#define ELINK_SFP_EEPROM_VENDOR_NAME_SIZE		16
#define ELINK_SFP_EEPROM_VENDOR_OUI_ADDR		0x25
#define ELINK_SFP_EEPROM_VENDOR_OUI_SIZE		3
#define ELINK_SFP_EEPROM_PART_NO_ADDR			0x28
#define ELINK_SFP_EEPROM_PART_NO_SIZE			16
#define ELINK_SFP_EEPROM_REVISION_ADDR		0x38
#define ELINK_SFP_EEPROM_REVISION_SIZE		4
#define ELINK_SFP_EEPROM_SERIAL_ADDR			0x44
#define ELINK_SFP_EEPROM_SERIAL_SIZE			16
#define ELINK_SFP_EEPROM_DATE_ADDR			0x54 /* ASCII YYMMDD */
#define ELINK_SFP_EEPROM_DATE_SIZE			6
#define ELINK_SFP_EEPROM_DIAG_TYPE_ADDR			0x5c
#define ELINK_SFP_EEPROM_DIAG_TYPE_SIZE			1
#define ELINK_SFP_EEPROM_DIAG_ADDR_CHANGE_REQ		(1<<2)
#define ELINK_SFP_EEPROM_SFF_8472_COMP_ADDR		0x5e
#define ELINK_SFP_EEPROM_SFF_8472_COMP_SIZE		1
#define ELINK_SFP_EEPROM_VENDOR_SPECIFIC_ADDR	0x60
#define ELINK_SFP_EEPROM_VENDOR_SPECIFIC_SIZE	16

/* Data fields to be used with address 0xA2 */
#define ELINK_SFP_EEPROM_A2_TEMP_HIGH_ALARM_ADDR	0x0
#define ELINK_SFP_EEPROM_A2_TEMP_HIGH_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_TEMP_LOW_ALARM_ADDR		0x2
#define ELINK_SFP_EEPROM_A2_TEMP_LOW_ALARM_SIZE		2
#define ELINK_SFP_EEPROM_A2_TEMP_HIGH_WARN_ADDR		0x4
#define ELINK_SFP_EEPROM_A2_TEMP_HIGH_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_TEMP_LOW_WARN_ADDR		0x6
#define ELINK_SFP_EEPROM_A2_TEMP_LOW_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_VOLT_HIGH_ALARM_ADDR	0x8
#define ELINK_SFP_EEPROM_A2_VOLT_HIGH_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_VOLT_LOW_ALARM_ADDR		0xa
#define ELINK_SFP_EEPROM_A2_VOLT_LOW_ALARM_SIZE		2
#define ELINK_SFP_EEPROM_A2_VOLT_HIGH_WARN_ADDR		0xc
#define ELINK_SFP_EEPROM_A2_VOLT_HIGH_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_VOLT_LOW_WARN_ADDR		0xe
#define ELINK_SFP_EEPROM_A2_VOLT_LOW_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_BIAS_HIGH_ALARM_ADDR	0x10
#define ELINK_SFP_EEPROM_A2_BIAS_HIGH_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_BIAS_LOW_ALARM_ADDR		0x12
#define ELINK_SFP_EEPROM_A2_BIAS_LOW_ALARM_SIZE		2
#define ELINK_SFP_EEPROM_A2_BIAS_HIGH_WARN_ADDR		0x14
#define ELINK_SFP_EEPROM_A2_BIAS_HIGH_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_BIAS_LOW_WARN_ADDR		0x16
#define ELINK_SFP_EEPROM_A2_BIAS_LOW_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_TXPOW_HIGH_ALARM_ADDR	0x18
#define ELINK_SFP_EEPROM_A2_TXPOW_HIGH_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_TXPOW_LOW_ALARM_ADDR	0x1a
#define ELINK_SFP_EEPROM_A2_TXPOW_LOW_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_TXPOW_HIGH_WARN_ADDR	0x1c
#define ELINK_SFP_EEPROM_A2_TXPOW_HIGH_WARN_SIZE	2
#define ELINK_SFP_EEPROM_A2_TXPOW_LOW_WARN_ADDR		0x1e
#define ELINK_SFP_EEPROM_A2_TXPOW_LOW_WARN_SIZE		2
#define ELINK_SFP_EEPROM_A2_RXPOW_HIGH_ALARM_ADDR	0x20
#define ELINK_SFP_EEPROM_A2_RXPOW_HIGH_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_RXPOW_LOW_ALARM_ADDR	0x22
#define ELINK_SFP_EEPROM_A2_RXPOW_LOW_ALARM_SIZE	2
#define ELINK_SFP_EEPROM_A2_RXPOW_HIGH_WARN_ADDR	0x24
#define ELINK_SFP_EEPROM_A2_RXPOW_HIGH_WARN_SIZE	2
#define ELINK_SFP_EEPROM_A2_RXPOW_LOW_WARN_ADDR		0x26
#define ELINK_SFP_EEPROM_A2_RXPOW_LOW_WARN_SIZE		2

#define ELINK_SFP_EEPROM_A2_CHECKSUM_RANGE		0x5e
#define ELINK_SFP_EEPROM_A2_CC_DMI_ADDR			0x5f

#define ELINK_SFP_EEPROM_A2_TEMPERATURE_ADDR		0x60
#define ELINK_SFP_EEPROM_A2_TEMPERATURE_SIZE		2
#define ELINK_SFP_EEPROM_A2_VCC_ADDR			0x62
#define ELINK_SFP_EEPROM_A2_VCC_SIZE			2
#define ELINK_SFP_EEPROM_A2_TX_BIAS_ADDR		0x64
#define ELINK_SFP_EEPROM_A2_TX_BIAS_SIZE		2
#define ELINK_SFP_EEPROM_A2_TX_POWER_ADDR		0x66
#define ELINK_SFP_EEPROM_A2_TX_POWER_SIZE		2
#define ELINK_SFP_EEPROM_A2_RX_POWER_ADDR		0x68
#define ELINK_SFP_EEPROM_A2_RX_POWER_SIZE		2

#define ELINK_PWR_FLT_ERR_MSG_LEN			250

#define ELINK_XGXS_EXT_PHY_TYPE(ext_phy_config) \
		((ext_phy_config) & PORT_HW_CFG_XGXS_EXT_PHY_TYPE_MASK)
#define ELINK_XGXS_EXT_PHY_ADDR(ext_phy_config) \
		(((ext_phy_config) & PORT_HW_CFG_XGXS_EXT_PHY_ADDR_MASK) >> \
		 PORT_HW_CFG_XGXS_EXT_PHY_ADDR_SHIFT)
#define ELINK_SERDES_EXT_PHY_TYPE(ext_phy_config) \
		((ext_phy_config) & PORT_HW_CFG_SERDES_EXT_PHY_TYPE_MASK)

/* Single Media Direct board is the plain 577xx board with CX4/RJ45 jacks */
#define ELINK_SINGLE_MEDIA_DIRECT(params)	(params->num_phys == 1)
/* Single Media board contains single external phy */
#define ELINK_SINGLE_MEDIA(params)		(params->num_phys == 2)
/* Dual Media board contains two external phy with different media */
#define ELINK_DUAL_MEDIA(params)		(params->num_phys == 3)

#define ELINK_FW_PARAM_PHY_ADDR_MASK		0x000000FF
#define ELINK_FW_PARAM_PHY_TYPE_MASK		0x0000FF00
#define ELINK_FW_PARAM_MDIO_CTRL_MASK		0xFFFF0000
#define ELINK_FW_PARAM_MDIO_CTRL_OFFSET		16
#define ELINK_FW_PARAM_PHY_ADDR(fw_param) (fw_param & \
					   ELINK_FW_PARAM_PHY_ADDR_MASK)
#define ELINK_FW_PARAM_PHY_TYPE(fw_param) (fw_param & \
					   ELINK_FW_PARAM_PHY_TYPE_MASK)
#define ELINK_FW_PARAM_MDIO_CTRL(fw_param) ((fw_param & \
					    ELINK_FW_PARAM_MDIO_CTRL_MASK) >> \
					    ELINK_FW_PARAM_MDIO_CTRL_OFFSET)
#define ELINK_FW_PARAM_SET(phy_addr, phy_type, mdio_access) \
	(phy_addr | phy_type | mdio_access << ELINK_FW_PARAM_MDIO_CTRL_OFFSET)


#define ELINK_PFC_BRB_FULL_LB_XOFF_THRESHOLD				170
#define ELINK_PFC_BRB_FULL_LB_XON_THRESHOLD				250

#define ELINK_MAXVAL(a, b) (((a) > (b)) ? (a) : (b))

#define ELINK_BMAC_CONTROL_RX_ENABLE		2
/***********************************************************/
/*                         Structs                         */
/***********************************************************/
#define ELINK_INT_PHY		0
#define ELINK_EXT_PHY1	1
#define ELINK_EXT_PHY2	2
#define ELINK_MAX_PHYS	3

/* Same configuration is shared between the XGXS and the first external phy */
#define ELINK_LINK_CONFIG_SIZE (ELINK_MAX_PHYS - 1)
#define ELINK_LINK_CONFIG_IDX(_phy_idx) ((_phy_idx == ELINK_INT_PHY) ? \
					 0 : (_phy_idx - 1))
/***********************************************************/
/*                      elink_phy struct                   */
/*  Defines the required arguments and function per phy    */
/***********************************************************/
struct elink_vars;
struct elink_params;
struct elink_phy;

typedef vmk_uint8 (*config_init_t)(struct elink_phy *phy, struct elink_params *params,
			    struct elink_vars *vars);
typedef vmk_uint8 (*read_status_t)(struct elink_phy *phy, struct elink_params *params,
			    struct elink_vars *vars);
typedef void (*link_reset_t)(struct elink_phy *phy,
			     struct elink_params *params);
typedef void (*config_loopback_t)(struct elink_phy *phy,
				  struct elink_params *params);
typedef vmk_uint8 (*format_fw_ver_t)(vmk_uint32 raw, vmk_uint8 *str, vmk_uint16 *len);
typedef void (*hw_reset_t)(struct elink_phy *phy, struct elink_params *params);
typedef void (*set_link_led_t)(struct elink_phy *phy,
			       struct elink_params *params, vmk_uint8 mode);
typedef void (*phy_specific_func_t)(struct elink_phy *phy,
				    struct elink_params *params, vmk_uint32 action);
struct elink_reg_set {
	vmk_uint8  devad;
	vmk_uint16 reg;
	vmk_uint16 val;
};

struct elink_phy {
	vmk_uint32 type;

	/* Loaded during init */
	vmk_uint8 addr;
	vmk_uint8 def_md_devad;
	vmk_uint16 flags;
	/* No Over-Current detection */
#define ELINK_FLAGS_NOC			(1<<1)
	/* Fan failure detection required */
#define ELINK_FLAGS_FAN_FAILURE_DET_REQ	(1<<2)
	/* Initialize first the XGXS and only then the phy itself */
#define ELINK_FLAGS_INIT_XGXS_FIRST		(1<<3)
#define ELINK_FLAGS_WC_DUAL_MODE		(1<<4)
#define ELINK_FLAGS_4_PORT_MODE		(1<<5)
#define ELINK_FLAGS_REARM_LATCH_SIGNAL		(1<<6)
#define ELINK_FLAGS_SFP_NOT_APPROVED		(1<<7)
#define ELINK_FLAGS_MDC_MDIO_WA		(1<<8)
#define ELINK_FLAGS_DUMMY_READ			(1<<9)
#define ELINK_FLAGS_MDC_MDIO_WA_B0		(1<<10)
#define ELINK_FLAGS_SFP_MODULE_PLUGGED_IN_WC	(1<<11)
#define ELINK_FLAGS_TX_ERROR_CHECK		(1<<12)
#define ELINK_FLAGS_EEE			(1<<13)
#define ELINK_FLAGS_TEMPERATURE		(1<<14)
#define ELINK_FLAGS_MDC_MDIO_WA_G		(1<<15)

	/* preemphasis values for the rx side */
	vmk_uint16 rx_preemphasis[4];

	/* preemphasis values for the tx side */
	vmk_uint16 tx_preemphasis[4];

	/* EMAC address for access MDIO */
	vmk_uint32 mdio_ctrl;

	vmk_uint32 supported;
#define ELINK_SUPPORTED_10baseT_Half		(1<<0)
#define ELINK_SUPPORTED_10baseT_Full		(1<<1)
#define ELINK_SUPPORTED_100baseT_Half		(1<<2)
#define ELINK_SUPPORTED_100baseT_Full		(1<<3)
#define ELINK_SUPPORTED_1000baseT_Full	(1<<4)
#define ELINK_SUPPORTED_2500baseX_Full	(1<<5)
#define ELINK_SUPPORTED_10000baseT_Full 	(1<<6)
#define ELINK_SUPPORTED_TP 			(1<<7)
#define ELINK_SUPPORTED_FIBRE 			(1<<8)
#define ELINK_SUPPORTED_Autoneg 		(1<<9)
#define ELINK_SUPPORTED_Pause 			(1<<10)
#define ELINK_SUPPORTED_Asym_Pause		(1<<11)
#define ELINK_SUPPORTED_1000baseKX_Full		(1<<17)
#define ELINK_SUPPORTED_10000baseKR_Full	(1<<19)
#define ELINK_SUPPORTED_20000baseMLD2_Full	(1<<21)
#define ELINK_SUPPORTED_20000baseKR2_Full	(1<<22)

	vmk_uint32 media_type;
#define	ELINK_ETH_PHY_UNSPECIFIED	0x0
#define	ELINK_ETH_PHY_SFPP_10G_FIBER	0x1
#define	ELINK_ETH_PHY_XFP_FIBER		0x2
#define	ELINK_ETH_PHY_DA_TWINAX		0x3
#define	ELINK_ETH_PHY_BASE_T		0x4
#define ELINK_ETH_PHY_SFP_1G_FIBER	0x5
#define	ELINK_ETH_PHY_KR		0xf0
#define	ELINK_ETH_PHY_CX4		0xf1
#define	ELINK_ETH_PHY_NOT_PRESENT	0xff

	/* The address in which version is located*/
	vmk_uint32 ver_addr;

	vmk_uint16 req_flow_ctrl;

	vmk_uint16 req_line_speed;

	vmk_uint32 speed_cap_mask;

	vmk_uint16 req_duplex;
	vmk_uint16 rsrv;
	/* Called per phy/port init, and it configures LASI, speed, autoneg,
	 duplex, flow control negotiation, etc. */
	config_init_t config_init;

	/* Called due to interrupt. It determines the link, speed */
	read_status_t read_status;

	/* Called when driver is unloading. Should reset the phy */
	link_reset_t link_reset;

	/* Set the loopback configuration for the phy */
	config_loopback_t config_loopback;

	/* Format the given raw number into str up to len */
	format_fw_ver_t format_fw_ver;

	/* Reset the phy (both ports) */
	hw_reset_t hw_reset;

	/* Set link led mode (on/off/oper)*/
	set_link_led_t set_link_led;

	/* PHY Specific tasks */
	phy_specific_func_t phy_specific_func;
#define ELINK_DISABLE_TX	1
#define ELINK_ENABLE_TX	2
#define ELINK_PHY_INIT	3
#define ELINK_PHY_PORT_PWR_DOWN 4
};

/* Inputs parameters to the CLC */
struct elink_params {

	vmk_uint8 port;

	/* Default / User Configuration */
	vmk_uint8 loopback_mode;
#define ELINK_LOOPBACK_NONE		0
#define ELINK_LOOPBACK_EMAC		1
#define ELINK_LOOPBACK_BMAC		2
#define ELINK_LOOPBACK_XGXS		3
#define ELINK_LOOPBACK_EXT_PHY		4
#define ELINK_LOOPBACK_EXT		5
#define ELINK_LOOPBACK_UMAC		6
#define ELINK_LOOPBACK_XMAC		7

	/* Device parameters */
	vmk_uint8 mac_addr[6];

	vmk_uint16 req_duplex[ELINK_LINK_CONFIG_SIZE];
	vmk_uint16 req_flow_ctrl[ELINK_LINK_CONFIG_SIZE];

	vmk_uint16 req_line_speed[ELINK_LINK_CONFIG_SIZE]; /* Also determine AutoNeg */

	/* shmem parameters */
	vmk_uint32 shmem_base;
	vmk_uint32 shmem2_base;
	vmk_uint32 speed_cap_mask[ELINK_LINK_CONFIG_SIZE];
	vmk_uint32 switch_cfg;
#define ELINK_SWITCH_CFG_1G		PORT_FEATURE_CON_SWITCH_1G_SWITCH
#define ELINK_SWITCH_CFG_10G		PORT_FEATURE_CON_SWITCH_10G_SWITCH
#define ELINK_SWITCH_CFG_AUTO_DETECT	PORT_FEATURE_CON_SWITCH_AUTO_DETECT

	vmk_uint32 lane_config;

	/* Phy register parameter */
	vmk_uint32 chip_id;

	/* features */
	vmk_uint32 feature_config_flags;
#define ELINK_FEATURE_CONFIG_OVERRIDE_PREEMPHASIS_ENABLED	(1<<0)
#define ELINK_FEATURE_CONFIG_PFC_ENABLED			(1<<1)
#define ELINK_FEATURE_CONFIG_BC_SUPPORTS_OPT_MDL_VRFY		(1<<2)
#define ELINK_FEATURE_CONFIG_BC_SUPPORTS_DUAL_PHY_OPT_MDL_VRFY	(1<<3)
#define ELINK_FEATURE_CONFIG_EMUL_DISABLE_EMAC			(1<<4)
#define ELINK_FEATURE_CONFIG_EMUL_DISABLE_BMAC			(1<<5)
#define ELINK_FEATURE_CONFIG_EMUL_DISABLE_UMAC			(1<<6)
#define ELINK_FEATURE_CONFIG_EMUL_DISABLE_XMAC			(1<<7)
#define ELINK_FEATURE_CONFIG_BC_SUPPORTS_AFEX			(1<<8)
#define ELINK_FEATURE_CONFIG_AUTOGREEEN_ENABLED		(1<<9)
#define ELINK_FEATURE_CONFIG_BC_SUPPORTS_SFP_TX_DISABLED	(1<<10)
#define ELINK_FEATURE_CONFIG_DISABLE_REMOTE_FAULT_DET		(1<<11)
#define ELINK_FEATURE_CONFIG_IEEE_PHY_TEST			(1<<12)
#define ELINK_FEATURE_CONFIG_MT_SUPPORT			(1<<13)
#define ELINK_FEATURE_CONFIG_BOOT_FROM_SAN			(1<<14)
#define ELINK_FEATURE_CONFIG_DISABLE_PD				(1<<15)

	/* Will be populated during common init */
	struct elink_phy phy[ELINK_MAX_PHYS];

	/* Will be populated during common init */
	vmk_uint8 num_phys;

	vmk_uint8 rsrv;

	/* Used to configure the EEE Tx LPI timer, has several modes of
	 * operation, according to bits 29:28 -
	 * 2'b00: Timer will be configured by nvram, output will be the value
	 *        from nvram.
	 * 2'b01: Timer will be configured by nvram, output will be in
	 *        microseconds.
	 * 2'b10: bits 1:0 contain an nvram value which will be used instead
	 *        of the one located in the nvram. Output will be that value.
	 * 2'b11: bits 19:0 contain the idle timer in microseconds; output
	 *        will be in microseconds.
	 * Bits 31:30 should be 2'b11 in order for EEE to be enabled.
	 */
	vmk_uint32 eee_mode;
#define ELINK_EEE_MODE_NVRAM_BALANCED_TIME		(0xa00)
#define ELINK_EEE_MODE_NVRAM_AGGRESSIVE_TIME		(0x100)
#define ELINK_EEE_MODE_NVRAM_LATENCY_TIME		(0x6000)
#define ELINK_EEE_MODE_NVRAM_MASK		(0x3)
#define ELINK_EEE_MODE_TIMER_MASK		(0xfffff)
#define ELINK_EEE_MODE_OUTPUT_TIME		(1<<28)
#define ELINK_EEE_MODE_OVERRIDE_NVRAM		(1<<29)
#define ELINK_EEE_MODE_ENABLE_LPI		(1<<30)
#define ELINK_EEE_MODE_ADV_LPI			(1<<31)

	vmk_uint16 hw_led_mode; /* part of the hw_config read from the shmem */
	vmk_uint32 multi_phy_config;

	/* Device pointer passed to all callback functions */
	struct qfle3_adapter *adapter;
	vmk_uint16 req_fc_auto_adv; /* Should be set to TX / BOTH when
				req_flow_ctrl is set to AUTO */
	vmk_uint16 link_flags;
#define ELINK_LINK_FLAGS_INT_DISABLED	(1<<0)
#define ELINK_PHY_INITIALIZED		(1<<1)
#define ELINK_WC_SGMII_FORCE_SPEED	(1<<2)
	vmk_uint32 lfa_base;

	/* The same definitions as the shmem2 parameter */
	vmk_uint32 link_attr_sync;
};

/* Output parameters */
struct elink_vars {
	vmk_uint8 phy_flags;
#define PHY_XGXS_FLAG			(1<<0)
#define PHY_SGMII_FLAG			(1<<1)
#define PHY_PHYSICAL_LINK_FLAG		(1<<2)
#define PHY_HALF_OPEN_CONN_FLAG		(1<<3)
#define PHY_OVER_CURRENT_FLAG		(1<<4)
#define PHY_SFP_TX_FAULT_FLAG		(1<<5)

	vmk_uint8 mac_type;
#define ELINK_MAC_TYPE_NONE		0
#define ELINK_MAC_TYPE_EMAC		1
#define ELINK_MAC_TYPE_BMAC		2
#define ELINK_MAC_TYPE_UMAC		3
#define ELINK_MAC_TYPE_XMAC		4

	vmk_uint8 phy_link_up; /* internal phy link indication */
	vmk_uint8 link_up;

	vmk_uint16 line_speed;
	vmk_uint16 duplex;

	vmk_uint16 flow_ctrl;
	vmk_uint16 ieee_fc;

	/* The same definitions as the shmem parameter */
	vmk_uint32 link_status;
	vmk_uint32 eee_status;
	vmk_uint8 fault_detected;
	vmk_uint8 check_kr2_recovery_cnt;
#define ELINK_CHECK_KR2_RECOVERY_CNT	5
	vmk_uint16 periodic_flags;
#define ELINK_PERIODIC_FLAGS_LINK_EVENT	0x0001

	vmk_uint32 aeu_int_mask;
	vmk_uint8 rx_tx_asic_rst;
	vmk_uint8 turn_to_run_wc_rt;
	vmk_uint16 rsrv2;

};

/***********************************************************/
/*                         Functions                       */
/***********************************************************/
elink_status_t elink_phy_init(struct elink_params *params, struct elink_vars *vars);

/* Reset the link. Should be called when driver or interface goes down
   Before calling phy firmware upgrade, the reset_ext_phy should be set
   to 0 */
elink_status_t elink_link_reset(struct elink_params *params, struct elink_vars *vars,
		     vmk_uint8 reset_ext_phy);
elink_status_t elink_lfa_reset(struct elink_params *params, struct elink_vars *vars);
/* elink_link_update should be called upon link interrupt */
elink_status_t elink_link_update(struct elink_params *params, struct elink_vars *vars);

/* use the following phy functions to read/write from external_phy
  In order to use it to read/write internal phy registers, use
  ELINK_DEFAULT_PHY_DEV_ADDR as devad, and (_bank + (_addr & 0xf)) as
  the register */
elink_status_t elink_phy_read(struct elink_params *params, vmk_uint8 phy_addr,
		   vmk_uint8 devad, vmk_uint16 reg, vmk_uint16 *ret_val);

elink_status_t elink_phy_write(struct elink_params *params, vmk_uint8 phy_addr,
		    vmk_uint8 devad, vmk_uint16 reg, vmk_uint16 val);

/* Reads the link_status from the shmem,
   and update the link vars accordingly */
void elink_link_status_update(struct elink_params *input,
			    struct elink_vars *output);
/* returns string representing the fw_version of the external phy */
elink_status_t elink_get_ext_phy_fw_version(struct elink_params *params, vmk_uint8 *version,
				 vmk_uint16 len);

/* Set/Unset the led
   Basically, the CLC takes care of the led for the link, but in case one needs
   to set/unset the led unnaturally, set the "mode" to ELINK_LED_MODE_OPER to
   blink the led, and ELINK_LED_MODE_OFF to set the led off.*/
elink_status_t elink_set_led(struct elink_params *params,
		  struct elink_vars *vars, vmk_uint8 mode, vmk_uint32 speed);
#define ELINK_LED_MODE_OFF			0
#define ELINK_LED_MODE_ON			1
#define ELINK_LED_MODE_OPER			2
#define ELINK_LED_MODE_FRONT_PANEL_OFF	3

/* elink_handle_module_detect_int should be called upon module detection
   interrupt */
void elink_handle_module_detect_int(struct elink_params *params);

/* Get the actual link status. In case it returns ELINK_STATUS_OK, link is up,
	otherwise link is down*/
elink_status_t elink_test_link(struct elink_params *params, struct elink_vars *vars,
		    vmk_uint8 is_serdes);


/* One-time initialization for external phy after power up */
elink_status_t elink_common_init_phy(struct qfle3_adapter *adapter, vmk_uint32 shmem_base_path[],
			  vmk_uint32 shmem2_base_path[], vmk_uint32 chip_id, vmk_uint8 one_port_enabled);

/* Reset the external PHY using GPIO */
void elink_ext_phy_hw_reset(struct qfle3_adapter *adapter, vmk_uint8 port);

/* Reset the external of SFX7101 */
void elink_sfx7101_sp_sw_reset(struct qfle3_adapter *adapter, struct elink_phy *phy);

/* Read "byte_cnt" bytes from address "addr" from the SFP+ EEPROM */
elink_status_t elink_read_sfp_module_eeprom(struct elink_phy *phy,
				 struct elink_params *params, vmk_uint8 dev_addr,
				 vmk_uint16 addr, vmk_uint16 byte_cnt, vmk_uint8 *o_buf);

void elink_hw_reset_phy(struct elink_params *params);

/* Check swap bit and adjust PHY order */
vmk_uint32 elink_phy_selection(struct elink_params *params);

/* Probe the phys on board, and populate them in "params" */
elink_status_t elink_phy_probe(struct elink_params *params);

/* Checks if fan failure detection is required on one of the phys on board */
vmk_uint8 elink_fan_failure_det_req(struct qfle3_adapter *adapter, vmk_uint32 shmem_base,
			     vmk_uint32 shmem2_base, vmk_uint8 port);

/* Open / close the gate between the NIG and the BRB */
void elink_set_rx_filter(struct elink_params *params, vmk_uint8 en);

/* DCBX structs */

/* Number of maximum COS per chip */
#define ELINK_DCBX_E2E3_MAX_NUM_COS		(2)
#define ELINK_DCBX_E3B0_MAX_NUM_COS_PORT0	(6)
#define ELINK_DCBX_E3B0_MAX_NUM_COS_PORT1	(3)
#define ELINK_DCBX_E3B0_MAX_NUM_COS		( \
			ELINK_MAXVAL(ELINK_DCBX_E3B0_MAX_NUM_COS_PORT0, \
			    ELINK_DCBX_E3B0_MAX_NUM_COS_PORT1))

#define ELINK_DCBX_MAX_NUM_COS			( \
			ELINK_MAXVAL(ELINK_DCBX_E3B0_MAX_NUM_COS, \
			    ELINK_DCBX_E2E3_MAX_NUM_COS))

/* PFC port configuration params */
struct elink_nig_brb_pfc_port_params {
	/* NIG */
	vmk_uint32 pause_enable;
	vmk_uint32 llfc_out_en;
	vmk_uint32 llfc_enable;
	vmk_uint32 pkt_priority_to_cos;
	vmk_uint8 num_of_rx_cos_priority_mask;
	vmk_uint32 rx_cos_priority_mask[ELINK_DCBX_MAX_NUM_COS];
	vmk_uint32 llfc_high_priority_classes;
	vmk_uint32 llfc_low_priority_classes;
};


/* ETS port configuration params */
struct elink_ets_bw_params {
	vmk_uint8 bw;
};

struct elink_ets_sp_params {
	/**
	 * valid values are 0 - 5. 0 is highest strict priority.
	 * There can't be two COS's with the same pri.
	 */
	vmk_uint8 pri;
};

enum elink_cos_state {
	elink_cos_state_strict = 0,
	elink_cos_state_bw = 1,
};

struct elink_ets_cos_params {
	enum elink_cos_state state ;
	union {
		struct elink_ets_bw_params bw_params;
		struct elink_ets_sp_params sp_params;
	} params;
};

struct elink_ets_params {
	vmk_uint8 num_of_cos; /* Number of valid COS entries*/
	struct elink_ets_cos_params cos[ELINK_DCBX_MAX_NUM_COS];
};

/* Used to update the PFC attributes in EMAC, BMAC, NIG and BRB
 * when link is already up
 */
elink_status_t elink_update_pfc(struct elink_params *params,
		      struct elink_vars *vars,
		      struct elink_nig_brb_pfc_port_params *pfc_params);


/* Used to configure the ETS to disable */
elink_status_t elink_ets_disabled(struct elink_params *params,
		       struct elink_vars *vars);

/* Used to configure the ETS to BW limited */
void elink_ets_bw_limit(const struct elink_params *params, const vmk_uint32 cos0_bw,
			const vmk_uint32 cos1_bw);

/* Used to configure the ETS to strict */
elink_status_t elink_ets_strict(const struct elink_params *params, const vmk_uint8 strict_cos);


/*  Configure the COS to ETS according to BW and SP settings.*/
elink_status_t elink_ets_e3b0_config(const struct elink_params *params,
			 const struct elink_vars *vars,
			 struct elink_ets_params *ets_params);
/* Read pfc statistic*/
void elink_pfc_statistic(struct elink_params *params, struct elink_vars *vars,
						 vmk_uint32 pfc_frames_sent[2],
						 vmk_uint32 pfc_frames_received[2]);
void elink_init_mod_abs_int(struct qfle3_adapter *adapter, struct elink_vars *vars,
			    vmk_uint32 chip_id, vmk_uint32 shmem_base, vmk_uint32 shmem2_base,
			    vmk_uint8 port);

void elink_period_func(struct elink_params *params, struct elink_vars *vars);


void elink_enable_pmd_tx(struct elink_params *params);



#endif /*__QFLE3_ECORE_LINK_H__*/
