/*******************************************************************************
 * See COPYRIGHT.txt & LICENSE.txt for copyright and licensing details.
 *******************************************************************************/

#ifndef __57XX_ISCSI_HSI_LE__
#define __57XX_ISCSI_HSI_LE__

/*
 * iSCSI Async CQE
 */
struct iscsi_async_msg {
	vmk_uint16 reserved0;
	vmk_uint8 reserved1;
	vmk_uint8 op_code;
	vmk_uint32 reserved2;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 reserved3[2];
	vmk_uint8 reserved4;
	vmk_uint8 err_code;
	vmk_uint16 reserved5;
	vmk_uint32 reserved6;
	vmk_uint32 lun[2];
	vmk_uint16 param1;
	vmk_uint8 async_vcode;
	vmk_uint8 async_event;
	vmk_uint16 param3;
	vmk_uint16 param2;
	vmk_uint32 reserved7[3];
	vmk_uint32 cq_req_sn;
};


/*
 * iSCSI Buffer Descriptor (BD)
 */
struct iscsi_bd {
	vmk_uint32 buffer_addr_hi;
	vmk_uint32 buffer_addr_lo;
	vmk_uint16 buffer_length;
	vmk_uint16 reserved0;
	vmk_uint16 flags;
#define ISCSI_BD_RESERVED1 (0x3F<<0)
#define ISCSI_BD_RESERVED1_SHIFT 0
#define ISCSI_BD_LAST_IN_BD_CHAIN (0x1<<6)
#define ISCSI_BD_LAST_IN_BD_CHAIN_SHIFT 6
#define ISCSI_BD_FIRST_IN_BD_CHAIN (0x1<<7)
#define ISCSI_BD_FIRST_IN_BD_CHAIN_SHIFT 7
#define ISCSI_BD_RESERVED2 (0xFF<<8)
#define ISCSI_BD_RESERVED2_SHIFT 8
	vmk_uint16 reserved3;
};


/*
 * iSCSI Cleanup SQ WQE
 */
struct iscsi_cleanup_request {
	vmk_uint16 reserved0;
	vmk_uint8 reserved1;
	vmk_uint8 op_code;
	vmk_uint32 reserved2[3];
	vmk_uint16 itt;
#define ISCSI_CLEANUP_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_CLEANUP_REQUEST_INDEX_SHIFT 0
#define ISCSI_CLEANUP_REQUEST_TYPE (0x3<<14)
#define ISCSI_CLEANUP_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved3;
	vmk_uint32 reserved4[10];
	vmk_uint16 reserved5;
	vmk_uint8 reserved6;
	vmk_uint8 cq_index;
};


/*
 * iSCSI Cleanup CQE
 */
struct iscsi_cleanup_response {
	vmk_uint16 reserved0;
	vmk_uint8 status;
	vmk_uint8 op_code;
	vmk_uint32 reserved1[3];
	vmk_uint32 reserved2[2];
	vmk_uint8 reserved3;
	vmk_uint8 err_code;
	vmk_uint16 reserved4;
	vmk_uint32 reserved5[7];
	vmk_uint16 itt;
#define ISCSI_CLEANUP_RESPONSE_INDEX (0x3FFF<<0)
#define ISCSI_CLEANUP_RESPONSE_INDEX_SHIFT 0
#define ISCSI_CLEANUP_RESPONSE_TYPE (0x3<<14)
#define ISCSI_CLEANUP_RESPONSE_TYPE_SHIFT 14
	vmk_uint16 reserved6;
	vmk_uint32 cq_req_sn;
};


/*
 * SCSI read/write SQ WQE
 */
struct iscsi_cmd_request {
	vmk_uint16 reserved0;
	vmk_uint8 op_attr;
#define ISCSI_CMD_REQUEST_TASK_ATTR (0x7<<0)
#define ISCSI_CMD_REQUEST_TASK_ATTR_SHIFT 0
#define ISCSI_CMD_REQUEST_RESERVED1 (0x3<<3)
#define ISCSI_CMD_REQUEST_RESERVED1_SHIFT 3
#define ISCSI_CMD_REQUEST_WRITE (0x1<<5)
#define ISCSI_CMD_REQUEST_WRITE_SHIFT 5
#define ISCSI_CMD_REQUEST_READ (0x1<<6)
#define ISCSI_CMD_REQUEST_READ_SHIFT 6
#define ISCSI_CMD_REQUEST_FINAL (0x1<<7)
#define ISCSI_CMD_REQUEST_FINAL_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint16 sd_buffer_offset;
	vmk_uint16 ud_buffer_offset;
	vmk_uint32 lun[2];
	vmk_uint16 itt;
#define ISCSI_CMD_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_CMD_REQUEST_INDEX_SHIFT 0
#define ISCSI_CMD_REQUEST_TYPE (0x3<<14)
#define ISCSI_CMD_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved2;
	vmk_uint32 total_data_transfer_length;
	vmk_uint32 cmd_sn;
	vmk_uint32 reserved3;
	vmk_uint32 cdb[4];
	vmk_uint32 zero_fill;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 ud_start_bd_index;
	vmk_uint8 sd_start_bd_index;
	vmk_uint8 cq_index;
};


/*
 * task statistics for write response
 */
struct iscsi_write_resp_task_stat {
	vmk_uint16 num_data_outs;
	vmk_uint16 num_r2ts;
};

/*
 * task statistics for read response
 */
struct iscsi_read_resp_task_stat {
	vmk_uint16 num_data_ins;
	vmk_uint16 reserved;
};

/*
 * task statistics for iSCSI cmd response
 */
union iscsi_cmd_resp_task_stat {
	struct iscsi_write_resp_task_stat write_stat;
	struct iscsi_read_resp_task_stat read_stat;
};

/*
 * SCSI Command CQE
 */
struct iscsi_cmd_response {
	vmk_uint8 status;
	vmk_uint8 response;
	vmk_uint8 response_flags;
#define ISCSI_CMD_RESPONSE_RESERVED0 (0x1<<0)
#define ISCSI_CMD_RESPONSE_RESERVED0_SHIFT 0
#define ISCSI_CMD_RESPONSE_RESIDUAL_UNDERFLOW (0x1<<1)
#define ISCSI_CMD_RESPONSE_RESIDUAL_UNDERFLOW_SHIFT 1
#define ISCSI_CMD_RESPONSE_RESIDUAL_OVERFLOW (0x1<<2)
#define ISCSI_CMD_RESPONSE_RESIDUAL_OVERFLOW_SHIFT 2
#define ISCSI_CMD_RESPONSE_BR_RESIDUAL_UNDERFLOW (0x1<<3)
#define ISCSI_CMD_RESPONSE_BR_RESIDUAL_UNDERFLOW_SHIFT 3
#define ISCSI_CMD_RESPONSE_BR_RESIDUAL_OVERFLOW (0x1<<4)
#define ISCSI_CMD_RESPONSE_BR_RESIDUAL_OVERFLOW_SHIFT 4
#define ISCSI_CMD_RESPONSE_RESERVED1 (0x7<<5)
#define ISCSI_CMD_RESPONSE_RESERVED1_SHIFT 5
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 reserved2;
	vmk_uint32 residual_count;
	vmk_uint8 reserved3;
	vmk_uint8 err_code;
	vmk_uint16 reserved4;
	vmk_uint32 reserved5[5];
	union iscsi_cmd_resp_task_stat task_stat;
	vmk_uint32 reserved6;
	vmk_uint16 itt;
#define ISCSI_CMD_RESPONSE_INDEX (0x3FFF<<0)
#define ISCSI_CMD_RESPONSE_INDEX_SHIFT 0
#define ISCSI_CMD_RESPONSE_TYPE (0x3<<14)
#define ISCSI_CMD_RESPONSE_TYPE_SHIFT 14
	vmk_uint16 reserved7;
	vmk_uint32 cq_req_sn;
};



/*
 * firmware middle-path request SQ WQE
 */
struct iscsi_fw_mp_request {
	vmk_uint16 hdr_opaque1;
	vmk_uint8 op_attr;
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 hdr_opaque2[2];
	vmk_uint16 itt;
#define ISCSI_FW_MP_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_FW_MP_REQUEST_INDEX_SHIFT 0
#define ISCSI_FW_MP_REQUEST_TYPE (0x3<<14)
#define ISCSI_FW_MP_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved0;
	vmk_uint32 hdr_opaque3[4];
	vmk_uint32 resp_bd_list_addr_lo;
	vmk_uint32 resp_bd_list_addr_hi;
	vmk_uint32 resp_buffer;
#define ISCSI_FW_MP_REQUEST_RESP_BUFFER_LENGTH (0xFFFFFF<<0)
#define ISCSI_FW_MP_REQUEST_RESP_BUFFER_LENGTH_SHIFT 0
#define ISCSI_FW_MP_REQUEST_NUM_RESP_BDS (0xFF<<24)
#define ISCSI_FW_MP_REQUEST_NUM_RESP_BDS_SHIFT 24
	vmk_uint8 flags;
#define ISCSI_FW_MP_REQUEST_RESERVED1 (0x1<<0)
#define ISCSI_FW_MP_REQUEST_RESERVED1_SHIFT 0
#define ISCSI_FW_MP_REQUEST_LOCAL_COMPLETION (0x1<<1)
#define ISCSI_FW_MP_REQUEST_LOCAL_COMPLETION_SHIFT 1
#define ISCSI_FW_MP_REQUEST_UPDATE_EXP_STAT_SN (0x1<<2)
#define ISCSI_FW_MP_REQUEST_UPDATE_EXP_STAT_SN_SHIFT 2
#define ISCSI_FW_MP_REQUEST_RESERVED2 (0x1F<<3)
#define ISCSI_FW_MP_REQUEST_RESERVED2_SHIFT 3
	vmk_uint8 reserved3;
	vmk_uint16 reserved4;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 reserved5;
	vmk_uint8 reserved6;
	vmk_uint8 cq_index;
};


/*
 * firmware response - CQE: used only by firmware
 */
struct iscsi_fw_response {
	vmk_uint32 hdr_dword1[2];
	vmk_uint32 hdr_exp_cmd_sn;
	vmk_uint32 hdr_max_cmd_sn;
	vmk_uint32 hdr_ttt;
	vmk_uint32 hdr_res_cnt;
	vmk_uint32 cqe_flags;
#define ISCSI_FW_RESPONSE_RESERVED2 (0xFF<<0)
#define ISCSI_FW_RESPONSE_RESERVED2_SHIFT 0
#define ISCSI_FW_RESPONSE_ERR_CODE (0xFF<<8)
#define ISCSI_FW_RESPONSE_ERR_CODE_SHIFT 8
#define ISCSI_FW_RESPONSE_RESERVED3 (0xFFFF<<16)
#define ISCSI_FW_RESPONSE_RESERVED3_SHIFT 16
	vmk_uint32 stat_sn;
	vmk_uint32 hdr_dword2[2];
	vmk_uint32 hdr_dword3[2];
	vmk_uint32 task_stat;
	vmk_uint32 reserved0;
	vmk_uint32 hdr_itt;
	vmk_uint32 cq_req_sn;
};


/*
 * iSCSI KCQ CQE parameters
 */
union iscsi_kcqe_params {
	vmk_uint32 reserved0[4];
};

/*
 * iSCSI KCQ CQE
 */
struct iscsi_kcqe {
	vmk_uint32 iscsi_conn_id;
	vmk_uint32 completion_status;
	vmk_uint32 iscsi_conn_context_id;
	union iscsi_kcqe_params params;
	vmk_uint16 qe_self_seq;
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define ISCSI_KCQE_RESERVED0 (0xF<<0)
#define ISCSI_KCQE_RESERVED0_SHIFT 0
#define ISCSI_KCQE_LAYER_CODE (0x7<<4)
#define ISCSI_KCQE_LAYER_CODE_SHIFT 4
#define ISCSI_KCQE_RESERVED1 (0x1<<7)
#define ISCSI_KCQE_RESERVED1_SHIFT 7
};



/*
 * iSCSI KWQE header
 */
struct iscsi_kwqe_header {
	vmk_uint8 op_code;
	vmk_uint8 flags;
#define ISCSI_KWQE_HEADER_RESERVED0 (0xF<<0)
#define ISCSI_KWQE_HEADER_RESERVED0_SHIFT 0
#define ISCSI_KWQE_HEADER_LAYER_CODE (0x7<<4)
#define ISCSI_KWQE_HEADER_LAYER_CODE_SHIFT 4
#define ISCSI_KWQE_HEADER_RESERVED1 (0x1<<7)
#define ISCSI_KWQE_HEADER_RESERVED1_SHIFT 7
};

/*
 * iSCSI firmware init request 1
 */
struct iscsi_kwqe_init1 {
	vmk_uint8 num_cqs;
	vmk_uint8 reserved0;
	struct iscsi_kwqe_header hdr;
	vmk_uint32 dummy_buffer_addr_lo;
	vmk_uint32 dummy_buffer_addr_hi;
	vmk_uint16 num_tasks_per_conn;
	vmk_uint16 num_ccells_per_conn;
	vmk_uint16 sq_num_wqes;
	vmk_uint16 sq_wqes_per_page;
	vmk_uint16 cq_num_wqes;
	vmk_uint8 flags;
#define ISCSI_KWQE_INIT1_PAGE_SIZE (0xF<<0)
#define ISCSI_KWQE_INIT1_PAGE_SIZE_SHIFT 0
#define ISCSI_KWQE_INIT1_DELAYED_ACK_ENABLE (0x1<<4)
#define ISCSI_KWQE_INIT1_DELAYED_ACK_ENABLE_SHIFT 4
#define ISCSI_KWQE_INIT1_KEEP_ALIVE_ENABLE (0x1<<5)
#define ISCSI_KWQE_INIT1_KEEP_ALIVE_ENABLE_SHIFT 5
#define ISCSI_KWQE_INIT1_TIME_STAMPS_ENABLE (0x1<<6)
#define ISCSI_KWQE_INIT1_TIME_STAMPS_ENABLE_SHIFT 6
#define ISCSI_KWQE_INIT1_RESERVED1 (0x1<<7)
#define ISCSI_KWQE_INIT1_RESERVED1_SHIFT 7
	vmk_uint8 cq_log_wqes_per_page;
	vmk_uint16 sq_num_pages;
	vmk_uint16 cq_num_pages;
	vmk_uint16 rq_num_wqes;
	vmk_uint16 rq_buffer_size;
};

/*
 * iSCSI firmware init request 2
 */
struct iscsi_kwqe_init2 {
	vmk_uint16 max_cq_sqn;
	struct iscsi_kwqe_header hdr;
	vmk_uint32 error_bit_map[2];
	vmk_uint32 reserved1[5];
};

/*
 * Initial iSCSI connection offload request 1
 */
struct iscsi_kwqe_conn_offload1 {
	vmk_uint16 iscsi_conn_id;
	struct iscsi_kwqe_header hdr;
	vmk_uint32 sq_page_table_addr_lo;
	vmk_uint32 sq_page_table_addr_hi;
	vmk_uint32 cq_page_table_addr_lo;
	vmk_uint32 cq_page_table_addr_hi;
	vmk_uint32 reserved0[3];
};

/*
 * iSCSI Page Table Entry (PTE)
 */
struct iscsi_pte {
	vmk_uint32 hi;
	vmk_uint32 lo;
};

/*
 * Initial iSCSI connection offload request 2
 */
struct iscsi_kwqe_conn_offload2 {
	vmk_uint16 reserved0;
	struct iscsi_kwqe_header hdr;
	vmk_uint32 rq_page_table_addr_lo;
	vmk_uint32 rq_page_table_addr_hi;
	struct iscsi_pte sq_first_pte;
	struct iscsi_pte cq_first_pte;
	vmk_uint32 num_additional_wqes;
};


/*
 * Initial iSCSI connection offload request 3
 */
struct iscsi_kwqe_conn_offload3 {
	vmk_uint16 reserved0;
	struct iscsi_kwqe_header hdr;
	vmk_uint32 reserved1;
	struct iscsi_pte qp_first_pte[3];
};


/*
 * iSCSI connection update request
 */
struct iscsi_kwqe_conn_update {
	vmk_uint16 reserved0;
	struct iscsi_kwqe_header hdr;
	vmk_uint8 conn_flags;
#define ISCSI_KWQE_CONN_UPDATE_HEADER_DIGEST (0x1<<0)
#define ISCSI_KWQE_CONN_UPDATE_HEADER_DIGEST_SHIFT 0
#define ISCSI_KWQE_CONN_UPDATE_DATA_DIGEST (0x1<<1)
#define ISCSI_KWQE_CONN_UPDATE_DATA_DIGEST_SHIFT 1
#define ISCSI_KWQE_CONN_UPDATE_INITIAL_R2T (0x1<<2)
#define ISCSI_KWQE_CONN_UPDATE_INITIAL_R2T_SHIFT 2
#define ISCSI_KWQE_CONN_UPDATE_IMMEDIATE_DATA (0x1<<3)
#define ISCSI_KWQE_CONN_UPDATE_IMMEDIATE_DATA_SHIFT 3
#define ISCSI_KWQE_CONN_UPDATE_OOO_SUPPORT_MODE (0x3<<4)
#define ISCSI_KWQE_CONN_UPDATE_OOO_SUPPORT_MODE_SHIFT 4
#define ISCSI_KWQE_CONN_UPDATE_RESERVED1 (0x3<<6)
#define ISCSI_KWQE_CONN_UPDATE_RESERVED1_SHIFT 6
	vmk_uint8 reserved2;
	vmk_uint8 max_outstanding_r2ts;
	vmk_uint8 session_error_recovery_level;
	vmk_uint32 context_id;
	vmk_uint32 max_send_pdu_length;
	vmk_uint32 max_recv_pdu_length;
	vmk_uint32 first_burst_length;
	vmk_uint32 max_burst_length;
	vmk_uint32 exp_stat_sn;
};

/*
 * iSCSI destroy connection request
 */
struct iscsi_kwqe_conn_destroy {
	vmk_uint16 reserved0;
	struct iscsi_kwqe_header hdr;
	vmk_uint32 context_id;
	vmk_uint32 reserved1[6];
};

/*
 * iSCSI KWQ WQE
 */
union iscsi_kwqe {
	struct iscsi_kwqe_init1 init1;
	struct iscsi_kwqe_init2 init2;
	struct iscsi_kwqe_conn_offload1 conn_offload1;
	struct iscsi_kwqe_conn_offload2 conn_offload2;
	struct iscsi_kwqe_conn_update conn_update;
	struct iscsi_kwqe_conn_destroy conn_destroy;
};









/*
 * iSCSI Login SQ WQE
 */
struct iscsi_login_request {
	vmk_uint8 version_min;
	vmk_uint8 version_max;
	vmk_uint8 op_attr;
#define ISCSI_LOGIN_REQUEST_NEXT_STAGE (0x3<<0)
#define ISCSI_LOGIN_REQUEST_NEXT_STAGE_SHIFT 0
#define ISCSI_LOGIN_REQUEST_CURRENT_STAGE (0x3<<2)
#define ISCSI_LOGIN_REQUEST_CURRENT_STAGE_SHIFT 2
#define ISCSI_LOGIN_REQUEST_RESERVED0 (0x3<<4)
#define ISCSI_LOGIN_REQUEST_RESERVED0_SHIFT 4
#define ISCSI_LOGIN_REQUEST_CONT (0x1<<6)
#define ISCSI_LOGIN_REQUEST_CONT_SHIFT 6
#define ISCSI_LOGIN_REQUEST_TRANSIT (0x1<<7)
#define ISCSI_LOGIN_REQUEST_TRANSIT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 isid_lo;
	vmk_uint16 tsih;
	vmk_uint16 isid_hi;
	vmk_uint16 itt;
#define ISCSI_LOGIN_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_LOGIN_REQUEST_INDEX_SHIFT 0
#define ISCSI_LOGIN_REQUEST_TYPE (0x3<<14)
#define ISCSI_LOGIN_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved2;
	vmk_uint16 reserved3;
	vmk_uint16 cid;
	vmk_uint32 cmd_sn;
	vmk_uint32 exp_stat_sn;
	vmk_uint32 reserved4;
	vmk_uint32 resp_bd_list_addr_lo;
	vmk_uint32 resp_bd_list_addr_hi;
	vmk_uint32 resp_buffer;
#define ISCSI_LOGIN_REQUEST_RESP_BUFFER_LENGTH (0xFFFFFF<<0)
#define ISCSI_LOGIN_REQUEST_RESP_BUFFER_LENGTH_SHIFT 0
#define ISCSI_LOGIN_REQUEST_NUM_RESP_BDS (0xFF<<24)
#define ISCSI_LOGIN_REQUEST_NUM_RESP_BDS_SHIFT 24
	vmk_uint8 flags;
#define ISCSI_LOGIN_REQUEST_RESERVED5 (0x3<<0)
#define ISCSI_LOGIN_REQUEST_RESERVED5_SHIFT 0
#define ISCSI_LOGIN_REQUEST_UPDATE_EXP_STAT_SN (0x1<<2)
#define ISCSI_LOGIN_REQUEST_UPDATE_EXP_STAT_SN_SHIFT 2
#define ISCSI_LOGIN_REQUEST_RESERVED6 (0x1F<<3)
#define ISCSI_LOGIN_REQUEST_RESERVED6_SHIFT 3
	vmk_uint8 reserved7;
	vmk_uint16 reserved8;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 reserved9;
	vmk_uint8 reserved10;
	vmk_uint8 cq_index;
};


/*
 * iSCSI Login CQE
 */
struct iscsi_login_response {
	vmk_uint8 version_active;
	vmk_uint8 version_max;
	vmk_uint8 response_flags;
#define ISCSI_LOGIN_RESPONSE_NEXT_STAGE (0x3<<0)
#define ISCSI_LOGIN_RESPONSE_NEXT_STAGE_SHIFT 0
#define ISCSI_LOGIN_RESPONSE_CURRENT_STAGE (0x3<<2)
#define ISCSI_LOGIN_RESPONSE_CURRENT_STAGE_SHIFT 2
#define ISCSI_LOGIN_RESPONSE_RESERVED0 (0x3<<4)
#define ISCSI_LOGIN_RESPONSE_RESERVED0_SHIFT 4
#define ISCSI_LOGIN_RESPONSE_CONT (0x1<<6)
#define ISCSI_LOGIN_RESPONSE_CONT_SHIFT 6
#define ISCSI_LOGIN_RESPONSE_TRANSIT (0x1<<7)
#define ISCSI_LOGIN_RESPONSE_TRANSIT_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 reserved1[2];
	vmk_uint8 reserved2;
	vmk_uint8 err_code;
	vmk_uint16 reserved3;
	vmk_uint32 stat_sn;
	vmk_uint32 isid_lo;
	vmk_uint16 tsih;
	vmk_uint16 isid_hi;
	vmk_uint16 reserved4;
	vmk_uint8 status_detail;
	vmk_uint8 status_class;
	vmk_uint32 reserved5[3];
	vmk_uint16 itt;
#define ISCSI_LOGIN_RESPONSE_INDEX (0x3FFF<<0)
#define ISCSI_LOGIN_RESPONSE_INDEX_SHIFT 0
#define ISCSI_LOGIN_RESPONSE_TYPE (0x3<<14)
#define ISCSI_LOGIN_RESPONSE_TYPE_SHIFT 14
	vmk_uint16 reserved6;
	vmk_uint32 cq_req_sn;
};


/*
 * iSCSI Logout SQ WQE
 */
struct iscsi_logout_request {
	vmk_uint16 reserved0;
	vmk_uint8 op_attr;
#define ISCSI_LOGOUT_REQUEST_REASON (0x7F<<0)
#define ISCSI_LOGOUT_REQUEST_REASON_SHIFT 0
#define ISCSI_LOGOUT_REQUEST_ALWAYS_ONE (0x1<<7)
#define ISCSI_LOGOUT_REQUEST_ALWAYS_ONE_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 reserved1[2];
	vmk_uint16 itt;
#define ISCSI_LOGOUT_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_LOGOUT_REQUEST_INDEX_SHIFT 0
#define ISCSI_LOGOUT_REQUEST_TYPE (0x3<<14)
#define ISCSI_LOGOUT_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved2;
	vmk_uint16 reserved3;
	vmk_uint16 cid;
	vmk_uint32 cmd_sn;
	vmk_uint32 reserved4[5];
	vmk_uint32 zero_fill;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 reserved5;
	vmk_uint8 reserved6;
	vmk_uint8 cq_index;
};


/*
 * iSCSI Logout CQE
 */
struct iscsi_logout_response {
	vmk_uint8 reserved0;
	vmk_uint8 response;
	vmk_uint8 reserved1;
	vmk_uint8 op_code;
	vmk_uint32 reserved2;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 reserved3[2];
	vmk_uint8 reserved4;
	vmk_uint8 err_code;
	vmk_uint16 reserved5;
	vmk_uint32 reserved6[3];
	vmk_uint16 time_to_retain;
	vmk_uint16 time_to_wait;
	vmk_uint32 reserved7[3];
	vmk_uint16 itt;
#define ISCSI_LOGOUT_RESPONSE_INDEX (0x3FFF<<0)
#define ISCSI_LOGOUT_RESPONSE_INDEX_SHIFT 0
#define ISCSI_LOGOUT_RESPONSE_TYPE (0x3<<14)
#define ISCSI_LOGOUT_RESPONSE_TYPE_SHIFT 14
	vmk_uint16 reserved8;
	vmk_uint32 cq_req_sn;
};


/*
 * iSCSI Nop-In CQE
 */
struct iscsi_nop_in_msg {
	vmk_uint16 reserved0;
	vmk_uint8 reserved1;
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 ttt;
	vmk_uint32 reserved2;
	vmk_uint8 reserved3;
	vmk_uint8 err_code;
	vmk_uint16 reserved4;
	vmk_uint32 reserved5;
	vmk_uint32 lun[2];
	vmk_uint32 reserved6[4];
	vmk_uint16 itt;
#define ISCSI_NOP_IN_MSG_INDEX (0x3FFF<<0)
#define ISCSI_NOP_IN_MSG_INDEX_SHIFT 0
#define ISCSI_NOP_IN_MSG_TYPE (0x3<<14)
#define ISCSI_NOP_IN_MSG_TYPE_SHIFT 14
	vmk_uint16 reserved7;
	vmk_uint32 cq_req_sn;
};


/*
 * iSCSI NOP-OUT SQ WQE
 */
struct iscsi_nop_out_request {
	vmk_uint16 reserved0;
	vmk_uint8 op_attr;
#define ISCSI_NOP_OUT_REQUEST_RESERVED1 (0x7F<<0)
#define ISCSI_NOP_OUT_REQUEST_RESERVED1_SHIFT 0
#define ISCSI_NOP_OUT_REQUEST_ALWAYS_ONE (0x1<<7)
#define ISCSI_NOP_OUT_REQUEST_ALWAYS_ONE_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 lun[2];
	vmk_uint16 itt;
#define ISCSI_NOP_OUT_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_NOP_OUT_REQUEST_INDEX_SHIFT 0
#define ISCSI_NOP_OUT_REQUEST_TYPE (0x3<<14)
#define ISCSI_NOP_OUT_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved2;
	vmk_uint32 ttt;
	vmk_uint32 cmd_sn;
	vmk_uint32 reserved3[2];
	vmk_uint32 resp_bd_list_addr_lo;
	vmk_uint32 resp_bd_list_addr_hi;
	vmk_uint32 resp_buffer;
#define ISCSI_NOP_OUT_REQUEST_RESP_BUFFER_LENGTH (0xFFFFFF<<0)
#define ISCSI_NOP_OUT_REQUEST_RESP_BUFFER_LENGTH_SHIFT 0
#define ISCSI_NOP_OUT_REQUEST_NUM_RESP_BDS (0xFF<<24)
#define ISCSI_NOP_OUT_REQUEST_NUM_RESP_BDS_SHIFT 24
	vmk_uint8 flags;
#define ISCSI_NOP_OUT_REQUEST_RESERVED4 (0x1<<0)
#define ISCSI_NOP_OUT_REQUEST_RESERVED4_SHIFT 0
#define ISCSI_NOP_OUT_REQUEST_LOCAL_COMPLETION (0x1<<1)
#define ISCSI_NOP_OUT_REQUEST_LOCAL_COMPLETION_SHIFT 1
#define ISCSI_NOP_OUT_REQUEST_ZERO_FILL (0x3F<<2)
#define ISCSI_NOP_OUT_REQUEST_ZERO_FILL_SHIFT 2
	vmk_uint8 reserved6;
	vmk_uint16 reserved7;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 reserved8;
	vmk_uint8 reserved9;
	vmk_uint8 cq_index;
};




/*
 * iSCSI Reject CQE
 */
struct iscsi_reject_msg {
	vmk_uint8 reserved0;
	vmk_uint8 reason;
	vmk_uint8 reserved1;
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 reserved2[2];
	vmk_uint8 reserved3;
	vmk_uint8 err_code;
	vmk_uint16 reserved4;
	vmk_uint32 reserved5[8];
	vmk_uint32 cq_req_sn;
};


/*
 * iSCSI TMF SQ WQE
 */
struct iscsi_tmf_request {
	vmk_uint16 reserved0;
	vmk_uint8 op_attr;
#define ISCSI_TMF_REQUEST_FUNCTION (0x7F<<0)
#define ISCSI_TMF_REQUEST_FUNCTION_SHIFT 0
#define ISCSI_TMF_REQUEST_ALWAYS_ONE (0x1<<7)
#define ISCSI_TMF_REQUEST_ALWAYS_ONE_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 lun[2];
	vmk_uint16 itt;
#define ISCSI_TMF_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_TMF_REQUEST_INDEX_SHIFT 0
#define ISCSI_TMF_REQUEST_TYPE (0x3<<14)
#define ISCSI_TMF_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved1;
	vmk_uint32 ref_itt;
	vmk_uint32 cmd_sn;
	vmk_uint32 reserved2;
	vmk_uint32 ref_cmd_sn;
	vmk_uint32 reserved3[3];
	vmk_uint32 zero_fill;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 reserved4;
	vmk_uint8 reserved5;
	vmk_uint8 cq_index;
};

/*
 * iSCSI Text SQ WQE
 */
struct iscsi_text_request {
	vmk_uint16 reserved0;
	vmk_uint8 op_attr;
#define ISCSI_TEXT_REQUEST_RESERVED1 (0x3F<<0)
#define ISCSI_TEXT_REQUEST_RESERVED1_SHIFT 0
#define ISCSI_TEXT_REQUEST_CONT (0x1<<6)
#define ISCSI_TEXT_REQUEST_CONT_SHIFT 6
#define ISCSI_TEXT_REQUEST_FINAL (0x1<<7)
#define ISCSI_TEXT_REQUEST_FINAL_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 lun[2];
	vmk_uint16 itt;
#define ISCSI_TEXT_REQUEST_INDEX (0x3FFF<<0)
#define ISCSI_TEXT_REQUEST_INDEX_SHIFT 0
#define ISCSI_TEXT_REQUEST_TYPE (0x3<<14)
#define ISCSI_TEXT_REQUEST_TYPE_SHIFT 14
	vmk_uint16 reserved3;
	vmk_uint32 ttt;
	vmk_uint32 cmd_sn;
	vmk_uint32 reserved4[2];
	vmk_uint32 resp_bd_list_addr_lo;
	vmk_uint32 resp_bd_list_addr_hi;
	vmk_uint32 resp_buffer;
#define ISCSI_TEXT_REQUEST_RESP_BUFFER_LENGTH (0xFFFFFF<<0)
#define ISCSI_TEXT_REQUEST_RESP_BUFFER_LENGTH_SHIFT 0
#define ISCSI_TEXT_REQUEST_NUM_RESP_BDS (0xFF<<24)
#define ISCSI_TEXT_REQUEST_NUM_RESP_BDS_SHIFT 24
	vmk_uint32 zero_fill;
	vmk_uint32 bd_list_addr_lo;
	vmk_uint32 bd_list_addr_hi;
	vmk_uint8 num_bds;
	vmk_uint8 reserved6;
	vmk_uint8 reserved7;
	vmk_uint8 cq_index;
};

/*
 * iSCSI SQ WQE
 */
union iscsi_request {
	struct iscsi_cmd_request cmd;
	struct iscsi_tmf_request tmf;
	struct iscsi_nop_out_request nop_out;
	struct iscsi_login_request login_req;
	struct iscsi_text_request text;
	struct iscsi_logout_request logout_req;
	struct iscsi_cleanup_request cleanup;
};


/*
 * iSCSI TMF CQE
 */
struct iscsi_tmf_response {
	vmk_uint8 reserved0;
	vmk_uint8 response;
	vmk_uint8 reserved1;
	vmk_uint8 op_code;
	vmk_uint32 reserved2;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 reserved3[2];
	vmk_uint8 reserved4;
	vmk_uint8 err_code;
	vmk_uint16 reserved5;
	vmk_uint32 reserved6[7];
	vmk_uint16 itt;
#define ISCSI_TMF_RESPONSE_INDEX (0x3FFF<<0)
#define ISCSI_TMF_RESPONSE_INDEX_SHIFT 0
#define ISCSI_TMF_RESPONSE_TYPE (0x3<<14)
#define ISCSI_TMF_RESPONSE_TYPE_SHIFT 14
	vmk_uint16 reserved7;
	vmk_uint32 cq_req_sn;
};

/*
 * iSCSI Text CQE
 */
struct iscsi_text_response {
	vmk_uint16 reserved0;
	vmk_uint8 response_flags;
#define ISCSI_TEXT_RESPONSE_RESERVED1 (0x3F<<0)
#define ISCSI_TEXT_RESPONSE_RESERVED1_SHIFT 0
#define ISCSI_TEXT_RESPONSE_CONT (0x1<<6)
#define ISCSI_TEXT_RESPONSE_CONT_SHIFT 6
#define ISCSI_TEXT_RESPONSE_FINAL (0x1<<7)
#define ISCSI_TEXT_RESPONSE_FINAL_SHIFT 7
	vmk_uint8 op_code;
	vmk_uint32 data_length;
	vmk_uint32 exp_cmd_sn;
	vmk_uint32 max_cmd_sn;
	vmk_uint32 ttt;
	vmk_uint32 reserved2;
	vmk_uint8 reserved3;
	vmk_uint8 err_code;
	vmk_uint16 reserved4;
	vmk_uint32 reserved5;
	vmk_uint32 lun[2];
	vmk_uint32 reserved6[4];
	vmk_uint16 itt;
#define ISCSI_TEXT_RESPONSE_INDEX (0x3FFF<<0)
#define ISCSI_TEXT_RESPONSE_INDEX_SHIFT 0
#define ISCSI_TEXT_RESPONSE_TYPE (0x3<<14)
#define ISCSI_TEXT_RESPONSE_TYPE_SHIFT 14
	vmk_uint16 reserved7;
	vmk_uint32 cq_req_sn;
};

/*
 * iSCSI CQE
 */
union iscsi_response {
	struct iscsi_cmd_response cmd;
	struct iscsi_tmf_response tmf;
	struct iscsi_login_response login_resp;
	struct iscsi_text_response text;
	struct iscsi_logout_response logout_resp;
	struct iscsi_cleanup_response cleanup;
	struct iscsi_reject_msg reject;
	struct iscsi_async_msg async;
	struct iscsi_nop_in_msg nop_in;
};

#endif /* __57XX_ISCSI_HSI_LE__ */
