#ifndef _QFLE3_STATS_H
#define _QFLE3_STATS_H

#include "vmkapi.h"

struct nig_stats {
    vmk_uint32 brb_discard;
    vmk_uint32 brb_packet;
    vmk_uint32 brb_truncate;
    vmk_uint32 flow_ctrl_discard;
    vmk_uint32 flow_ctrl_octets;
    vmk_uint32 flow_ctrl_packet;
    vmk_uint32 mng_discard;
    vmk_uint32 mng_octet_inp;
    vmk_uint32 mng_octet_out;
    vmk_uint32 mng_packet_inp;
    vmk_uint32 mng_packet_out;
    vmk_uint32 pbf_octets;
    vmk_uint32 pbf_packet;
    vmk_uint32 safc_inp;
    vmk_uint32 egress_mac_pkt0_lo;
    vmk_uint32 egress_mac_pkt0_hi;
    vmk_uint32 egress_mac_pkt1_lo;
    vmk_uint32 egress_mac_pkt1_hi;
};


enum qfle3_stats_event {
    STATS_EVENT_PMF = 0,
    STATS_EVENT_LINK_UP,
    STATS_EVENT_UPDATE,
    STATS_EVENT_STOP,
    STATS_EVENT_MAX
};

enum qfle3_stats_state {
    STATS_STATE_DISABLED = 0,
    STATS_STATE_ENABLED,
    STATS_STATE_MAX
};

struct qfle3_eth_stats {
    vmk_uint32 total_bytes_received_hi;
    vmk_uint32 total_bytes_received_lo;
    vmk_uint32 total_bytes_transmitted_hi;
    vmk_uint32 total_bytes_transmitted_lo;
    vmk_uint32 total_unicast_packets_received_hi;
    vmk_uint32 total_unicast_packets_received_lo;
    vmk_uint32 total_multicast_packets_received_hi;
    vmk_uint32 total_multicast_packets_received_lo;
    vmk_uint32 total_broadcast_packets_received_hi;
    vmk_uint32 total_broadcast_packets_received_lo;
    vmk_uint32 total_unicast_packets_transmitted_hi;
    vmk_uint32 total_unicast_packets_transmitted_lo;
    vmk_uint32 total_multicast_packets_transmitted_hi;
    vmk_uint32 total_multicast_packets_transmitted_lo;
    vmk_uint32 total_broadcast_packets_transmitted_hi;
    vmk_uint32 total_broadcast_packets_transmitted_lo;
    vmk_uint32 valid_bytes_received_hi;
    vmk_uint32 valid_bytes_received_lo;

    vmk_uint32 error_bytes_received_hi;
    vmk_uint32 error_bytes_received_lo;
    vmk_uint32 etherstatsoverrsizepkts_hi;
    vmk_uint32 etherstatsoverrsizepkts_lo;
    vmk_uint32 no_buff_discard_hi;
    vmk_uint32 no_buff_discard_lo;

    vmk_uint32 rx_stat_ifhcinbadoctets_hi;
    vmk_uint32 rx_stat_ifhcinbadoctets_lo;
    vmk_uint32 tx_stat_ifhcoutbadoctets_hi;
    vmk_uint32 tx_stat_ifhcoutbadoctets_lo;
    vmk_uint32 rx_stat_dot3statsfcserrors_hi;
    vmk_uint32 rx_stat_dot3statsfcserrors_lo;
    vmk_uint32 rx_stat_dot3statsalignmenterrors_hi;
    vmk_uint32 rx_stat_dot3statsalignmenterrors_lo;
    vmk_uint32 rx_stat_dot3statscarriersenseerrors_hi;
    vmk_uint32 rx_stat_dot3statscarriersenseerrors_lo;
    vmk_uint32 rx_stat_falsecarriererrors_hi;
    vmk_uint32 rx_stat_falsecarriererrors_lo;
    vmk_uint32 rx_stat_etherstatsundersizepkts_hi;
    vmk_uint32 rx_stat_etherstatsundersizepkts_lo;
    vmk_uint32 rx_stat_dot3statsframestoolong_hi;
    vmk_uint32 rx_stat_dot3statsframestoolong_lo;
    vmk_uint32 rx_stat_etherstatsfragments_hi;
    vmk_uint32 rx_stat_etherstatsfragments_lo;
    vmk_uint32 rx_stat_etherstatsjabbers_hi;
    vmk_uint32 rx_stat_etherstatsjabbers_lo;
    vmk_uint32 rx_stat_maccontrolframesreceived_hi;
    vmk_uint32 rx_stat_maccontrolframesreceived_lo;
    vmk_uint32 rx_stat_bmac_xpf_hi;
    vmk_uint32 rx_stat_bmac_xpf_lo;
    vmk_uint32 rx_stat_bmac_xcf_hi;
    vmk_uint32 rx_stat_bmac_xcf_lo;
    vmk_uint32 rx_stat_xoffstateentered_hi;
    vmk_uint32 rx_stat_xoffstateentered_lo;
    vmk_uint32 rx_stat_xonpauseframesreceived_hi;
    vmk_uint32 rx_stat_xonpauseframesreceived_lo;
    vmk_uint32 rx_stat_xoffpauseframesreceived_hi;
    vmk_uint32 rx_stat_xoffpauseframesreceived_lo;
    vmk_uint32 tx_stat_outxonsent_hi;
    vmk_uint32 tx_stat_outxonsent_lo;
    vmk_uint32 tx_stat_outxoffsent_hi;
    vmk_uint32 tx_stat_outxoffsent_lo;
    vmk_uint32 tx_stat_flowcontroldone_hi;
    vmk_uint32 tx_stat_flowcontroldone_lo;
    vmk_uint32 tx_stat_etherstatscollisions_hi;
    vmk_uint32 tx_stat_etherstatscollisions_lo;
    vmk_uint32 tx_stat_dot3statssinglecollisionframes_hi;
    vmk_uint32 tx_stat_dot3statssinglecollisionframes_lo;
    vmk_uint32 tx_stat_dot3statsmultiplecollisionframes_hi;
    vmk_uint32 tx_stat_dot3statsmultiplecollisionframes_lo;
    vmk_uint32 tx_stat_dot3statsdeferredtransmissions_hi;
    vmk_uint32 tx_stat_dot3statsdeferredtransmissions_lo;
    vmk_uint32 tx_stat_dot3statsexcessivecollisions_hi;
    vmk_uint32 tx_stat_dot3statsexcessivecollisions_lo;
    vmk_uint32 tx_stat_dot3statslatecollisions_hi;
    vmk_uint32 tx_stat_dot3statslatecollisions_lo;
    vmk_uint32 tx_stat_etherstatspkts64octets_hi;
    vmk_uint32 tx_stat_etherstatspkts64octets_lo;
    vmk_uint32 tx_stat_etherstatspkts65octetsto127octets_hi;
    vmk_uint32 tx_stat_etherstatspkts65octetsto127octets_lo;
    vmk_uint32 tx_stat_etherstatspkts128octetsto255octets_hi;
    vmk_uint32 tx_stat_etherstatspkts128octetsto255octets_lo;
    vmk_uint32 tx_stat_etherstatspkts256octetsto511octets_hi;
    vmk_uint32 tx_stat_etherstatspkts256octetsto511octets_lo;
    vmk_uint32 tx_stat_etherstatspkts512octetsto1023octets_hi;
    vmk_uint32 tx_stat_etherstatspkts512octetsto1023octets_lo;
    vmk_uint32 tx_stat_etherstatspkts1024octetsto1522octets_hi;
    vmk_uint32 tx_stat_etherstatspkts1024octetsto1522octets_lo;
    vmk_uint32 tx_stat_etherstatspktsover1522octets_hi;
    vmk_uint32 tx_stat_etherstatspktsover1522octets_lo;
    vmk_uint32 tx_stat_bmac_2047_hi;
    vmk_uint32 tx_stat_bmac_2047_lo;
    vmk_uint32 tx_stat_bmac_4095_hi;
    vmk_uint32 tx_stat_bmac_4095_lo;
    vmk_uint32 tx_stat_bmac_9216_hi;
    vmk_uint32 tx_stat_bmac_9216_lo;
    vmk_uint32 tx_stat_bmac_16383_hi;
    vmk_uint32 tx_stat_bmac_16383_lo;
    vmk_uint32 tx_stat_dot3statsinternalmactransmiterrors_hi;
    vmk_uint32 tx_stat_dot3statsinternalmactransmiterrors_lo;
    vmk_uint32 tx_stat_bmac_ufl_hi;
    vmk_uint32 tx_stat_bmac_ufl_lo;

    vmk_uint32 pause_frames_received_hi;
    vmk_uint32 pause_frames_received_lo;
    vmk_uint32 pause_frames_sent_hi;
    vmk_uint32 pause_frames_sent_lo;

    vmk_uint32 etherstatspkts1024octetsto1522octets_hi;
    vmk_uint32 etherstatspkts1024octetsto1522octets_lo;
    vmk_uint32 etherstatspktsover1522octets_hi;
    vmk_uint32 etherstatspktsover1522octets_lo;

    vmk_uint32 brb_drop_hi;
    vmk_uint32 brb_drop_lo;
    vmk_uint32 brb_truncate_hi;
    vmk_uint32 brb_truncate_lo;

    vmk_uint32 mac_filter_discard;
    vmk_uint32 mf_tag_discard;
    vmk_uint32 brb_truncate_discard;
    vmk_uint32 mac_discard;

    vmk_uint32 nig_timer_max;

    vmk_uint32 total_tpa_aggregations_hi;
    vmk_uint32 total_tpa_aggregations_lo;
    vmk_uint32 total_tpa_aggregated_frames_hi;
    vmk_uint32 total_tpa_aggregated_frames_lo;
    vmk_uint32 total_tpa_bytes_hi;
    vmk_uint32 total_tpa_bytes_lo;

    /* PFC */
    vmk_uint32 pfc_frames_received_hi;
    vmk_uint32 pfc_frames_received_lo;
    vmk_uint32 pfc_frames_sent_hi;
    vmk_uint32 pfc_frames_sent_lo;

    /* Recovery */
    vmk_uint32 recoverable_error;
    vmk_uint32 unrecoverable_error;

    /* src: Clear-on-Read register; Will not survive PMF Migration */
    vmk_uint32 eee_tx_lpi;

    /* receive path driver statistics */
    vmk_uint32 rx_calls;
    vmk_uint32 rx_pkts;
    vmk_uint32 rx_tpa_pkts;
    vmk_uint32 rx_soft_errors;
    vmk_uint32 rx_hw_csum_errors;
    vmk_uint32 rx_ofld_frames_csum_ip;
    vmk_uint32 rx_ofld_frames_csum_tcp_udp;
    vmk_uint32 rx_budget_reached;

    /* tx path driver statistics */
    vmk_uint32 tx_pkts;
    vmk_uint32 tx_soft_errors;
    vmk_uint32 tx_ofld_frames_csum_ip;
    vmk_uint32 tx_ofld_frames_csum_tcp;
    vmk_uint32 tx_ofld_frames_csum_udp;
    vmk_uint32 tx_ofld_frames_lso;
    vmk_uint32 tx_ofld_frames_lso_hdr_splits;
    vmk_uint32 tx_encap_failures;
    vmk_uint32 tx_hw_queue_full;
    vmk_uint32 tx_hw_max_queue_depth;
    vmk_uint32 tx_dma_mapping_failure;
    vmk_uint32 tx_max_drbr_queue_depth;
    vmk_uint32 tx_window_violation_std;
    vmk_uint32 tx_window_violation_tso;
    //vmk_uint32 tx_unsupported_tso_request_ipv6;
    //vmk_uint32 tx_unsupported_tso_request_not_tcp;
    vmk_uint32 tx_chain_lost_mbuf;
    vmk_uint32 tx_frames_deferred;
    vmk_uint32 tx_queue_xoff;

    /* mbuf driver statistics */
    vmk_uint32 mbuf_defrag_attempts;
    vmk_uint32 mbuf_defrag_failures;
    vmk_uint32 mbuf_rx_bd_alloc_failed;
    vmk_uint32 mbuf_rx_bd_mapping_failed;
    vmk_uint32 mbuf_rx_tpa_alloc_failed;
    vmk_uint32 mbuf_rx_tpa_mapping_failed;
    vmk_uint32 mbuf_rx_sge_alloc_failed;
    vmk_uint32 mbuf_rx_sge_mapping_failed;

    /* track the number of allocated mbufs */
    vmk_uint32 mbuf_alloc_tx;
    vmk_uint32 mbuf_alloc_rx;
    vmk_uint32 mbuf_alloc_sge;
    vmk_uint32 mbuf_alloc_tpa;
};


struct qfle3_eth_q_stats {
    vmk_uint32 total_unicast_bytes_received_hi;
    vmk_uint32 total_unicast_bytes_received_lo;
    vmk_uint32 total_broadcast_bytes_received_hi;
    vmk_uint32 total_broadcast_bytes_received_lo;
    vmk_uint32 total_multicast_bytes_received_hi;
    vmk_uint32 total_multicast_bytes_received_lo;
    vmk_uint32 total_bytes_received_hi;
    vmk_uint32 total_bytes_received_lo;
    vmk_uint32 total_unicast_bytes_transmitted_hi;
    vmk_uint32 total_unicast_bytes_transmitted_lo;
    vmk_uint32 total_broadcast_bytes_transmitted_hi;
    vmk_uint32 total_broadcast_bytes_transmitted_lo;
    vmk_uint32 total_multicast_bytes_transmitted_hi;
    vmk_uint32 total_multicast_bytes_transmitted_lo;
    vmk_uint32 total_bytes_transmitted_hi;
    vmk_uint32 total_bytes_transmitted_lo;
    vmk_uint32 total_unicast_packets_received_hi;
    vmk_uint32 total_unicast_packets_received_lo;
    vmk_uint32 total_multicast_packets_received_hi;
    vmk_uint32 total_multicast_packets_received_lo;
    vmk_uint32 total_broadcast_packets_received_hi;
    vmk_uint32 total_broadcast_packets_received_lo;
    vmk_uint32 total_unicast_packets_transmitted_hi;
    vmk_uint32 total_unicast_packets_transmitted_lo;
    vmk_uint32 total_multicast_packets_transmitted_hi;
    vmk_uint32 total_multicast_packets_transmitted_lo;
    vmk_uint32 total_broadcast_packets_transmitted_hi;
    vmk_uint32 total_broadcast_packets_transmitted_lo;
    vmk_uint32 valid_bytes_received_hi;
    vmk_uint32 valid_bytes_received_lo;

    vmk_uint32 etherstatsoverrsizepkts_hi;
    vmk_uint32 etherstatsoverrsizepkts_lo;
    vmk_uint32 no_buff_discard_hi;
    vmk_uint32 no_buff_discard_lo;

    vmk_uint32 total_packets_received_checksum_discarded_hi;
    vmk_uint32 total_packets_received_checksum_discarded_lo;
    vmk_uint32 total_packets_received_ttl0_discarded_hi;
    vmk_uint32 total_packets_received_ttl0_discarded_lo;
    vmk_uint32 total_transmitted_dropped_packets_error_hi;
    vmk_uint32 total_transmitted_dropped_packets_error_lo;

    vmk_uint32 total_tpa_aggregations_hi;
    vmk_uint32 total_tpa_aggregations_lo;
    vmk_uint32 total_tpa_aggregated_frames_hi;
    vmk_uint32 total_tpa_aggregated_frames_lo;
    vmk_uint32 total_tpa_bytes_hi;
    vmk_uint32 total_tpa_bytes_lo;

    /* receive path driver statistics */
    vmk_uint32 rx_calls;
    vmk_uint32 rx_pkts;
    vmk_uint32 rx_tpa_pkts;
    vmk_uint32 rx_soft_errors;
    vmk_uint32 rx_hw_csum_errors;
    vmk_uint32 rx_ofld_frames_csum_ip;
    vmk_uint32 rx_ofld_frames_csum_tcp_udp;
    vmk_uint32 rx_budget_reached;

    /* tx path driver statistics */
    vmk_uint32 tx_pkts;
    vmk_uint32 tx_soft_errors;
    vmk_uint32 tx_ofld_frames_csum_ip;
    vmk_uint32 tx_ofld_frames_csum_tcp;
    vmk_uint32 tx_ofld_frames_csum_udp;
    vmk_uint32 tx_ofld_frames_lso;
    vmk_uint32 tx_ofld_frames_lso_hdr_splits;
    vmk_uint32 tx_encap_failures;
    vmk_uint32 tx_hw_queue_full;
    vmk_uint32 tx_hw_max_queue_depth;
    vmk_uint32 tx_dma_mapping_failure;
    vmk_uint32 tx_max_drbr_queue_depth;
    vmk_uint32 tx_window_violation_std;
    vmk_uint32 tx_window_violation_tso;
    //vmk_uint32 tx_unsupported_tso_request_ipv6;
    //vmk_uint32 tx_unsupported_tso_request_not_tcp;
    vmk_uint32 tx_chain_lost_mbuf;
    vmk_uint32 tx_frames_deferred;
    vmk_uint32 tx_queue_xoff;

    /* mbuf driver statistics */
    vmk_uint32 mbuf_defrag_attempts;
    vmk_uint32 mbuf_defrag_failures;
    vmk_uint32 mbuf_rx_bd_alloc_failed;
    vmk_uint32 mbuf_rx_bd_mapping_failed;
    vmk_uint32 mbuf_rx_tpa_alloc_failed;
    vmk_uint32 mbuf_rx_tpa_mapping_failed;
    vmk_uint32 mbuf_rx_sge_alloc_failed;
    vmk_uint32 mbuf_rx_sge_mapping_failed;

    /* track the number of allocated mbufs */
    vmk_uint32 mbuf_alloc_tx;
    vmk_uint32 mbuf_alloc_rx;
    vmk_uint32 mbuf_alloc_sge;
    vmk_uint32 mbuf_alloc_tpa;
};

struct qfle3_eth_stats_old {
    vmk_uint32 rx_stat_dot3statsframestoolong_hi;
    vmk_uint32 rx_stat_dot3statsframestoolong_lo;
};

struct qfle3_eth_q_stats_old {
    /* Fields to perserve over fw reset*/
    vmk_uint32 total_unicast_bytes_received_hi;
    vmk_uint32 total_unicast_bytes_received_lo;
    vmk_uint32 total_broadcast_bytes_received_hi;
    vmk_uint32 total_broadcast_bytes_received_lo;
    vmk_uint32 total_multicast_bytes_received_hi;
    vmk_uint32 total_multicast_bytes_received_lo;
    vmk_uint32 total_unicast_bytes_transmitted_hi;
    vmk_uint32 total_unicast_bytes_transmitted_lo;
    vmk_uint32 total_broadcast_bytes_transmitted_hi;
    vmk_uint32 total_broadcast_bytes_transmitted_lo;
    vmk_uint32 total_multicast_bytes_transmitted_hi;
    vmk_uint32 total_multicast_bytes_transmitted_lo;
    vmk_uint32 total_tpa_bytes_hi;
    vmk_uint32 total_tpa_bytes_lo;

    /* Fields to perserve last of */
    vmk_uint32 total_bytes_received_hi;
    vmk_uint32 total_bytes_received_lo;
    vmk_uint32 total_bytes_transmitted_hi;
    vmk_uint32 total_bytes_transmitted_lo;
    vmk_uint32 total_unicast_packets_received_hi;
    vmk_uint32 total_unicast_packets_received_lo;
    vmk_uint32 total_multicast_packets_received_hi;
    vmk_uint32 total_multicast_packets_received_lo;
    vmk_uint32 total_broadcast_packets_received_hi;
    vmk_uint32 total_broadcast_packets_received_lo;
    vmk_uint32 total_unicast_packets_transmitted_hi;
    vmk_uint32 total_unicast_packets_transmitted_lo;
    vmk_uint32 total_multicast_packets_transmitted_hi;
    vmk_uint32 total_multicast_packets_transmitted_lo;
    vmk_uint32 total_broadcast_packets_transmitted_hi;
    vmk_uint32 total_broadcast_packets_transmitted_lo;
    vmk_uint32 valid_bytes_received_hi;
    vmk_uint32 valid_bytes_received_lo;

    vmk_uint32 total_tpa_bytes_hi_old;
    vmk_uint32 total_tpa_bytes_lo_old;

    /* receive path driver statistics */
    vmk_uint32 rx_calls_old;
    vmk_uint32 rx_pkts_old;
    vmk_uint32 rx_tpa_pkts_old;
    vmk_uint32 rx_soft_errors_old;
    vmk_uint32 rx_hw_csum_errors_old;
    vmk_uint32 rx_ofld_frames_csum_ip_old;
    vmk_uint32 rx_ofld_frames_csum_tcp_udp_old;
    vmk_uint32 rx_budget_reached_old;

    /* tx path driver statistics */
    vmk_uint32 tx_pkts_old;
    vmk_uint32 tx_soft_errors_old;
    vmk_uint32 tx_ofld_frames_csum_ip_old;
    vmk_uint32 tx_ofld_frames_csum_tcp_old;
    vmk_uint32 tx_ofld_frames_csum_udp_old;
    vmk_uint32 tx_ofld_frames_lso_old;
    vmk_uint32 tx_ofld_frames_lso_hdr_splits_old;
    vmk_uint32 tx_encap_failures_old;
    vmk_uint32 tx_hw_queue_full_old;
    vmk_uint32 tx_hw_max_queue_depth_old;
    vmk_uint32 tx_dma_mapping_failure_old;
    vmk_uint32 tx_max_drbr_queue_depth_old;
    vmk_uint32 tx_window_violation_std_old;
    vmk_uint32 tx_window_violation_tso_old;
    //vmk_uint32 tx_unsupported_tso_request_ipv6_old;
    //vmk_uint32 tx_unsupported_tso_request_not_tcp_old;
    vmk_uint32 tx_chain_lost_mbuf_old;
    vmk_uint32 tx_frames_deferred_old;
    vmk_uint32 tx_queue_xoff_old;

    /* mbuf driver statistics */
    vmk_uint32 mbuf_defrag_attempts_old;
    vmk_uint32 mbuf_defrag_failures_old;
    vmk_uint32 mbuf_rx_bd_alloc_failed_old;
    vmk_uint32 mbuf_rx_bd_mapping_failed_old;
    vmk_uint32 mbuf_rx_tpa_alloc_failed_old;
    vmk_uint32 mbuf_rx_tpa_mapping_failed_old;
    vmk_uint32 mbuf_rx_sge_alloc_failed_old;
    vmk_uint32 mbuf_rx_sge_mapping_failed_old;

    /* track the number of allocated mbufs */
    int mbuf_alloc_tx_old;
    int mbuf_alloc_rx_old;
    int mbuf_alloc_sge_old;
    int mbuf_alloc_tpa_old;
};

struct qfle3_net_stats_old {
    vmk_uint32 rx_dropped;
};

struct qfle3_fw_port_stats_old {
    vmk_uint32 pfc_frames_tx_hi;
    vmk_uint32 pfc_frames_tx_lo;
    vmk_uint32 pfc_frames_rx_hi;
    vmk_uint32 pfc_frames_rx_lo;

    vmk_uint32 mac_filter_discard;
    vmk_uint32 mf_tag_discard;
    vmk_uint32 brb_truncate_discard;
    vmk_uint32 mac_discard;
};

/* sum[hi:lo] += add[hi:lo] */
#define ADD_64(s_hi, a_hi, s_lo, a_lo)          \
    do {                                        \
        s_lo += a_lo;                           \
        s_hi += a_hi + ((s_lo < a_lo) ? 1 : 0); \
    } while (0)

#define LE32_0 ((vmk_uint32) 0)
#define LE16_0 ((vmk_uint16) 0)

/* The _force is for cases where high value is 0 */
#define ADD_64_LE(s_hi, a_hi_le, s_lo, a_lo_le) \
        ADD_64(s_hi, le32toh(a_hi_le),          \
               s_lo, le32toh(a_lo_le))

#define ADD_64_LE16(s_hi, a_hi_le, s_lo, a_lo_le) \
        ADD_64(s_hi, le16toh(a_hi_le),            \
               s_lo, le16toh(a_lo_le))

/* difference = minuend - subtrahend */
#define DIFF_64(d_hi, m_hi, s_hi, d_lo, m_lo, s_lo)  \
    do {                                             \
        if (m_lo < s_lo) {                           \
            /* underflow */                          \
            d_hi = m_hi - s_hi;                      \
            if (d_hi > 0) {                          \
                /* we can 'loan' 1 */                \
                d_hi--;                              \
                d_lo = m_lo + (VMK_UINT32_MAX - s_lo) + 1; \
            } else {                                 \
                /* m_hi <= s_hi */                   \
                d_hi = 0;                            \
                d_lo = 0;                            \
            }                                        \
        } else {                                     \
            /* m_lo >= s_lo */                       \
            if (m_hi < s_hi) {                       \
                d_hi = 0;                            \
                d_lo = 0;                            \
            } else {                                 \
                /* m_hi >= s_hi */                   \
                d_hi = m_hi - s_hi;                  \
                d_lo = m_lo - s_lo;                  \
            }                                        \
        }                                            \
    } while (0)

#define UPDATE_STAT64(s, t)                                      \
    do {                                                         \
        DIFF_64(diff.hi, new->s##_hi, pstats->mac_stx[0].t##_hi, \
            diff.lo, new->s##_lo, pstats->mac_stx[0].t##_lo);    \
        pstats->mac_stx[0].t##_hi = new->s##_hi;                 \
        pstats->mac_stx[0].t##_lo = new->s##_lo;                 \
        ADD_64(pstats->mac_stx[1].t##_hi, diff.hi,               \
               pstats->mac_stx[1].t##_lo, diff.lo);              \
    } while (0)

#define UPDATE_STAT64_NIG(s, t)                    \
    do {                                           \
        DIFF_64(diff.hi, new->s##_hi, old->s##_hi, \
            diff.lo, new->s##_lo, old->s##_lo);    \
        ADD_64(estats->t##_hi, diff.hi,            \
               estats->t##_lo, diff.lo);           \
    } while (0)

/* sum[hi:lo] += add */
#define ADD_EXTEND_64(s_hi, s_lo, a) \
    do {                             \
        s_lo += a;                   \
        s_hi += (s_lo < a) ? 1 : 0;  \
    } while (0)

#define ADD_STAT64(diff, t)                                \
    do {                                                   \
        ADD_64(pstats->mac_stx[1].t##_hi, new->diff##_hi,  \
               pstats->mac_stx[1].t##_lo, new->diff##_lo); \
    } while (0)

#define UPDATE_EXTEND_STAT(s)                    \
    do {                                         \
        ADD_EXTEND_64(pstats->mac_stx[1].s##_hi, \
                  pstats->mac_stx[1].s##_lo,     \
                  new->s);                       \
    } while (0)

#define UPDATE_EXTEND_TSTAT_X(s, t, size)                    \
    do {                                                     \
        diff = le##size##toh(tclient->s) -                   \
               le##size##toh(old_tclient->s);                \
        old_tclient->s = tclient->s;                         \
        ADD_EXTEND_64(qstats->t##_hi, qstats->t##_lo, diff); \
    } while (0)

#define UPDATE_EXTEND_TSTAT(s, t) UPDATE_EXTEND_TSTAT_X(s, t, 32)

#define UPDATE_EXTEND_E_TSTAT(s, t, size)                    \
    do {                                                     \
        UPDATE_EXTEND_TSTAT_X(s, t, size);                   \
        ADD_EXTEND_64(estats->t##_hi, estats->t##_lo, diff); \
    } while (0)

#define UPDATE_EXTEND_USTAT(s, t)                             \
    do {                                                      \
        diff = le32toh(uclient->s) - le32toh(old_uclient->s); \
        old_uclient->s = uclient->s;                          \
        ADD_EXTEND_64(qstats->t##_hi, qstats->t##_lo, diff);  \
    } while (0)

#define UPDATE_EXTEND_E_USTAT(s, t)                          \
    do {                                                     \
        UPDATE_EXTEND_USTAT(s, t);                           \
        ADD_EXTEND_64(estats->t##_hi, estats->t##_lo, diff); \
    } while (0)

#define UPDATE_EXTEND_XSTAT(s, t)                             \
    do {                                                      \
        diff = le32toh(xclient->s) - le32toh(old_xclient->s); \
        old_xclient->s = xclient->s;                          \
        ADD_EXTEND_64(qstats->t##_hi, qstats->t##_lo, diff);  \
    } while (0)

#define UPDATE_QSTAT(s, t)                                   \
    do {                                                     \
        qstats->t##_hi = qstats_old->t##_hi + le32toh(s.hi); \
        qstats->t##_lo = qstats_old->t##_lo + le32toh(s.lo); \
    } while (0)

#define UPDATE_QSTAT_OLD(f)        \
    do {                           \
        qstats_old->f = qstats->f; \
    } while (0)

#define UPDATE_ESTAT_QSTAT_64(s)                        \
    do {                                                \
        ADD_64(estats->s##_hi, qstats->s##_hi,          \
               estats->s##_lo, qstats->s##_lo);         \
        SUB_64(estats->s##_hi, qstats_old->s##_hi_old,  \
               estats->s##_lo, qstats_old->s##_lo_old); \
        qstats_old->s##_hi_old = qstats->s##_hi;        \
        qstats_old->s##_lo_old = qstats->s##_lo;        \
    } while (0)

#define UPDATE_ESTAT_QSTAT(s)             \
    do {                                  \
        estats->s += qstats->s;           \
        estats->s -= qstats_old->s##_old; \
        qstats_old->s##_old = qstats->s;  \
    } while (0)

#define UPDATE_FSTAT_QSTAT(s)                       \
    do {                                            \
        ADD_64(fstats->s##_hi, qstats->s##_hi,      \
               fstats->s##_lo, qstats->s##_lo);     \
        SUB_64(fstats->s##_hi, qstats_old->s##_hi,  \
               fstats->s##_lo, qstats_old->s##_lo); \
        estats->s##_hi = fstats->s##_hi;            \
        estats->s##_lo = fstats->s##_lo;            \
        qstats_old->s##_hi = qstats->s##_hi;        \
        qstats_old->s##_lo = qstats->s##_lo;        \
    } while (0)

#define UPDATE_FW_STAT(s)                           \
    do {                                            \
        estats->s = le32toh(tport->s) + fwstats->s; \
    } while (0)

#define UPDATE_FW_STAT_OLD(f)   \
    do {                        \
        fwstats->f = estats->f; \
    } while (0)

#define UPDATE_ESTAT(s, t)                          \
    do {                                            \
        SUB_64(estats->s##_hi, estats_old->t##_hi,  \
               estats->s##_lo, estats_old->t##_lo); \
        ADD_64(estats->s##_hi, estats->t##_hi,      \
               estats->s##_lo, estats->t##_lo);     \
        estats_old->t##_hi = estats->t##_hi;        \
        estats_old->t##_lo = estats->t##_lo;        \
    } while (0)

/* minuend -= subtrahend */
#define SUB_64(m_hi, s_hi, m_lo, s_lo)               \
    do {                                             \
        DIFF_64(m_hi, m_hi, s_hi, m_lo, m_lo, s_lo); \
    } while (0)

/* minuend[hi:lo] -= subtrahend */
#define SUB_EXTEND_64(m_hi, m_lo, s) \
    do {                             \
        SUB_64(m_hi, 0, m_lo, s);    \
    } while (0)

#define SUB_EXTEND_USTAT(s, t)                                \
    do {                                                      \
        diff = le32toh(uclient->s) - le32toh(old_uclient->s); \
        SUB_EXTEND_64(qstats->t##_hi, qstats->t##_lo, diff);  \
    } while (0)

struct qfle3_adapter;
void qfle3_stats_init(struct qfle3_adapter *adapter);
void qfle3_stats_handle(struct qfle3_adapter *adapter, enum qfle3_stats_event event);
#ifdef QFLE3_SRIOV
int qfle3_stats_safe_exec(struct qfle3_adapter *adapter, void (func_to_exec)(void *cookie), void *cookie);
#endif //QFLE3_SRIOV
void qfle3_save_statistics(struct qfle3_adapter *adapter);
/* void qfle3_afex_collect_stats(qfle3_adapter *adapter, void *void_afex_stats, vmk_uint32 stats_type); */
//vmk_uint64 qfle3_get_counter(if_t, ift_counter);

#endif /* QFLE3_STATS_H */

