/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.parse;

import java.util.ArrayList;
import java.util.HashMap;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.util.parse.VarContext;
import org.basex.query.value.item.QNm;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class LocalVars {
    private final ArrayList<VarContext> vars = new ArrayList();
    private final QueryParser parser;

    public LocalVars(QueryParser parser) {
        this.parser = parser;
    }

    public Var add(Var var) {
        if (var != null) {
            this.vars.get(this.vars.size() - 1).add(var);
        }
        return var;
    }

    public void add(Var ... vrs) {
        for (Var var : vrs) {
            this.add(var);
        }
    }

    public VarRef resolveLocal(QNm name, InputInfo info) {
        int l = this.vars.size();
        Var var = null;
        while (--l >= 0 && (var = this.vars.get((int)l).stack.get(name)) == null) {
        }
        if (var == null) {
            return null;
        }
        int ls = this.vars.size();
        while (++l < ls) {
            VarContext vctx = this.vars.get(l);
            Var local = new Var(var.name, var.seqType(), this.parser.qc, info);
            vctx.add(local);
            vctx.bindings.put(local, new VarRef(info, var));
            var = local;
        }
        return new VarRef(info, var);
    }

    public ParseExpr resolve(QNm name, InputInfo info) throws QueryException {
        VarRef ref = this.resolveLocal(name, info);
        if (ref != null) {
            return ref;
        }
        byte[] uri = name.uri();
        QNm module = this.parser.sc.module;
        boolean hasImport = this.parser.moduleURIs.contains(uri);
        if (module == null || Token.eq(module.uri(), uri) || hasImport) {
            return this.parser.qc.vars.newRef(name, info, hasImport);
        }
        throw this.parser.error(QueryError.VARUNDEF_X, info, "$" + Token.string(name.string()));
    }

    public HashMap<Var, Expr> pushContext(boolean global) {
        HashMap<Var, Expr> map = global ? new HashMap<Var, Expr>() : null;
        this.vars.add(new VarContext(map));
        return map;
    }

    public VarScope popContext() {
        return this.vars.remove((int)(this.vars.size() - 1)).vs;
    }

    public int openScope() {
        return this.vars.get((int)(this.vars.size() - 1)).stack.size();
    }

    public void closeScope(int marker) {
        this.vars.get((int)(this.vars.size() - 1)).stack.size(marker);
    }
}

