/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.util.HashMap;
import org.basex.core.jobs.JobOptions;
import org.basex.io.IOContent;
import org.basex.query.value.Value;
import org.basex.util.Util;

public final class QueryJobSpec {
    final HashMap<String, Value> bindings;
    final JobOptions options;
    final String query;
    final boolean simple;

    public QueryJobSpec(JobOptions options, HashMap<String, Value> bindings, IOContent content) {
        this.options = options;
        this.bindings = bindings;
        this.query = content.toString();
        this.simple = content.url().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof QueryJobSpec)) return false;
        QueryJobSpec spec = (QueryJobSpec)obj;
        if (!this.query.equals(spec.query)) return false;
        if (!this.bindings.equals(spec.bindings)) return false;
        if (!this.options.toString().equals(spec.options.toString())) return false;
        return true;
    }

    public String toString() {
        return Util.className(this) + "[" + String.valueOf(this.options) + "," + this.query + "]";
    }
}

