/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;

@BugPattern(name="RedundantCondition", summary="Redundant usage of a boolean variable with known value", severity=BugPattern.SeverityLevel.WARNING)
public class RedundantCondition
extends BugChecker
implements BugChecker.IfTreeMatcher,
BugChecker.AssignmentTreeMatcher,
BugChecker.ConditionalExpressionTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableList<RedundantExpressionMatcher> REDUNDANT_EXPRESSION_MATCHERS = ImmutableList.of((Object)new RedundantVariableMatcher());

    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (tree.getExpression() instanceof BinaryTree) {
            return this.matchExpression(tree.getExpression(), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (tree.getInitializer() instanceof BinaryTree) {
            return this.matchExpression(tree.getInitializer(), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchConditionalExpression(ConditionalExpressionTree tree, VisitorState state) {
        return this.matchExpression(tree.getCondition(), state);
    }

    public Description matchIf(IfTree ifTree, VisitorState state) {
        return this.matchExpression(ifTree.getCondition(), state);
    }

    private Description matchExpression(ExpressionTree expressionTree, VisitorState state) {
        TreePath childPath = state.getPath();
        IfTree ifTree = null;
        for (TreePath parentPath = childPath.getParentPath(); parentPath != null; parentPath = parentPath.getParentPath()) {
            IfTree enclosingIfTree;
            if (parentPath.getLeaf() instanceof IfTree && (enclosingIfTree = (IfTree)parentPath.getLeaf()).getThenStatement().equals(childPath.getLeaf())) {
                ifTree = enclosingIfTree;
            }
            childPath = parentPath;
        }
        if (ifTree == null) {
            return Description.NO_MATCH;
        }
        ArrayList<String> matchedExpressions = new ArrayList<String>();
        for (RedundantExpressionMatcher matcher : REDUNDANT_EXPRESSION_MATCHERS) {
            List<ExpressionTree> expressionToCheck = matcher.extractExpressionsToCheck(expressionTree);
            List<ExpressionTree> expressionToCheckAgainst = matcher.extractExpressionsToCheckAgainst(ifTree.getCondition(), ifTree.getThenStatement());
            for (ExpressionTree lhs : expressionToCheck) {
                for (ExpressionTree rhs : expressionToCheckAgainst) {
                    if (!matcher.isSame(lhs, rhs)) continue;
                    matchedExpressions.add(lhs.toString());
                }
            }
        }
        if (!matchedExpressions.isEmpty()) {
            return this.buildDescription(expressionTree).setMessage("Redundant usage of a boolean expression " + matchedExpressions + " that is known to be `true`").build();
        }
        return Description.NO_MATCH;
    }

    private static class AssignedSymbolsScanner
    extends TreeScanner<Void, Boolean> {
        final Set<Symbol> assignedSymbols = new HashSet<Symbol>();

        AssignedSymbolsScanner() {
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, Boolean unused) {
            ExpressionTree variable = assignmentTree.getVariable();
            if (variable instanceof JCTree.JCIdent) {
                JCTree.JCIdent identifierTree = (JCTree.JCIdent)variable;
                this.assignedSymbols.add(identifierTree.sym);
            }
            return (Void)super.visitAssignment(assignmentTree, unused);
        }

        Set<Symbol> getAssignedSymbols() {
            return ImmutableSet.copyOf(this.assignedSymbols);
        }
    }

    private static class RedundantVariableMatcher
    implements RedundantExpressionMatcher {
        private RedundantVariableMatcher() {
        }

        @Override
        public List<ExpressionTree> extractExpressionsToCheck(ExpressionTree expressionTree) {
            ExpressionTree strippedParentheses = ASTHelpers.stripParentheses((ExpressionTree)expressionTree);
            ArrayList<ExpressionTree> extractedVariables = new ArrayList<ExpressionTree>();
            RedundantVariableMatcher.extractVariables(strippedParentheses, extractedVariables, false, (Set<Symbol>)ImmutableSet.of());
            return ImmutableList.copyOf(extractedVariables);
        }

        @Override
        public List<ExpressionTree> extractExpressionsToCheckAgainst(ExpressionTree ifCondition, StatementTree thenStatement) {
            ExpressionTree strippedParentheses = ASTHelpers.stripParentheses((ExpressionTree)ifCondition);
            ArrayList<ExpressionTree> extractedVariables = new ArrayList<ExpressionTree>();
            AssignedSymbolsScanner assignedSymbolsScanner = new AssignedSymbolsScanner();
            assignedSymbolsScanner.scan(thenStatement, Boolean.FALSE);
            RedundantVariableMatcher.extractVariables(strippedParentheses, extractedVariables, true, assignedSymbolsScanner.getAssignedSymbols());
            return extractedVariables;
        }

        @Override
        public boolean isSame(ExpressionTree lhs, ExpressionTree rhs) {
            if (lhs instanceof JCTree.JCIdent && rhs instanceof JCTree.JCIdent) {
                return ((JCTree.JCIdent)lhs).sym == ((JCTree.JCIdent)rhs).sym;
            }
            if (lhs instanceof JCTree.JCUnary && rhs instanceof JCTree.JCUnary) {
                JCTree.JCExpression lhsUnary = ((JCTree.JCUnary)lhs).getExpression();
                JCTree.JCExpression rhsUnary = ((JCTree.JCUnary)rhs).getExpression();
                if (lhsUnary instanceof JCTree.JCIdent && rhsUnary instanceof JCTree.JCIdent) {
                    return ((JCTree.JCIdent)lhsUnary).sym == ((JCTree.JCIdent)rhsUnary).sym;
                }
            }
            return false;
        }

        private static void extractVariables(ExpressionTree expressionTree, List<ExpressionTree> extractedVariables, boolean conditionalAndToMatch, Set<Symbol> symbolsToIgnore) {
            JCTree.JCUnary jcUnary;
            if (expressionTree instanceof BinaryTree) {
                BinaryTree binaryTree = (BinaryTree)expressionTree;
                if (conditionalAndToMatch && binaryTree.getKind() != Tree.Kind.CONDITIONAL_AND) {
                    return;
                }
                RedundantVariableMatcher.extractVariables(binaryTree.getLeftOperand(), extractedVariables, conditionalAndToMatch, symbolsToIgnore);
                RedundantVariableMatcher.extractVariables(binaryTree.getRightOperand(), extractedVariables, conditionalAndToMatch, symbolsToIgnore);
            } else if (expressionTree instanceof JCTree.JCIdent) {
                if (RedundantVariableMatcher.shouldAddSymbol((JCTree.JCIdent)expressionTree, symbolsToIgnore)) {
                    extractedVariables.add(expressionTree);
                }
            } else if (expressionTree instanceof JCTree.JCUnary && (jcUnary = (JCTree.JCUnary)expressionTree).getKind() == Tree.Kind.LOGICAL_COMPLEMENT && jcUnary.getExpression() instanceof JCTree.JCIdent && RedundantVariableMatcher.shouldAddSymbol((JCTree.JCIdent)jcUnary.getExpression(), symbolsToIgnore)) {
                extractedVariables.add(expressionTree);
            }
        }

        private static boolean shouldAddSymbol(JCTree.JCIdent jcIdent, Set<Symbol> symbolsToIgnore) {
            Symbol symbol = jcIdent.sym;
            if (symbol.getKind() != ElementKind.LOCAL_VARIABLE && symbol.getKind() != ElementKind.PARAMETER) {
                return false;
            }
            return !symbolsToIgnore.contains(symbol);
        }
    }

    private static interface RedundantExpressionMatcher {
        public List<ExpressionTree> extractExpressionsToCheck(ExpressionTree var1);

        public List<ExpressionTree> extractExpressionsToCheckAgainst(ExpressionTree var1, StatementTree var2);

        public boolean isSame(ExpressionTree var1, ExpressionTree var2);
    }
}

