/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayExternalizable;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public class CharSequenceSubSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable,
CharSequence {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;
    private transient int hash;

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start, int end) {
        if (chars == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(1);
        }
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars.charAt(index + this.myStart);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            CharSequenceSubSequence charSequenceSubSequence = this;
            if (charSequenceSubSequence == null) {
                CharSequenceSubSequence.$$$reportNull$$$0(2);
            }
            return charSequenceSubSequence;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.myChars instanceof String) {
            String string = ((String)this.myChars).substring(this.myStart, this.myEnd);
            if (string == null) {
                CharSequenceSubSequence.$$$reportNull$$$0(3);
            }
            return string;
        }
        return new String(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
    }

    @NotNull
    CharSequence getBaseSequence() {
        CharSequence charSequence = this.myChars;
        if (charSequence == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @Override
    public void getChars(int start, int end, char @NotNull [] dest, int destPos) {
        if (dest == null) {
            CharSequenceSubSequence.$$$reportNull$$$0(5);
        }
        assert (end - start <= this.myEnd - this.myStart);
        CharArrayUtil.getChars(this.myChars, dest, start + this.myStart, destPos, end - start);
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            this.hash = h2 = Strings.stringHashCode(this.myChars, this.myStart, this.myEnd);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CharSequence) {
            return StringUtilRt.equal(this, (CharSequence)obj, true);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/text/CharSequenceSubSequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/text/CharSequenceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subSequence";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

