/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.util.Optional;
import java.util.Set;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.ManifestQueryJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;
import org.kordamp.jarviz.util.StringUtils;

public class ManifestQueryCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        ManifestQueryJarProcessor processor = new ManifestQueryJarProcessor(jarFileResolver);
        processor.setAttributeName(configuration.getAttributeName());
        processor.setSectionName(configuration.getSectionName());
        Set<JarProcessor.JarFileResult<Optional<String>>> results = processor.getResult();
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<Optional<String>>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<Optional<String>> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(configuration, root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<Optional<String>> result) {
        if (result.getResult().isPresent()) {
            configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
            configuration.getOut().println(this.$$("manifest.query.attribute", configuration.getAttributeName(), result.getResult().get()));
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<Optional<String>>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<Optional<String>> result : results) {
                if (!result.getResult().isPresent()) continue;
                this.buildReport(configuration, root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Configuration configuration, Node root, JarProcessor.JarFileResult<Optional<String>> result) {
        this.appendSubject(root, result.getJarPath(), "manifest query", resultNode -> {
            if (StringUtils.isNotBlank(configuration.getSectionName())) {
                resultNode.node(RB.$("report.key.section.name", new Object[0])).value(configuration.getSectionName()).end();
            }
            resultNode.node(RB.$("report.key.attribute.name", new Object[0])).node(RB.$("report.key.name", new Object[0])).value(configuration.getAttributeName()).end().node(RB.$("report.key.value", new Object[0])).value(((Optional)result.getResult()).get()).end();
        });
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
        private String attributeName;
        private String sectionName;

        public String getAttributeName() {
            return this.attributeName;
        }

        public Configuration withAttributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public String getSectionName() {
            return this.sectionName;
        }

        public Configuration withSectionName(String sectionName) {
            this.sectionName = sectionName;
            return this;
        }
    }
}

