/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.commands;

import java.util.Set;
import java.util.stream.Collectors;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.Format;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.internal.AbstractCommand;
import org.kordamp.jarviz.core.internal.AbstractConfiguration;
import org.kordamp.jarviz.core.model.ModuleName;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.ModuleNameJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;
import org.kordamp.jarviz.reporting.Node;

public class ModuleNameCommand
extends AbstractCommand<Configuration> {
    public static Configuration config() {
        return new Configuration();
    }

    @Override
    public int execute(Configuration configuration) {
        JarFileResolver jarFileResolver = this.createJarFileResolver(configuration);
        ModuleNameJarProcessor processor = new ModuleNameJarProcessor(jarFileResolver);
        Set<JarProcessor.JarFileResult<ModuleName>> results = processor.getResult();
        if (results.isEmpty()) {
            return 1;
        }
        this.output(configuration, results);
        this.report(configuration, results);
        Set errors = results.stream().map(JarProcessor.JarFileResult::getResult).filter(ModuleName::isNotValid).map(ModuleName::asError).collect(Collectors.toSet());
        if (configuration.isFailOnError()) {
            throw new JarvizException(String.join((CharSequence)System.lineSeparator(), errors));
        }
        configuration.getErr().println(String.join((CharSequence)System.lineSeparator(), errors));
        return 0;
    }

    private void output(Configuration configuration, Set<JarProcessor.JarFileResult<ModuleName>> results) {
        Node root = this.createRootNode();
        Format outputFormat = configuration.getOutputFormat();
        for (JarProcessor.JarFileResult<ModuleName> result : results) {
            if (null == outputFormat) {
                this.output(configuration, result);
                continue;
            }
            this.buildReport(root, result);
        }
        if (null != outputFormat) {
            this.writeOutput(configuration, this.resolveFormatter(outputFormat).write(root));
        }
    }

    private void output(Configuration configuration, JarProcessor.JarFileResult<ModuleName> result) {
        configuration.getOut().println(this.$$("output.subject", result.getJarFileName()));
        ModuleName moduleName = result.getResult();
        configuration.getOut().println(this.$$("module.name", moduleName.getModuleName()));
        configuration.getOut().println(this.$$("module.source", moduleName.resolveSource()));
        configuration.getOut().println(this.$$("module.automatic", this.$b(moduleName.isAutomatic())));
        configuration.getOut().println(this.$$("module.valid", this.$b(moduleName.isValid())));
        if (!moduleName.isValid()) {
            configuration.getOut().println(this.$$("module.reason", moduleName.getReason()));
        }
    }

    private void report(Configuration configuration, Set<JarProcessor.JarFileResult<ModuleName>> results) {
        if (null == configuration.getReportPath()) {
            return;
        }
        for (Format format : configuration.getReportFormats()) {
            Node root = this.createRootNode();
            for (JarProcessor.JarFileResult<ModuleName> result : results) {
                this.buildReport(root, result);
            }
            this.writeReport(configuration, this.resolveFormatter(format).write(root), format);
        }
    }

    private void buildReport(Node root, JarProcessor.JarFileResult<ModuleName> result) {
        ModuleName moduleName = result.getResult();
        this.appendSubject(root, result.getJarPath(), "module name", resultNode -> {
            resultNode.node(RB.$("report.key.name", new Object[0])).value(moduleName.getModuleName()).end().node(RB.$("report.key.source", new Object[0])).value(moduleName.resolveSource()).end().node(RB.$("report.key.automatic", new Object[0])).value(moduleName.isAutomatic()).end().node(RB.$("report.key.valid", new Object[0])).value(moduleName.isValid()).end();
            if (!moduleName.isValid()) {
                resultNode.node(RB.$("report.key.reason", new Object[0])).value(moduleName.getReason()).end();
            }
        });
    }

    public static class Configuration
    extends AbstractConfiguration<Configuration> {
    }
}

