/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.model;

import java.util.Objects;
import java.util.Properties;
import org.kordamp.jarviz.bundle.RB;
import org.kordamp.jarviz.core.JarvizException;

public class Gav {
    public static final String GROUP_ID = "groupId";
    public static final String ARTIFACT_ID = "artifactId";
    public static final String VERSION = "version";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;

    public Gav(String gav) {
        String[] parts = gav.split(":");
        if (parts.length == 4) {
            this.groupId = parts[0].trim().replace(".", "/");
            this.artifactId = parts[1].trim();
            this.version = parts[2].trim();
            this.classifier = parts[3].trim();
        } else if (parts.length == 3) {
            this.groupId = parts[0].trim().replace(".", "/");
            this.artifactId = parts[1].trim();
            this.version = parts[2].trim();
            this.classifier = null;
        } else {
            throw new JarvizException(RB.$("ERROR_INVALID_GAV", gav));
        }
    }

    public Gav(Properties props) {
        this.groupId = props.getProperty(GROUP_ID);
        this.artifactId = props.getProperty(ARTIFACT_ID);
        this.version = props.getProperty(VERSION);
        this.classifier = null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Gav gav = (Gav)o;
        return this.groupId.equals(gav.groupId) && this.artifactId.equals(gav.artifactId) && this.version.equals(gav.version) && Objects.equals(this.classifier, gav.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier);
    }
}

