/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.core.processors;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.kordamp.jarviz.core.JarvizException;
import org.kordamp.jarviz.core.analyzers.ModuleDescriptorJarPathAnalyzer;
import org.kordamp.jarviz.core.model.ModuleMetadata;
import org.kordamp.jarviz.core.model.ModuleName;
import org.kordamp.jarviz.core.processors.JarProcessor;
import org.kordamp.jarviz.core.processors.ModuleNameJarProcessor;
import org.kordamp.jarviz.core.resolvers.JarFileResolver;

public class ModuleDescriptorJarProcessor
implements JarProcessor<ModuleMetadata> {
    private final JarFileResolver jarFileResolver;
    private final ModuleNameJarProcessor moduleNameJarProcessor;

    public ModuleDescriptorJarProcessor(JarFileResolver jarFileResolver) {
        this.jarFileResolver = jarFileResolver;
        this.moduleNameJarProcessor = new ModuleNameJarProcessor(jarFileResolver);
    }

    @Override
    public Set<JarProcessor.JarFileResult<ModuleMetadata>> getResult() throws JarvizException {
        TreeSet<JarProcessor.JarFileResult<ModuleMetadata>> set = new TreeSet<JarProcessor.JarFileResult<ModuleMetadata>>();
        for (JarFile jarFile : this.jarFileResolver.resolveJarFiles()) {
            set.add(this.processJarFile(jarFile));
        }
        return set;
    }

    private JarProcessor.JarFileResult<ModuleMetadata> processJarFile(JarFile jarFile) {
        JarProcessor.JarFileResult<ModuleName> moduleName = this.moduleNameJarProcessor.processJarFile(jarFile);
        if (!moduleName.getResult().isValid()) {
            return JarProcessor.JarFileResult.of(jarFile, ModuleMetadata.of(moduleName.getResult()));
        }
        Path jarPath = Paths.get(jarFile.getName(), new String[0]);
        ModuleDescriptorJarPathAnalyzer analyzer = new ModuleDescriptorJarPathAnalyzer();
        analyzer.handle(jarPath);
        return JarProcessor.JarFileResult.of(jarFile, ModuleMetadata.of(moduleName.getResult(), analyzer.getResult()));
    }
}

