/*
 * Decompiled with CFR 0.152.
 */
package org.kordamp.jarviz.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.kordamp.jarviz.util.StringUtils;

public class Node {
    private final Node parent;
    private final int indentation;
    private final String name;
    private final List<Node> children = new ArrayList<Node>();
    private final boolean array;
    private final boolean collapsable;
    private Object value;

    private Node(Node parent, String name, boolean array, boolean collapsable) {
        this.parent = parent;
        this.name = name;
        this.array = array;
        this.collapsable = collapsable;
        this.indentation = null != parent ? parent.indentation + 1 : 0;
    }

    public int getIndentation() {
        return this.indentation;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return null != this.value ? String.valueOf(this.value) : null;
    }

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Optional<Node> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public boolean isCollapsable() {
        return this.collapsable;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isArrayElement() {
        return null != this.parent && this.parent.isArray() || null != this.parent && this.parent.isCollapsable();
    }

    public boolean isFirstChild() {
        return null != this.parent && this.parent.children.indexOf(this) == 0;
    }

    public Node value(Object value) {
        this.value = value;
        return this;
    }

    public Node node(String name) {
        Node child = new Node(this, name, false, false);
        this.children.add(child);
        return child;
    }

    public Node array(String name) {
        Node child = new Node(this, name, true, false);
        this.children.add(child);
        return child;
    }

    public Node collapsable(String name) {
        Node child = new Node(this, name, false, true);
        this.children.add(child);
        return child;
    }

    public Node children(Collection<String> elements) {
        for (String e : elements) {
            this.node(e);
        }
        return this;
    }

    public Node children(String name, Collection<String> elements) {
        for (String e : elements) {
            this.node(name).value(e);
        }
        return this;
    }

    public Node collapsableChildren(String name, Collection<String> elements) {
        for (String e : elements) {
            this.collapsable(name).value(e);
        }
        return this;
    }

    public Node cleanup() {
        this.children.removeIf(child -> StringUtils.isBlank(child.getValue()) && child.getChildren().isEmpty());
        return null != this.parent ? this.parent : this;
    }

    public Node end() {
        return null != this.parent ? this.parent : this;
    }

    public static Node root(String name) {
        return new Node(null, name, false, false);
    }
}

