/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import feign.codec.Encoder;
import feign.jackson.JacksonEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.sdk.sdkman.api.Announce;
import org.jreleaser.sdk.sdkman.api.Candidate;
import org.jreleaser.sdk.sdkman.api.Release;
import org.jreleaser.sdk.sdkman.api.SdkmanAPI;
import org.jreleaser.util.StringUtils;

public class Sdkman {
    private static final String KEY_UNIVERSAL = "UNIVERSAL";
    private final JReleaserContext context;
    private final SdkmanAPI api;
    private final boolean dryrun;

    public Sdkman(JReleaserContext context, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, boolean dryrun) {
        Objects.requireNonNull(context, "'context' must not be null");
        StringUtils.requireNonBlank((String)apiHost, (String)"'apiHost' must not be blank");
        StringUtils.requireNonBlank((String)consumerKey, (String)"'consumerKey' must not be blank");
        StringUtils.requireNonBlank((String)consumerToken, (String)"'consumerToken' must not be blank");
        this.context = context;
        this.dryrun = dryrun;
        this.api = (SdkmanAPI)ClientUtils.builder((JReleaserContext)context, (int)connectTimeout, (int)readTimeout).encoder((Encoder)new JacksonEncoder()).requestInterceptor(template -> {
            template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()});
            template.header("Consumer-Key", new String[]{consumerKey});
            template.header("Consumer-Token", new String[]{consumerToken});
            template.header("Content-Type", new String[]{"application/json"});
            template.header("Accept", new String[]{"application/json"});
        }).errorDecoder((methodKey, response) -> new IllegalStateException("Server returned error " + response.reason())).target(SdkmanAPI.class, apiHost);
        this.context.getLogger().debug(RB.$((String)"workflow.dryrun", (Object[])new Object[0]), new Object[]{dryrun});
    }

    public void announce(String candidate, String version) throws SdkmanException {
        this.announce(candidate, version, null, null);
    }

    public void announce(String candidate, String version, String hashtag, String releaseNotesUrl) throws SdkmanException {
        Announce payload = Announce.of(candidate, version, hashtag, releaseNotesUrl);
        this.context.getLogger().debug("sdkman.announce: " + payload);
        this.wrap(() -> this.api.announce(payload));
    }

    public void setDefault(String candidate, String version) throws SdkmanException {
        Candidate payload = Candidate.of(candidate, version);
        this.context.getLogger().debug("sdkman.default: " + payload);
        this.wrap(() -> this.api.setDefault(payload));
    }

    public void release(String candidate, String version, String url) throws SdkmanException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        platforms.put(KEY_UNIVERSAL, url);
        this.release(candidate, version, platforms);
    }

    public void release(String candidate, String version, String platform, String url) throws SdkmanException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        platforms.put(platform, url);
        this.release(candidate, version, platforms);
    }

    public void release(String candidate, String version, Map<String, String> platforms) throws SdkmanException {
        for (Map.Entry<String, String> entry : platforms.entrySet()) {
            Release payload = Release.of(candidate, version, entry.getKey(), entry.getValue());
            this.context.getLogger().debug("sdkman.release: " + payload);
            this.wrap(() -> this.api.release(payload));
        }
    }

    public void majorRelease(String candidate, String version, String url, String hashtag, String releaseNotesUrl, boolean skipAnnounce) throws SdkmanException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        platforms.put(KEY_UNIVERSAL, url);
        this.majorRelease(candidate, version, platforms, hashtag, releaseNotesUrl, skipAnnounce);
    }

    public void majorRelease(String candidate, String version, String platform, String url, String hashtag, String releaseNotesUrl, boolean skipAnnounce) throws SdkmanException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        platforms.put(platform, url);
        this.majorRelease(candidate, version, platforms, hashtag, releaseNotesUrl, skipAnnounce);
    }

    public void majorRelease(String candidate, String version, Map<String, String> platforms, String hashtag, String releaseNotesUrl, boolean skipAnnounce) throws SdkmanException {
        this.release(candidate, version, platforms);
        if (!skipAnnounce) {
            this.announce(candidate, version, hashtag, releaseNotesUrl);
        }
        this.setDefault(candidate, version);
    }

    public void minorRelease(String candidate, String version, String url, String hashtag, String releaseNotesUrl, boolean skipAnnounce) throws SdkmanException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        platforms.put(KEY_UNIVERSAL, url);
        this.minorRelease(candidate, version, platforms, hashtag, releaseNotesUrl, skipAnnounce);
    }

    public void minorRelease(String candidate, String version, String platform, String url, String hashtag, String releaseNotesUrl, boolean skipAnnounce) throws SdkmanException {
        LinkedHashMap<String, String> platforms = new LinkedHashMap<String, String>();
        platforms.put(platform, url);
        this.minorRelease(candidate, version, platforms, hashtag, releaseNotesUrl, skipAnnounce);
    }

    public void minorRelease(String candidate, String version, Map<String, String> platforms, String hashtag, String releaseNotesUrl, boolean skipAnnounce) throws SdkmanException {
        this.release(candidate, version, platforms);
        if (!skipAnnounce) {
            this.announce(candidate, version, hashtag, releaseNotesUrl);
        }
    }

    private void wrap(Runnable runnable) throws SdkmanException {
        try {
            if (!this.dryrun) {
                runnable.run();
            }
        }
        catch (RuntimeException e) {
            this.context.getLogger().trace((Throwable)e);
            throw new SdkmanException(RB.$((String)"sdk.operation.failed", (Object[])new Object[]{"Sdkman"}), e);
        }
    }
}

