/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus3;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.model.spi.upload.UploadException;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.nexus3.Nexus3Exception;
import org.jreleaser.util.StringUtils;

public class Nexus3 {
    private final JReleaserContext context;
    private final boolean dryrun;
    private final String publishUrl;
    private final String username;
    private final String password;
    private final int connectTimeout;
    private final int readTimeout;

    public Nexus3(JReleaserContext context, String publishUrl, String username, String password, int connectTimeout, int readTimeout, boolean dryrun) {
        this.context = Objects.requireNonNull(context, "'context' must not be blank");
        this.publishUrl = StringUtils.requireNonBlank((String)publishUrl, (String)"'publishUrl' must not be blank").trim();
        this.username = StringUtils.requireNonBlank((String)username, (String)"'username' must not be blank").trim();
        this.password = StringUtils.requireNonBlank((String)password, (String)"'password' must not be blank").trim();
        this.dryrun = dryrun;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public void deploy(String groupId, String artifactId, Set<Deployable> deployables) throws Nexus3Exception {
        this.context.getLogger().debug(" - " + RB.$((String)"nexus3.deploy.artifact", (Object[])new Object[]{groupId, artifactId}));
        try {
            ArrayList<Object> data = new ArrayList<Object>();
            int assetId = 1;
            for (Deployable deployable : deployables) {
                data.add(new ClientUtils.FieldFormData("maven2.asset" + assetId + ".extension", (Object)deployable.getExtension()));
                data.add(new ClientUtils.FileFormData("maven2.asset" + assetId, deployable.getLocalPath()));
                if (StringUtils.isNotBlank((String)deployable.getClassifier())) {
                    data.add(new ClientUtils.FieldFormData("maven2.asset" + assetId + ".classifier", (Object)deployable.getClassifier()));
                }
                ++assetId;
            }
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            String auth = this.username + ":" + this.password;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            auth = new String(encodedAuth, StandardCharsets.UTF_8);
            headers.put("Authorization", "Basic " + auth);
            ClientUtils.postData((JReleaserLogger)this.context.getLogger(), (String)this.publishUrl, (int)this.connectTimeout, (int)this.readTimeout, data, headers);
        }
        catch (UploadException e) {
            this.context.getLogger().error(" x {}:{}", new Object[]{groupId, artifactId, e});
            throw this.fail(RB.$((String)"ERROR_nexus3_deploy_artifact", (Object[])new Object[]{groupId, artifactId, e.getMessage()}), (Exception)((Object)e));
        }
    }

    private Nexus3Exception fail(String message) {
        return new Nexus3Exception(message);
    }

    private Nexus3Exception fail(String message, Exception e) {
        return new Nexus3Exception(message, e);
    }
}

