/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.flow.Block;
import org.xml.sax.Locator;

public abstract class FObjMixed
extends FObj {
    private FOText ft;
    protected FONode currentTextNode;
    protected FOText lastFOTextProcessed;

    protected FObjMixed(FONode parent) {
        super(parent);
    }

    @Override
    public FONode clone(FONode parent, boolean removeChildren) throws FOPException {
        this.flushText();
        FObjMixed clone = (FObjMixed)super.clone(parent, removeChildren);
        if (removeChildren) {
            clone.currentTextNode = null;
        }
        return clone;
    }

    @Override
    protected void characters(char[] data, int start, int length, PropertyList pList, Locator locator) throws FOPException {
        if (this.ft == null) {
            this.ft = new FOText(this);
            this.ft.setLocator(locator);
            if (!this.inMarker()) {
                this.ft.bind(pList);
            }
        }
        this.ft.characters(data, start, length, null, null);
    }

    @Override
    public void endOfNode() throws FOPException {
        super.endOfNode();
        if (!this.inMarker() || this.getNameId() == 44) {
            this.sendCharacters();
        }
    }

    protected static void handleWhiteSpaceFor(FObjMixed fobj, FONode nextChild) {
        fobj.getBuilderContext().getXMLWhiteSpaceHandler().handleWhiteSpace(fobj, fobj.currentTextNode, nextChild);
    }

    private void flushText() throws FOPException {
        if (this.ft != null) {
            FOText lft = this.ft;
            this.ft = null;
            if (this.getNameId() == 3) {
                lft.createBlockPointers((Block)this);
                this.lastFOTextProcessed = lft;
            } else if (this.getNameId() != 44 && this.getNameId() != 80 && this.getNameId() != 7) {
                FONode fo = this.parent;
                int foNameId = fo.getNameId();
                while (foNameId != 3 && foNameId != 44 && foNameId != 80 && foNameId != 7 && foNameId != 53) {
                    fo = fo.getParent();
                    foNameId = fo.getNameId();
                }
                if (foNameId == 3) {
                    lft.createBlockPointers((Block)fo);
                    ((FObjMixed)fo).lastFOTextProcessed = lft;
                } else if (foNameId == 53 && lft.willCreateArea()) {
                    log.error("Could not create block pointers. FOText w/o Block ancestor.");
                }
            }
            this.addChildNode(lft);
        }
    }

    private void sendCharacters() throws FOPException {
        if (this.currentTextNode != null) {
            FONode.FONodeIterator nodeIter = this.getChildNodes(this.currentTextNode);
            while (nodeIter.hasNext()) {
                FONode node = nodeIter.next();
                assert (node instanceof FOText || node.getNameId() == 10);
                if (node.getNameId() == 10) {
                    node.startOfNode();
                }
                node.endOfNode();
            }
        }
        this.currentTextNode = null;
    }

    @Override
    protected void addChildNode(FONode child) throws FOPException {
        this.flushText();
        if (!this.inMarker()) {
            if (child instanceof FOText || child.getNameId() == 10) {
                if (this.currentTextNode == null) {
                    this.currentTextNode = child;
                }
            } else {
                FObjMixed.handleWhiteSpaceFor(this, child);
                this.sendCharacters();
            }
        }
        super.addChildNode(child);
    }

    @Override
    public void removeChild(FONode child) {
        super.removeChild(child);
        if (child == this.currentTextNode) {
            this.currentTextNode = child.siblings != null ? child.siblings[1] : null;
        }
    }

    @Override
    public void finalizeNode() throws FOPException {
        this.flushText();
        if (!this.inMarker() || this.getNameId() == 44) {
            FObjMixed.handleWhiteSpaceFor(this, null);
        }
    }

    @Override
    public CharIterator charIterator() {
        return new RecursiveCharIterator(this);
    }
}

