/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "zu" locale.
 */
public class LocalizedNamesImpl_zu extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ZA",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "EZ",
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AC",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BV",
        "BR",
        "IO",
        "VG",
        "BN",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "KY",
        "CF",
        "TD",
        "CL",
        "CN",
        "CX",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CK",
        "CR",
        "CI",
        "HR",
        "CU",
        "EA",
        "CW",
        "CY",
        "CZ",
        "DK",
        "DG",
        "DJ",
        "DM",
        "DO",
        "EC",
        "EG",
        "SV",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "FI",
        "FR",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GE",
        "DE",
        "GH",
        "GI",
        "GR",
        "GL",
        "GD",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GY",
        "HT",
        "HM",
        "HN",
        "HK",
        "HU",
        "IS",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "IM",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KI",
        "XK",
        "KW",
        "KG",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MO",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MH",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MA",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NL",
        "NC",
        "NZ",
        "NI",
        "NE",
        "NG",
        "ZA",
        "NU",
        "NF",
        "MP",
        "KP",
        "NO",
        "OM",
        "QO",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PT",
        "PR",
        "QA",
        "RE",
        "RO",
        "RU",
        "RW",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "SM",
        "ST",
        "SA",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SK",
        "SI",
        "SB",
        "SO",
        "GS",
        "KR",
        "SS",
        "ES",
        "LK",
        "SH",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SE",
        "CH",
        "SY",
        "TW",
        "TJ",
        "TZ",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TC",
        "TV",
        "UM",
        "VI",
        "UG",
        "UA",
        "AE",
        "GB",
        "UN",
        "US",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "EH",
        "YE",
        "ZM",
        "ZW",
        "IL",
        "XA",
        "XB",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "umhlaba");
    namesMap.put("002", "i-Africa");
    namesMap.put("003", "i-North America");
    namesMap.put("005", "i-South America");
    namesMap.put("009", "i-Oceania");
    namesMap.put("011", "i-Western Africa");
    namesMap.put("013", "i-Central America");
    namesMap.put("014", "i-Eastern Africa");
    namesMap.put("015", "i-Northern Africa");
    namesMap.put("017", "i-Middle Africa");
    namesMap.put("018", "i-Southern Africa");
    namesMap.put("019", "i-Americas");
    namesMap.put("021", "i-Northern America");
    namesMap.put("029", "i-Caribbean");
    namesMap.put("030", "i-Eastern Asia");
    namesMap.put("034", "i-Southern Asia");
    namesMap.put("035", "i-South-Eastern Asia");
    namesMap.put("039", "i-Southern Europe");
    namesMap.put("053", "i-Australasia");
    namesMap.put("054", "i-Melanesia");
    namesMap.put("057", "i-Micronesian Region");
    namesMap.put("061", "i-Polynesia");
    namesMap.put("142", "i-Asia");
    namesMap.put("143", "i-Central Asia");
    namesMap.put("145", "i-Western Asia");
    namesMap.put("150", "i-Europe");
    namesMap.put("151", "i-Eastern Europe");
    namesMap.put("154", "i-Northern Europe");
    namesMap.put("155", "i-Western Europe");
    namesMap.put("419", "i-Latin America");
    namesMap.put("AC", "i-Ascension Island");
    namesMap.put("AD", "i-Andorra");
    namesMap.put("AE", "i-United Arab Emirates");
    namesMap.put("AF", "i-Afghanistan");
    namesMap.put("AG", "i-Antigua ne-Barbuda");
    namesMap.put("AI", "i-Anguilla");
    namesMap.put("AL", "i-Albania");
    namesMap.put("AM", "i-Armenia");
    namesMap.put("AO", "i-Angola");
    namesMap.put("AQ", "i-Antarctica");
    namesMap.put("AR", "i-Argentina");
    namesMap.put("AS", "i-American Samoa");
    namesMap.put("AT", "i-Austria");
    namesMap.put("AU", "i-Australia");
    namesMap.put("AW", "i-Aruba");
    namesMap.put("AX", "i-Åland Islands");
    namesMap.put("AZ", "i-Azerbaijan");
    namesMap.put("BA", "i-Bosnia ne-Herzegovina");
    namesMap.put("BB", "i-Barbados");
    namesMap.put("BD", "i-Bangladesh");
    namesMap.put("BE", "i-Belgium");
    namesMap.put("BF", "i-Burkina Faso");
    namesMap.put("BG", "i-Bulgaria");
    namesMap.put("BH", "i-Bahrain");
    namesMap.put("BI", "i-Burundi");
    namesMap.put("BJ", "i-Benin");
    namesMap.put("BL", "i-Saint Barthélemy");
    namesMap.put("BM", "i-Bermuda");
    namesMap.put("BN", "i-Brunei");
    namesMap.put("BO", "i-Bolivia");
    namesMap.put("BQ", "i-Caribbean Netherlands");
    namesMap.put("BR", "i-Brazil");
    namesMap.put("BS", "i-Bahamas");
    namesMap.put("BT", "i-Bhutan");
    namesMap.put("BV", "i-Bouvet Island");
    namesMap.put("BW", "iBotswana");
    namesMap.put("BY", "i-Belarus");
    namesMap.put("BZ", "i-Belize");
    namesMap.put("CA", "i-Canada");
    namesMap.put("CC", "i-Cocos (Keeling) Islands");
    namesMap.put("CD", "i-Congo - Kinshasa");
    namesMap.put("CF", "i-Central African Republic");
    namesMap.put("CG", "i-Congo - Brazzaville");
    namesMap.put("CH", "i-Switzerland");
    namesMap.put("CI", "i-Côte d’Ivoire");
    namesMap.put("CK", "i-Cook Islands");
    namesMap.put("CL", "i-Chile");
    namesMap.put("CM", "i-Cameroon");
    namesMap.put("CN", "i-China");
    namesMap.put("CO", "i-Colombia");
    namesMap.put("CP", "i-Clipperton Island");
    namesMap.put("CR", "i-Costa Rica");
    namesMap.put("CU", "i-Cuba");
    namesMap.put("CV", "i-Cape Verde");
    namesMap.put("CW", "i-Curaçao");
    namesMap.put("CX", "i-Christmas Island");
    namesMap.put("CY", "i-Cyprus");
    namesMap.put("CZ", "i-Czechia");
    namesMap.put("DE", "i-Germany");
    namesMap.put("DG", "i-Diego Garcia");
    namesMap.put("DJ", "i-Djibouti");
    namesMap.put("DK", "i-Denmark");
    namesMap.put("DM", "i-Dominica");
    namesMap.put("DO", "i-Dominican Republic");
    namesMap.put("DZ", "i-Algeria");
    namesMap.put("EA", "i-Cueta ne-Melilla");
    namesMap.put("EC", "i-Ecuador");
    namesMap.put("EE", "i-Estonia");
    namesMap.put("EG", "i-Egypt");
    namesMap.put("EH", "i-Western Sahara");
    namesMap.put("ER", "i-Eritrea");
    namesMap.put("ES", "i-Spain");
    namesMap.put("ET", "i-Ethiopia");
    namesMap.put("EU", "i-European Union");
    namesMap.put("FI", "i-Finland");
    namesMap.put("FJ", "i-Fiji");
    namesMap.put("FK", "i-Falkland Islands");
    namesMap.put("FM", "i-Micronesia");
    namesMap.put("FO", "i-Faroe Islands");
    namesMap.put("FR", "i-France");
    namesMap.put("GA", "i-Gabon");
    namesMap.put("GB", "i-United Kingdom");
    namesMap.put("GD", "i-Grenada");
    namesMap.put("GE", "i-Georgia");
    namesMap.put("GF", "i-French Guiana");
    namesMap.put("GG", "i-Guernsey");
    namesMap.put("GH", "i-Ghana");
    namesMap.put("GI", "i-Gibraltar");
    namesMap.put("GL", "i-Greenland");
    namesMap.put("GM", "i-Gambia");
    namesMap.put("GN", "i-Guinea");
    namesMap.put("GP", "i-Guadeloupe");
    namesMap.put("GQ", "i-Equatorial Guinea");
    namesMap.put("GR", "i-Greece");
    namesMap.put("GS", "i-South Georgia ne-South Sandwich Islands");
    namesMap.put("GT", "i-Guatemala");
    namesMap.put("GU", "i-Guam");
    namesMap.put("GW", "i-Guinea-Bissau");
    namesMap.put("GY", "i-Guyana");
    namesMap.put("HK", "i-Hong Kong SAR China");
    namesMap.put("HM", "i-Heard Island ne-McDonald Islands");
    namesMap.put("HN", "i-Honduras");
    namesMap.put("HR", "i-Croatia");
    namesMap.put("HT", "i-Haiti");
    namesMap.put("HU", "i-Hungary");
    namesMap.put("IC", "i-Canary Islands");
    namesMap.put("ID", "i-Indonesia");
    namesMap.put("IE", "i-Ireland");
    namesMap.put("IL", "kwa-Israel");
    namesMap.put("IM", "i-Isle of Man");
    namesMap.put("IN", "i-India");
    namesMap.put("IO", "i-British Indian Ocean Territory");
    namesMap.put("IQ", "i-Iraq");
    namesMap.put("IR", "i-Iran");
    namesMap.put("IS", "i-Iceland");
    namesMap.put("IT", "i-Italy");
    namesMap.put("JE", "i-Jersey");
    namesMap.put("JM", "i-Jamaica");
    namesMap.put("JO", "i-Jordan");
    namesMap.put("JP", "i-Japan");
    namesMap.put("KE", "i-Kenya");
    namesMap.put("KG", "i-Kyrgyzstan");
    namesMap.put("KH", "i-Cambodia");
    namesMap.put("KI", "i-Kiribati");
    namesMap.put("KM", "i-Comoros");
    namesMap.put("KN", "i-Saint Kitts ne-Nevis");
    namesMap.put("KP", "i-North Korea");
    namesMap.put("KR", "i-South Korea");
    namesMap.put("KW", "i-Kuwait");
    namesMap.put("KY", "i-Cayman Islands");
    namesMap.put("KZ", "i-Kazakhstan");
    namesMap.put("LA", "i-Laos");
    namesMap.put("LB", "i-Lebanon");
    namesMap.put("LC", "i-Saint Lucia");
    namesMap.put("LI", "i-Liechtenstein");
    namesMap.put("LK", "i-Sri Lanka");
    namesMap.put("LR", "i-Liberia");
    namesMap.put("LS", "iLesotho");
    namesMap.put("LT", "i-Lithuania");
    namesMap.put("LU", "i-Luxembourg");
    namesMap.put("LV", "i-Latvia");
    namesMap.put("LY", "i-Libya");
    namesMap.put("MA", "i-Morocco");
    namesMap.put("MC", "i-Monaco");
    namesMap.put("MD", "i-Moldova");
    namesMap.put("ME", "i-Montenegro");
    namesMap.put("MF", "i-Saint Martin");
    namesMap.put("MG", "i-Madagascar");
    namesMap.put("MH", "i-Marshall Islands");
    namesMap.put("MK", "i-Macedonia");
    namesMap.put("ML", "iMali");
    namesMap.put("MM", "i-Myanmar (Burma)");
    namesMap.put("MN", "i-Mongolia");
    namesMap.put("MO", "i-Macau SAR China");
    namesMap.put("MP", "i-Northern Mariana Islands");
    namesMap.put("MQ", "i-Martinique");
    namesMap.put("MR", "i-Mauritania");
    namesMap.put("MS", "i-Montserrat");
    namesMap.put("MT", "i-Malta");
    namesMap.put("MU", "i-Mauritius");
    namesMap.put("MV", "i-Maldives");
    namesMap.put("MW", "iMalawi");
    namesMap.put("MX", "i-Mexico");
    namesMap.put("MY", "i-Malaysia");
    namesMap.put("MZ", "i-Mozambique");
    namesMap.put("NA", "i-Namibia");
    namesMap.put("NC", "i-New Caledonia");
    namesMap.put("NE", "i-Niger");
    namesMap.put("NF", "i-Norfolk Island");
    namesMap.put("NG", "i-Nigeria");
    namesMap.put("NI", "i-Nicaragua");
    namesMap.put("NL", "i-Netherlands");
    namesMap.put("NO", "i-Norway");
    namesMap.put("NP", "i-Nepal");
    namesMap.put("NR", "i-Nauru");
    namesMap.put("NU", "i-Niue");
    namesMap.put("NZ", "i-New Zealand");
    namesMap.put("OM", "i-Oman");
    namesMap.put("PA", "i-Panama");
    namesMap.put("PE", "i-Peru");
    namesMap.put("PF", "i-French Polynesia");
    namesMap.put("PG", "i-Papua New Guinea");
    namesMap.put("PH", "i-Philippines");
    namesMap.put("PK", "i-Pakistan");
    namesMap.put("PL", "i-Poland");
    namesMap.put("PM", "i-Saint Pierre kanye ne-Miquelon");
    namesMap.put("PN", "i-Pitcairn Islands");
    namesMap.put("PR", "i-Puerto Rico");
    namesMap.put("PS", "i-Palestinian Territories");
    namesMap.put("PT", "i-Portugal");
    namesMap.put("PW", "i-Palau");
    namesMap.put("PY", "i-Paraguay");
    namesMap.put("QA", "i-Qatar");
    namesMap.put("QO", "i-Outlying Oceania");
    namesMap.put("RE", "i-Réunion");
    namesMap.put("RO", "i-Romania");
    namesMap.put("RS", "i-Serbia");
    namesMap.put("RU", "i-Russia");
    namesMap.put("RW", "i-Rwanda");
    namesMap.put("SA", "i-Saudi Arabia");
    namesMap.put("SB", "i-Solomon Islands");
    namesMap.put("SC", "i-Seychelles");
    namesMap.put("SD", "i-Sudan");
    namesMap.put("SE", "i-Sweden");
    namesMap.put("SG", "i-Singapore");
    namesMap.put("SH", "i-St. Helena");
    namesMap.put("SI", "i-Slovenia");
    namesMap.put("SJ", "i-Svalbard ne-Jan Mayen");
    namesMap.put("SK", "i-Slovakia");
    namesMap.put("SL", "i-Sierra Leone");
    namesMap.put("SM", "i-San Marino");
    namesMap.put("SN", "i-Senegal");
    namesMap.put("SO", "i-Somalia");
    namesMap.put("SR", "i-Suriname");
    namesMap.put("SS", "i-South Sudan");
    namesMap.put("ST", "i-São Tomé kanye ne-Príncipe");
    namesMap.put("SV", "i-El Salvador");
    namesMap.put("SX", "i-Sint Maarten");
    namesMap.put("SY", "i-Syria");
    namesMap.put("SZ", "i-Swaziland");
    namesMap.put("TA", "i-Tristan da Cunha");
    namesMap.put("TC", "i-Turks ne-Caicos Islands");
    namesMap.put("TD", "i-Chad");
    namesMap.put("TF", "i-French Southern Territories");
    namesMap.put("TG", "i-Togo");
    namesMap.put("TH", "i-Thailand");
    namesMap.put("TJ", "i-Tajikistan");
    namesMap.put("TK", "i-Tokelau");
    namesMap.put("TL", "i-Timor-Leste");
    namesMap.put("TM", "i-Turkmenistan");
    namesMap.put("TN", "i-Tunisia");
    namesMap.put("TO", "i-Tonga");
    namesMap.put("TR", "i-Turkey");
    namesMap.put("TT", "i-Trinidad ne-Tobago");
    namesMap.put("TV", "i-Tuvalu");
    namesMap.put("TW", "i-Taiwan");
    namesMap.put("TZ", "i-Tanzania");
    namesMap.put("UA", "i-Ukraine");
    namesMap.put("UG", "i-Uganda");
    namesMap.put("UM", "i-U.S. Minor Outlying Islands");
    namesMap.put("UN", "I-United Nations");
    namesMap.put("US", "i-United States");
    namesMap.put("UY", "i-Uruguay");
    namesMap.put("UZ", "i-Uzbekistan");
    namesMap.put("VA", "i-Vatican City");
    namesMap.put("VC", "i-Saint Vincent ne-Grenadines");
    namesMap.put("VE", "i-Venezuela");
    namesMap.put("VG", "i-British Virgin Islands");
    namesMap.put("VI", "i-U.S. Virgin Islands");
    namesMap.put("VN", "i-Vietnam");
    namesMap.put("VU", "i-Vanuatu");
    namesMap.put("WF", "i-Wallis ne-Futuna");
    namesMap.put("WS", "i-Samoa");
    namesMap.put("XK", "i-Kosovo");
    namesMap.put("YE", "i-Yemen");
    namesMap.put("YT", "i-Mayotte");
    namesMap.put("ZA", "iNingizimu Afrika");
    namesMap.put("ZM", "i-Zambia");
    namesMap.put("ZW", "iZimbabwe");
    namesMap.put("ZZ", "iSifunda esingaziwa");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "umhlaba",
        "002": "i-Africa",
        "003": "i-North America",
        "005": "i-South America",
        "009": "i-Oceania",
        "011": "i-Western Africa",
        "013": "i-Central America",
        "014": "i-Eastern Africa",
        "015": "i-Northern Africa",
        "017": "i-Middle Africa",
        "018": "i-Southern Africa",
        "019": "i-Americas",
        "021": "i-Northern America",
        "029": "i-Caribbean",
        "030": "i-Eastern Asia",
        "034": "i-Southern Asia",
        "035": "i-South-Eastern Asia",
        "039": "i-Southern Europe",
        "053": "i-Australasia",
        "054": "i-Melanesia",
        "057": "i-Micronesian Region",
        "061": "i-Polynesia",
        "142": "i-Asia",
        "143": "i-Central Asia",
        "145": "i-Western Asia",
        "150": "i-Europe",
        "151": "i-Eastern Europe",
        "154": "i-Northern Europe",
        "155": "i-Western Europe",
        "419": "i-Latin America",
        "AC": "i-Ascension Island",
        "AD": "i-Andorra",
        "AE": "i-United Arab Emirates",
        "AF": "i-Afghanistan",
        "AG": "i-Antigua ne-Barbuda",
        "AI": "i-Anguilla",
        "AL": "i-Albania",
        "AM": "i-Armenia",
        "AO": "i-Angola",
        "AQ": "i-Antarctica",
        "AR": "i-Argentina",
        "AS": "i-American Samoa",
        "AT": "i-Austria",
        "AU": "i-Australia",
        "AW": "i-Aruba",
        "AX": "i-Åland Islands",
        "AZ": "i-Azerbaijan",
        "BA": "i-Bosnia ne-Herzegovina",
        "BB": "i-Barbados",
        "BD": "i-Bangladesh",
        "BE": "i-Belgium",
        "BF": "i-Burkina Faso",
        "BG": "i-Bulgaria",
        "BH": "i-Bahrain",
        "BI": "i-Burundi",
        "BJ": "i-Benin",
        "BL": "i-Saint Barthélemy",
        "BM": "i-Bermuda",
        "BN": "i-Brunei",
        "BO": "i-Bolivia",
        "BQ": "i-Caribbean Netherlands",
        "BR": "i-Brazil",
        "BS": "i-Bahamas",
        "BT": "i-Bhutan",
        "BV": "i-Bouvet Island",
        "BW": "iBotswana",
        "BY": "i-Belarus",
        "BZ": "i-Belize",
        "CA": "i-Canada",
        "CC": "i-Cocos (Keeling) Islands",
        "CD": "i-Congo - Kinshasa",
        "CF": "i-Central African Republic",
        "CG": "i-Congo - Brazzaville",
        "CH": "i-Switzerland",
        "CI": "i-Côte d’Ivoire",
        "CK": "i-Cook Islands",
        "CL": "i-Chile",
        "CM": "i-Cameroon",
        "CN": "i-China",
        "CO": "i-Colombia",
        "CP": "i-Clipperton Island",
        "CR": "i-Costa Rica",
        "CU": "i-Cuba",
        "CV": "i-Cape Verde",
        "CW": "i-Curaçao",
        "CX": "i-Christmas Island",
        "CY": "i-Cyprus",
        "CZ": "i-Czechia",
        "DE": "i-Germany",
        "DG": "i-Diego Garcia",
        "DJ": "i-Djibouti",
        "DK": "i-Denmark",
        "DM": "i-Dominica",
        "DO": "i-Dominican Republic",
        "DZ": "i-Algeria",
        "EA": "i-Cueta ne-Melilla",
        "EC": "i-Ecuador",
        "EE": "i-Estonia",
        "EG": "i-Egypt",
        "EH": "i-Western Sahara",
        "ER": "i-Eritrea",
        "ES": "i-Spain",
        "ET": "i-Ethiopia",
        "EU": "i-European Union",
        "FI": "i-Finland",
        "FJ": "i-Fiji",
        "FK": "i-Falkland Islands",
        "FM": "i-Micronesia",
        "FO": "i-Faroe Islands",
        "FR": "i-France",
        "GA": "i-Gabon",
        "GB": "i-United Kingdom",
        "GD": "i-Grenada",
        "GE": "i-Georgia",
        "GF": "i-French Guiana",
        "GG": "i-Guernsey",
        "GH": "i-Ghana",
        "GI": "i-Gibraltar",
        "GL": "i-Greenland",
        "GM": "i-Gambia",
        "GN": "i-Guinea",
        "GP": "i-Guadeloupe",
        "GQ": "i-Equatorial Guinea",
        "GR": "i-Greece",
        "GS": "i-South Georgia ne-South Sandwich Islands",
        "GT": "i-Guatemala",
        "GU": "i-Guam",
        "GW": "i-Guinea-Bissau",
        "GY": "i-Guyana",
        "HK": "i-Hong Kong SAR China",
        "HM": "i-Heard Island ne-McDonald Islands",
        "HN": "i-Honduras",
        "HR": "i-Croatia",
        "HT": "i-Haiti",
        "HU": "i-Hungary",
        "IC": "i-Canary Islands",
        "ID": "i-Indonesia",
        "IE": "i-Ireland",
        "IL": "kwa-Israel",
        "IM": "i-Isle of Man",
        "IN": "i-India",
        "IO": "i-British Indian Ocean Territory",
        "IQ": "i-Iraq",
        "IR": "i-Iran",
        "IS": "i-Iceland",
        "IT": "i-Italy",
        "JE": "i-Jersey",
        "JM": "i-Jamaica",
        "JO": "i-Jordan",
        "JP": "i-Japan",
        "KE": "i-Kenya",
        "KG": "i-Kyrgyzstan",
        "KH": "i-Cambodia",
        "KI": "i-Kiribati",
        "KM": "i-Comoros",
        "KN": "i-Saint Kitts ne-Nevis",
        "KP": "i-North Korea",
        "KR": "i-South Korea",
        "KW": "i-Kuwait",
        "KY": "i-Cayman Islands",
        "KZ": "i-Kazakhstan",
        "LA": "i-Laos",
        "LB": "i-Lebanon",
        "LC": "i-Saint Lucia",
        "LI": "i-Liechtenstein",
        "LK": "i-Sri Lanka",
        "LR": "i-Liberia",
        "LS": "iLesotho",
        "LT": "i-Lithuania",
        "LU": "i-Luxembourg",
        "LV": "i-Latvia",
        "LY": "i-Libya",
        "MA": "i-Morocco",
        "MC": "i-Monaco",
        "MD": "i-Moldova",
        "ME": "i-Montenegro",
        "MF": "i-Saint Martin",
        "MG": "i-Madagascar",
        "MH": "i-Marshall Islands",
        "MK": "i-Macedonia",
        "ML": "iMali",
        "MM": "i-Myanmar (Burma)",
        "MN": "i-Mongolia",
        "MO": "i-Macau SAR China",
        "MP": "i-Northern Mariana Islands",
        "MQ": "i-Martinique",
        "MR": "i-Mauritania",
        "MS": "i-Montserrat",
        "MT": "i-Malta",
        "MU": "i-Mauritius",
        "MV": "i-Maldives",
        "MW": "iMalawi",
        "MX": "i-Mexico",
        "MY": "i-Malaysia",
        "MZ": "i-Mozambique",
        "NA": "i-Namibia",
        "NC": "i-New Caledonia",
        "NE": "i-Niger",
        "NF": "i-Norfolk Island",
        "NG": "i-Nigeria",
        "NI": "i-Nicaragua",
        "NL": "i-Netherlands",
        "NO": "i-Norway",
        "NP": "i-Nepal",
        "NR": "i-Nauru",
        "NU": "i-Niue",
        "NZ": "i-New Zealand",
        "OM": "i-Oman",
        "PA": "i-Panama",
        "PE": "i-Peru",
        "PF": "i-French Polynesia",
        "PG": "i-Papua New Guinea",
        "PH": "i-Philippines",
        "PK": "i-Pakistan",
        "PL": "i-Poland",
        "PM": "i-Saint Pierre kanye ne-Miquelon",
        "PN": "i-Pitcairn Islands",
        "PR": "i-Puerto Rico",
        "PS": "i-Palestinian Territories",
        "PT": "i-Portugal",
        "PW": "i-Palau",
        "PY": "i-Paraguay",
        "QA": "i-Qatar",
        "QO": "i-Outlying Oceania",
        "RE": "i-Réunion",
        "RO": "i-Romania",
        "RS": "i-Serbia",
        "RU": "i-Russia",
        "RW": "i-Rwanda",
        "SA": "i-Saudi Arabia",
        "SB": "i-Solomon Islands",
        "SC": "i-Seychelles",
        "SD": "i-Sudan",
        "SE": "i-Sweden",
        "SG": "i-Singapore",
        "SH": "i-St. Helena",
        "SI": "i-Slovenia",
        "SJ": "i-Svalbard ne-Jan Mayen",
        "SK": "i-Slovakia",
        "SL": "i-Sierra Leone",
        "SM": "i-San Marino",
        "SN": "i-Senegal",
        "SO": "i-Somalia",
        "SR": "i-Suriname",
        "SS": "i-South Sudan",
        "ST": "i-São Tomé kanye ne-Príncipe",
        "SV": "i-El Salvador",
        "SX": "i-Sint Maarten",
        "SY": "i-Syria",
        "SZ": "i-Swaziland",
        "TA": "i-Tristan da Cunha",
        "TC": "i-Turks ne-Caicos Islands",
        "TD": "i-Chad",
        "TF": "i-French Southern Territories",
        "TG": "i-Togo",
        "TH": "i-Thailand",
        "TJ": "i-Tajikistan",
        "TK": "i-Tokelau",
        "TL": "i-Timor-Leste",
        "TM": "i-Turkmenistan",
        "TN": "i-Tunisia",
        "TO": "i-Tonga",
        "TR": "i-Turkey",
        "TT": "i-Trinidad ne-Tobago",
        "TV": "i-Tuvalu",
        "TW": "i-Taiwan",
        "TZ": "i-Tanzania",
        "UA": "i-Ukraine",
        "UG": "i-Uganda",
        "UM": "i-U.S. Minor Outlying Islands",
        "UN": "I-United Nations",
        "US": "i-United States",
        "UY": "i-Uruguay",
        "UZ": "i-Uzbekistan",
        "VA": "i-Vatican City",
        "VC": "i-Saint Vincent ne-Grenadines",
        "VE": "i-Venezuela",
        "VG": "i-British Virgin Islands",
        "VI": "i-U.S. Virgin Islands",
        "VN": "i-Vietnam",
        "VU": "i-Vanuatu",
        "WF": "i-Wallis ne-Futuna",
        "WS": "i-Samoa",
        "XK": "i-Kosovo",
        "YE": "i-Yemen",
        "YT": "i-Mayotte",
        "ZA": "iNingizimu Afrika",
        "ZM": "i-Zambia",
        "ZW": "iZimbabwe",
        "ZZ": "iSifunda esingaziwa"
    };
  }-*/;
}
