/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.json.parser;

import java.math.BigDecimal;
import java.math.BigInteger;

public class Yytoken {
    private final Kind kind;
    private boolean booleanValue;
    private String stringValue;
    private Number numberValue;

    public Yytoken(Kind kind) {
        this.kind = kind;
    }

    public Yytoken(Kind kind, String value) {
        this.kind = kind;
        this.stringValue = value;
    }

    public Yytoken(Kind kind, BigInteger value) {
        this.kind = kind;
        this.numberValue = value;
    }

    public Yytoken(Kind kind, BigDecimal value) {
        this.kind = kind;
        this.numberValue = value;
    }

    public Yytoken(Kind kind, boolean value) {
        this.kind = kind;
        this.booleanValue = value;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public BigInteger getIntegerValue() {
        return this.kind == Kind.VALUE_INTEGER ? (BigInteger)this.numberValue : null;
    }

    public BigDecimal getDecimalValue() {
        return this.kind == Kind.VALUE_DECIMAL ? (BigDecimal)this.numberValue : null;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public String toString() {
        switch (this.kind) {
            case VALUE_STRING: {
                return "{" + String.valueOf((Object)this.kind) + ": [" + this.stringValue + "]}";
            }
            case VALUE_INTEGER: 
            case VALUE_DECIMAL: {
                return "{" + String.valueOf((Object)this.kind) + ": [" + String.valueOf(this.numberValue) + "]}";
            }
        }
        return "{unknown}";
    }

    public static enum Kind {
        VALUE_INTEGER(true),
        VALUE_DECIMAL(true),
        VALUE_STRING(true),
        VALUE_BOOLEAN(true),
        VALUE_NULL(true),
        SYMBOL_LEFT_BRACE(false),
        SYMBOL_RIGHT_BRACE(false),
        SYMBOL_LEFT_SQUARE(false),
        SYMBOL_RIGHT_SQUARE(false),
        SYMBOL_COMMA(false),
        SYMBOL_COLON(false);

        private final boolean valueToken;

        private Kind(boolean value) {
            this.valueToken = value;
        }

        public boolean isValueToken() {
            return this.valueToken;
        }
    }
}

