/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mojo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.apache.avro.mojo.AbstractAvroMojo;
import org.apache.maven.artifact.DependencyResolutionRequiredException;

public class IDLMojo
extends AbstractAvroMojo {
    private String[] includes = new String[]{"**/*.avdl"};
    private String[] testIncludes = new String[]{"**/*.avdl"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCompile(String filename, File sourceDirectory, File outputDirectory) throws IOException {
        try {
            List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
            ArrayList<URL> runtimeUrls = new ArrayList<URL>();
            runtimeUrls.add(sourceDirectory.toURI().toURL());
            if (runtimeClasspathElements != null && !runtimeClasspathElements.isEmpty()) {
                for (Object runtimeClasspathElement : runtimeClasspathElements) {
                    String element = (String)runtimeClasspathElement;
                    runtimeUrls.add(new File(element).toURI().toURL());
                }
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader projPathLoader = new URLClassLoader(runtimeUrls.toArray(new URL[0]), contextClassLoader);
            Thread.currentThread().setContextClassLoader(projPathLoader);
            try {
                IdlReader parser = new IdlReader();
                Path sourceFilePath = sourceDirectory.toPath().resolve(filename);
                IdlFile idlFile = parser.parse(sourceFilePath);
                for (String warning : idlFile.getWarnings()) {
                    this.getLog().warn((CharSequence)warning);
                }
                Protocol protocol = idlFile.getProtocol();
                SpecificCompiler compiler = protocol != null ? new SpecificCompiler(protocol) : new SpecificCompiler(idlFile.getNamedSchemas().values());
                this.setCompilerProperties(compiler);
                for (String customConversion : this.customConversions) {
                    compiler.addCustomConversion(projPathLoader.loadClass(customConversion));
                }
                compiler.compileToDestination(sourceFilePath.toFile(), outputDirectory);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        catch (ClassNotFoundException | DependencyResolutionRequiredException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String[] getIncludes() {
        return this.includes;
    }

    @Override
    protected String[] getTestIncludes() {
        return this.testIncludes;
    }
}

