/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.brooklyn.api.location.BasicMachineLocationCustomizer;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.objs.BasicConfigurableObject;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SetLimitsCustomizer
extends BasicMachineLocationCustomizer
implements Configurable {
    public static final Logger log = LoggerFactory.getLogger(SetLimitsCustomizer.class);
    public static final ConfigKey<String> FILE_NAME = ConfigKeys.newStringConfigKey((String)"file", (String)"The limits conf file to append to (and to create if necessary)", (String)"/etc/security/limits.d/50-brooklyn.conf");
    public static final ConfigKey<List<String>> CONTENTS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"contents", (String)"The contents to be appended to the limits file", (Object)ImmutableList.of());
    private final BasicConfigurableObject.BasicConfigurationSupport config = new BasicConfigurableObject.BasicConfigurationSupport();

    public Configurable.ConfigurationSupport config() {
        return this.config;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    public void customize(MachineLocation machine) {
        if (!(machine instanceof SshMachineLocation)) {
            throw new IllegalStateException("Machine must be a SshMachineLocation, but got " + machine);
        }
        String file = (String)this.config.get(FILE_NAME);
        List contents = (List)this.config.get(CONTENTS);
        Preconditions.checkArgument((boolean)Strings.isNonBlank((CharSequence)((CharSequence)this.config.get(FILE_NAME))), (Object)"File must be non-empty");
        log.info("SetLimitsCustomizer setting limits on " + machine + " in file " + file + " to: " + Joiner.on((String)"; ").join((Iterable)contents));
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            for (String content : contents) {
                cmds.add(BashCommands.sudo((String)String.format("echo \"%s\" | tee -a %s", content, file)));
            }
            this.exec((SshMachineLocation)machine, true, cmds.toArray(new String[cmds.size()]));
        }
        catch (Exception e) {
            log.info("SetLimitsCustomizer failed to set limits on " + machine + " (rethrowing)", (Throwable)e);
            throw e;
        }
    }

    protected ProcessTaskWrapper<Integer> exec(SshMachineLocation machine, boolean asRoot, String ... cmds) {
        ProcessTaskWrapper result;
        SshEffectorTasks.SshEffectorTaskFactory taskFactory = (SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((SshMachineLocation)machine, (String[])cmds).configure(SshMachineLocation.CLOSE_CONNECTION, (Object)true);
        if (asRoot) {
            taskFactory.runAsRoot();
        }
        if ((Integer)(result = ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)taskFactory)).block()).get() != 0) {
            throw new IllegalStateException("SetLimitsCustomizer got exit code " + result.get() + " executing on machine " + machine + "; cmds=" + Arrays.asList(cmds) + "; stdout=" + result.getStdout() + "; stderr=" + result.getStderr());
        }
        return result;
    }
}

