/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.domain.IpBlock;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.RequestIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.ipblock.IpBlockListResponseHandler;
import org.jclouds.profitbricks.http.parser.ipblock.IpBlockResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface IpBlockApi {
    @POST
    @Named(value="publicipblock:get")
    @Payload(value="<ws:getPublicIpBlock><blockId>{id}</blockId></ws:getPublicIpBlock>")
    @XMLResponseParser(value=IpBlockResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public IpBlock getIpBlock(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="publicipblock:getall")
    @Payload(value="<ws:getAllPublicIpBlocks />")
    @XMLResponseParser(value=IpBlockListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<IpBlock> getAllIpBlock();

    @POST
    @Named(value="publicipblock:reserve")
    @Payload(value="<ws:reservePublicIpBlock><request><blockSize>{blockSize}</blockSize><location>{location}</location></request></ws:reservePublicIpBlock>")
    @XMLResponseParser(value=IpBlockResponseHandler.class)
    public IpBlock reservePublicIpBlock(@PayloadParam(value="blockSize") int var1, @PayloadParam(value="location") Location var2);

    @POST
    @Named(value="publicipblock:addip")
    @Payload(value="<ws:addPublicIpToNic><ip>{ip}</ip><nicId>{nicid}</nicId></ws:addPublicIpToNic>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String addPublicIpToNic(@PayloadParam(value="ip") String var1, @PayloadParam(value="nicid") String var2);

    @POST
    @Named(value="publicipblock:removeip")
    @Payload(value="<ws:removePublicIpFromNic><ip>{ip}</ip><nicId>{nicid}</nicId></ws:removePublicIpFromNic>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String removePublicIpFromNic(@PayloadParam(value="ip") String var1, @PayloadParam(value="nicid") String var2);

    @POST
    @Named(value="publicipblock:releaseblock")
    @Payload(value="<ws:releasePublicIpBlock><blockId>{blockid}</blockId></ws:releasePublicIpBlock>")
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String releasePublicIpBlock(@PayloadParam(value="blockid") String var1);
}

