/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;

public class TaskPredicates {
    public static Predicate<Task<?>> displayNameSatisfies(Predicate<? super String> matcher) {
        return new DisplayNameMatches(matcher);
    }

    public static Predicate<Task<?>> displayNameEqualTo(String name) {
        return TaskPredicates.displayNameSatisfies((Predicate<? super String>)Predicates.equalTo((Object)name));
    }

    public static Predicate<Task<?>> isDone() {
        return new IsDone();
    }

    public static Predicate<Task<?>> hasTag(Object tag) {
        return new HasTag(tag);
    }

    public static Predicate<Task<?>> isEffector() {
        return new IsEffector();
    }

    public static Predicate<Task<?>> isTransient() {
        return new IsTransient();
    }

    public static Predicate<Task<?>> isInessential() {
        return new IsInessential();
    }

    private static class IsInessential
    implements Predicate<Task<?>> {
        private IsInessential() {
        }

        public boolean apply(Task<?> input) {
            return input != null && BrooklynTaskTags.isInessential(input);
        }

        public String toString() {
            return "isTransient()";
        }
    }

    private static class IsTransient
    implements Predicate<Task<?>> {
        private IsTransient() {
        }

        public boolean apply(Task<?> input) {
            return input != null && BrooklynTaskTags.isTransient(input);
        }

        public String toString() {
            return "isTransient()";
        }
    }

    private static class IsEffector
    implements Predicate<Task<?>> {
        private IsEffector() {
        }

        public boolean apply(Task<?> input) {
            return input != null && BrooklynTaskTags.isEffectorTask(input);
        }

        public String toString() {
            return "isEffector()";
        }
    }

    private static class HasTag
    implements Predicate<Task<?>> {
        private final Object tag;

        public HasTag(Object tag) {
            this.tag = Preconditions.checkNotNull((Object)tag, (Object)"tag");
        }

        public boolean apply(Task<?> input) {
            return input != null && input.getTags().contains(this.tag);
        }

        public String toString() {
            return "hasTag(" + this.tag + ")";
        }
    }

    private static class IsDone
    implements Predicate<Task<?>> {
        private IsDone() {
        }

        public boolean apply(Task<?> input) {
            return input != null && input.isDone();
        }

        public String toString() {
            return "isDone()";
        }
    }

    private static class DisplayNameMatches
    implements Predicate<Task<?>> {
        private final Predicate<? super String> matcher;

        public DisplayNameMatches(Predicate<? super String> matcher) {
            this.matcher = (Predicate)Preconditions.checkNotNull(matcher, (Object)"matcher");
        }

        public boolean apply(Task<?> input) {
            return input != null && this.matcher.apply((Object)input.getDisplayName());
        }

        public String toString() {
            return "displayNameMatches(" + this.matcher + ")";
        }
    }
}

