/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.exceptions;

import com.google.common.annotations.Beta;
import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.RateLimitExceededException;

@Beta
public class AzureComputeRateLimitExceededException
extends RateLimitExceededException {
    private static final long serialVersionUID = 1L;
    private static final String RATE_LIMIT_HEADER_PREFIX = "x-ms-ratelimit-remaining-";

    public AzureComputeRateLimitExceededException(HttpResponse response) {
        super(response.getStatusLine() + "\n" + AzureComputeRateLimitExceededException.rateLimitHeaders(response));
    }

    public AzureComputeRateLimitExceededException(HttpResponse response, Throwable cause) {
        super(response.getStatusLine() + "\n" + AzureComputeRateLimitExceededException.rateLimitHeaders(response), cause);
    }

    private static Multimap<String, String> rateLimitHeaders(HttpResponse response) {
        return Multimaps.filterKeys((Multimap)response.getHeaders(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith(AzureComputeRateLimitExceededException.RATE_LIMIT_HEADER_PREFIX);
            }
        });
    }
}

