/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.cm.salt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.entity.cm.salt.SaltConfig;
import org.apache.brooklyn.entity.cm.salt.SaltEntityDriver;
import org.apache.brooklyn.entity.cm.salt.SaltEntityImpl;
import org.apache.brooklyn.entity.cm.salt.SaltHighstate;
import org.apache.brooklyn.entity.cm.salt.SaltSshTasks;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskBuilder;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaltEntitySshDriver
extends AbstractSoftwareProcessSshDriver
implements SaltEntityDriver {
    private static final Logger LOG = LoggerFactory.getLogger(SaltEntitySshDriver.class);
    private static final Pattern FAILURES = Pattern.compile(".*^Failed:\\s+(\\d+)$.*", 40);
    private static final String ZERO = "0";

    public SaltEntitySshDriver(SaltEntityImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public void install() {
        SaltConfig.SaltMode mode = (SaltConfig.SaltMode)((Object)this.getEntity().config().get(SaltConfig.SALT_MODE));
        Preconditions.checkNotNull((Object)((Object)mode), (Object)("Required config " + SaltConfig.SALT_MODE + " not provided for entity: " + this.entity));
        LOG.info("Starting salt in '{}' mode at '{}'", (Object)mode, (Object)this.getMachine().getDisplayName());
        if (mode != SaltConfig.SaltMode.MASTERLESS) {
            throw new IllegalStateException("Unknown salt mode: " + mode.name());
        }
        final Set startStates = (Set)this.getEntity().config().get(SaltConfig.START_STATES);
        final Set formulas = (Set)this.getEntity().config().get(SaltConfig.SALT_FORMULAS);
        final Set pillars = (Set)this.getEntity().config().get(SaltConfig.SALT_PILLARS);
        final Set pillarUrls = (Set)this.getEntity().config().get(SaltConfig.SALT_PILLAR_URLS);
        final String entityId = (String)this.getEntity().config().get(BrooklynCampConstants.PLAN_ID);
        ProcessTaskWrapper<Integer> installedAlready = this.queueAndBlock((ProcessTaskFactory<Integer>)SaltSshTasks.isSaltInstalled(false));
        if (0 != installedAlready.getExitCode()) {
            DynamicTasks.queue((String)"install", (Runnable)new Runnable(){

                @Override
                public void run() {
                    DynamicTasks.queue(SaltSshTasks.installSalt(false), SaltSshTasks.installSaltUtilities(false), (TaskFactory[])new TaskFactory[]{SaltSshTasks.configureForMasterlessOperation(false), SaltSshTasks.installTopFile(startStates, false)});
                    if (Strings.isNonBlank((CharSequence)entityId)) {
                        DynamicTasks.queue(SaltSshTasks.setMinionId(entityId));
                    }
                    SaltEntitySshDriver.this.installFormulas(formulas);
                    SaltEntitySshDriver.this.installPillars(pillars, pillarUrls);
                }
            });
        }
    }

    public void customize() {
        this.newScript("customizing").execute();
    }

    public void launch() {
        String name = "apply top states";
        ProcessTaskWrapper<Integer> topStates = this.queueAndBlock((ProcessTaskFactory<Integer>)SaltSshTasks.applyTopStates(false).summary(name));
        Matcher failCount = FAILURES.matcher(topStates.getStdout());
        if (!failCount.matches() || !ZERO.equals(failCount.group(1))) {
            LOG.warn("Encountered error in applying Salt top states: {}", (Object)topStates.getStdout());
            throw new RuntimeException("Encountered error in applying Salt top states, see '" + name + "' in activities for details");
        }
    }

    public void runPostLaunchCommand() {
        super.runPostLaunchCommand();
        ProcessTaskWrapper<String> retrieveHighstate = SaltSshTasks.retrieveHighstate();
        ProcessTaskWrapper highstate = ((ProcessTaskWrapper)DynamicTasks.queue(retrieveHighstate)).block();
        String stateDescription = (String)highstate.get();
        SaltHighstate.applyHighstate(stateDescription, (Entity)this.getEntity());
        this.getEntity().sensors().set(SoftwareProcess.SERVICE_UP, (Object)true);
    }

    public boolean isRunning() {
        return true;
    }

    public void stop() {
        Set stopStates = (Set)this.getEntity().config().get(SaltConfig.STOP_STATES);
        LOG.debug("Executing Salt stopProcessesAtMachine with states {}", (Object)stopStates);
        if (stopStates.isEmpty()) {
            this.stopBasedOnStartStates();
        } else {
            this.applyStates(stopStates);
        }
    }

    public void restart() {
        ServiceStateLogic.setExpectedState((Entity)this.getEntity(), (Lifecycle)Lifecycle.STOPPING);
        try {
            Set restartStates = (Set)this.getEntity().config().get(SaltConfig.RESTART_STATES);
            LOG.debug("Executing Salt restart with states {}", (Object)restartStates);
            if (restartStates.isEmpty()) {
                this.restartBasedOnStartStates();
            } else {
                this.applyStates(restartStates);
            }
            ServiceStateLogic.setExpectedState((Entity)this.getEntity(), (Lifecycle)Lifecycle.RUNNING);
        }
        catch (Exception e) {
            this.getEntity().sensors().set(ServiceStateLogic.SERVICE_NOT_UP_DIAGNOSTICS, (Object)ImmutableMap.of((Object)"restart", (Object)e.getMessage()));
            ServiceStateLogic.setExpectedState((Entity)this.getEntity(), (Lifecycle)Lifecycle.ON_FIRE);
        }
    }

    @Override
    public ProcessTaskWrapper<Integer> saltCall(String spec) {
        return (ProcessTaskWrapper)DynamicTasks.queue(SaltSshTasks.saltCall(spec));
    }

    private ProcessTaskWrapper<Integer> queueAndBlock(ProcessTaskFactory<Integer> taskFactory) {
        ProcessTaskWrapper queued = (ProcessTaskWrapper)DynamicTasks.queue(taskFactory);
        queued.asTask().blockUntilEnded();
        return queued;
    }

    private void installFormulas(Set<? extends String> formulas) {
        if (formulas.size() > 0) {
            DynamicTasks.queue(SaltSshTasks.enableFileRoots(false));
            TaskBuilder formulaTasks = TaskBuilder.builder().displayName("install formulas");
            for (String string : formulas) {
                formulaTasks.add(SaltSshTasks.installSaltFormula(string, false).newTask());
            }
            DynamicTasks.queue((TaskAdaptable)formulaTasks.build());
        }
    }

    private void installPillars(Set<? extends String> pillars, Set<? extends String> pillarUrls) {
        if (pillarUrls.size() > 0) {
            TaskBuilder pillarTasks = TaskBuilder.builder().displayName("install pillars");
            pillarTasks.add((TaskAdaptable)((SshEffectorTasks.SshEffectorTaskFactory)SaltSshTasks.invokeSaltUtility("init_pillar_config", null, false).summary("init pillar config")).newTask());
            for (String string : pillars) {
                pillarTasks.add(SaltSshTasks.addPillarToTop(string, false).newTask());
            }
            for (String string : pillarUrls) {
                pillarTasks.add(SaltSshTasks.installSaltPillar(string, false).newTask());
            }
            DynamicTasks.queue((TaskAdaptable)pillarTasks.build());
        }
    }

    private MutableSet<String> addSuffix(Set<? extends String> names, String suffix) {
        MutableSet suffixed = MutableSet.of();
        for (String string : names) {
            suffixed.add((Object)(string + suffix));
        }
        return suffixed;
    }

    private void applyStates(Set<? extends String> states) {
        for (String string : states) {
            DynamicTasks.queue((TaskFactory)SaltSshTasks.applyState(string, false).summary("apply state " + string));
        }
    }

    private void stopBasedOnStartStates() {
        Set startStates = (Set)this.getEntity().config().get(SaltConfig.START_STATES);
        MutableSet<String> stopStates = this.addSuffix(startStates, ".stop");
        ProcessTaskWrapper<Integer> checkStops = this.queueAndBlock((ProcessTaskFactory<Integer>)SaltSshTasks.verifyStates(stopStates, false).summary("check stop states"));
        if (0 != checkStops.getExitCode()) {
            throw new RuntimeException("No stop_states configured and not all start_states have matching stop states");
        }
        this.applyStates((Set<? extends String>)stopStates);
    }

    private void restartBasedOnStartStates() {
        String[] foundStates;
        Set startStates = (Set)this.getEntity().config().get(SaltConfig.START_STATES);
        MutableSet<String> restartStates = this.addSuffix(startStates, ".restart");
        ProcessTaskWrapper<Integer> queued = this.queueAndBlock((ProcessTaskFactory<Integer>)SaltSshTasks.findStates(restartStates, false).summary("check restart states"));
        String stdout = queued.getStdout();
        String[] stringArray = foundStates = Strings.isNonBlank((CharSequence)stdout) ? stdout.split("\\n") : null;
        if (restartStates.size() > 0 && foundStates != null && restartStates.size() == foundStates.length) {
            LOG.debug("All start_states have matching restart states, applying these");
            this.applyStates((Set<? extends String>)restartStates);
        } else {
            if (foundStates != null && foundStates.length > 0) {
                LOG.debug("Only some start_states have matching restart states, treating as restart failure");
                throw new RuntimeException("unable to find restart state for all applied states");
            }
            LOG.debug("No stop states available, invoking stop and start effectors");
            this.invokeEffector((Effector<Void>)Startable.STOP, ConfigBag.newInstance().configure(SoftwareProcess.StopSoftwareParameters.STOP_PROCESS_MODE, (Object)SoftwareProcess.StopSoftwareParameters.StopMode.ALWAYS).configure(SoftwareProcess.StopSoftwareParameters.STOP_MACHINE_MODE, (Object)SoftwareProcess.StopSoftwareParameters.StopMode.NEVER));
            this.invokeEffector((Effector<Void>)Startable.START, ConfigBag.EMPTY);
        }
    }

    private void invokeEffector(Effector<Void> effector, ConfigBag config) {
        TaskAdaptable stop = Entities.submit((Entity)this.getEntity(), (TaskAdaptable)Effectors.invocation((Entity)this.getEntity(), effector, (ConfigBag)config));
        stop.asTask().blockUntilEnded();
    }
}

