/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import org.jclouds.domain.Credentials;
import org.jclouds.googlecloud.GoogleCredentialsFromJson;

public class EnvHelper {
    public static final String JCLOUDS_COMPUTE_PROVIDER = "JCLOUDS_COMPUTE_PROVIDER";
    public static final String JCLOUDS_COMPUTE_API = "JCLOUDS_COMPUTE_API";
    public static final String JCLOUDS_COMPUTE_IDENTITY = "JCLOUDS_COMPUTE_IDENTITY";
    public static final String JCLOUDS_COMPUTE_CREDENTIAL = "JCLOUDS_COMPUTE_CREDENTIAL";
    public static final String JCLOUDS_COMPUTE_ENDPOINT = "JCLOUDS_COMPUTE_ENDPOINT";
    public static final String JCLOUDS_BLOBSTORE_PROVIDER = "JCLOUDS_BLOBSTORE_PROVIDER";
    public static final String JCLOUDS_BLOBSTORE_API = "JCLOUDS_BLOBSTORE_API";
    public static final String JCLOUDS_BLOBSTORE_IDENTITY = "JCLOUDS_BLOBSTORE_IDENTITY";
    public static final String JCLOUDS_BLOBSTORE_CREDENTIAL = "JCLOUDS_BLOBSTORE_CREDENTIAL";
    public static final String JCLOUDS_BLOBSTORE_ENDPOINT = "JCLOUDS_BLOBSTORE_ENDPOINT";
    public static final String JCLOUDS_USER = "JCLOUDS_USER";
    public static final String JCLOUDS_PASSWORD = "JCLOUDS_PASSWORD";

    private EnvHelper() {
    }

    public static String getComputeProvider(String provider) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(provider, "jclouds.provider", JCLOUDS_COMPUTE_PROVIDER);
    }

    public static String getComputeApi(String api) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(api, "jclouds.api", JCLOUDS_COMPUTE_API);
    }

    public static String getComputeIdentity(String identity) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(identity, "jclouds.identity", JCLOUDS_COMPUTE_IDENTITY);
    }

    public static String getComputeCredential(String provider, String credential) {
        return EnvHelper.getCredentialValue(provider, EnvHelper.getValueOrPropertyOrEnvironmentVariable(credential, "jclouds.credential", JCLOUDS_COMPUTE_CREDENTIAL));
    }

    private static String getGoogleCredentialFromJsonFileIfPath(String credentialValue) {
        File credentialsFile = new File(credentialValue);
        if (credentialsFile.exists()) {
            try {
                String fileContents = Files.toString((File)credentialsFile, (Charset)Charsets.UTF_8);
                GoogleCredentialsFromJson credentialSupplier = new GoogleCredentialsFromJson(fileContents);
                return ((Credentials)credentialSupplier.get()).credential;
            }
            catch (IOException e) {
                return null;
            }
        }
        return credentialValue;
    }

    public static String getComputeEndpoint(String endpoint) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(endpoint, "jclouds.endpoint", JCLOUDS_COMPUTE_ENDPOINT);
    }

    public static String getBlobStoreProvider(String provider) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(provider, "jclouds.provider", JCLOUDS_BLOBSTORE_PROVIDER);
    }

    public static String getBlobStoreApi(String api) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(api, "jclouds.api", JCLOUDS_BLOBSTORE_API);
    }

    public static String getBlobStoreIdentity(String identity) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(identity, "jclouds.identity", JCLOUDS_BLOBSTORE_IDENTITY);
    }

    public static String getBlobStoreCredential(String provider, String credential) {
        return EnvHelper.getCredentialValue(provider, EnvHelper.getValueOrPropertyOrEnvironmentVariable(credential, "jclouds.credential", JCLOUDS_BLOBSTORE_CREDENTIAL));
    }

    public static String getBlobStoreEndpoint(String endpoint) {
        return EnvHelper.getValueOrPropertyOrEnvironmentVariable(endpoint, "jclouds.endpoint", JCLOUDS_BLOBSTORE_ENDPOINT);
    }

    public static String getUser(String user) {
        if (user == null) {
            user = System.getenv(JCLOUDS_USER);
        }
        return user;
    }

    public static String getPassword(String password) {
        if (password == null) {
            password = System.getenv(JCLOUDS_PASSWORD);
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(File fileName) throws IOException {
        Properties properties = new Properties();
        FileInputStream is = new FileInputStream(fileName);
        try {
            properties.load(is);
        }
        finally {
            ((InputStream)is).close();
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, (String)entry.getValue());
        }
    }

    private static String getValueOrPropertyOrEnvironmentVariable(String value, String propertyName, String environmentName) {
        if (value == null) {
            value = System.getProperty(propertyName);
        }
        if (value == null) {
            value = System.getenv(environmentName);
        }
        return value;
    }

    private static String getCredentialValue(String provider, String credential) {
        return credential != null && EnvHelper.isGoogleCloud(provider) ? EnvHelper.getGoogleCredentialFromJsonFileIfPath(credential) : credential;
    }

    private static boolean isGoogleCloud(String provider) {
        return provider != null && provider.startsWith("google");
    }
}

