/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa;

import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAKey;
import net.i2p.crypto.eddsa.math.GroupElement;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;

public class EdDSAPrivateKey
implements EdDSAKey,
PrivateKey {
    private static final long serialVersionUID = 23495873459878957L;
    private final byte[] seed;
    private final byte[] h;
    private final byte[] a;
    private final GroupElement A;
    private final byte[] Abyte;
    private final EdDSAParameterSpec edDsaSpec;

    public EdDSAPrivateKey(EdDSAPrivateKeySpec spec) {
        this.seed = spec.getSeed();
        this.h = spec.getH();
        this.a = spec.geta();
        this.A = spec.getA();
        this.Abyte = this.A.toByteArray();
        this.edDsaSpec = spec.getParams();
    }

    public EdDSAPrivateKey(PKCS8EncodedKeySpec spec) throws InvalidKeySpecException {
        this(new EdDSAPrivateKeySpec(EdDSAPrivateKey.decode(spec.getEncoded()), EdDSANamedCurveTable.getByName("ed25519-sha-512")));
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        if (!this.edDsaSpec.equals(EdDSANamedCurveTable.getByName("ed25519-sha-512"))) {
            return null;
        }
        int totlen = 17 + this.seed.length;
        byte[] rv = new byte[totlen];
        int idx = 0;
        rv[idx++] = 48;
        rv[idx++] = (byte)(15 + this.seed.length);
        rv[idx++] = 2;
        rv[idx++] = 1;
        rv[idx++] = 0;
        rv[idx++] = 48;
        rv[idx++] = 8;
        rv[idx++] = 6;
        rv[idx++] = 3;
        rv[idx++] = 43;
        rv[idx++] = 101;
        rv[idx++] = 100;
        rv[idx++] = 10;
        rv[idx++] = 1;
        rv[idx++] = 1;
        rv[idx++] = 4;
        rv[idx++] = (byte)this.seed.length;
        System.arraycopy(this.seed, 0, rv, idx, this.seed.length);
        return rv;
    }

    private static byte[] decode(byte[] d) throws InvalidKeySpecException {
        try {
            int idx = 0;
            if (d[idx++] != 48 || d[idx++] != 47 || d[idx++] != 2 || d[idx++] != 1 || d[idx++] != 0 || d[idx++] != 48 || d[idx++] != 8 || d[idx++] != 6 || d[idx++] != 3 || d[idx++] != 43 || d[idx++] != 101 || d[idx++] != 100 || d[idx++] != 10 || d[idx++] != 1 || d[idx++] != 1 || d[idx++] != 4 || d[idx++] != 32) {
                throw new InvalidKeySpecException("unsupported key spec");
            }
            byte[] rv = new byte[32];
            System.arraycopy(d, idx, rv, 0, 32);
            return rv;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new InvalidKeySpecException(ioobe);
        }
    }

    @Override
    public EdDSAParameterSpec getParams() {
        return this.edDsaSpec;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public byte[] getH() {
        return this.h;
    }

    public byte[] geta() {
        return this.a;
    }

    public GroupElement getA() {
        return this.A;
    }

    public byte[] getAbyte() {
        return this.Abyte;
    }

    public int hashCode() {
        return Arrays.hashCode(this.seed);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdDSAPrivateKey)) {
            return false;
        }
        EdDSAPrivateKey pk = (EdDSAPrivateKey)o;
        return Arrays.equals(this.seed, pk.getSeed()) && this.edDsaSpec.equals(pk.getParams());
    }
}

