/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;

public class ColumnMetaData
implements ResultSetMetaData {
    public int columns_;
    public boolean[] nullable_;
    public short sqldHold_;
    public short sqldReturn_;
    public short sqldScroll_;
    public short sqldSensitive_;
    public short sqldFcode_;
    public short sqldKeytype_;
    public String sqldRdbnam_;
    public String sqldSchema_;
    public int[] sqlPrecision_;
    public int[] sqlScale_;
    public long[] sqlLength_;
    public int[] sqlType_;
    public int[] sqlCcsid_;
    public String[] sqlName_;
    public String[] sqlLabel_;
    public short[] sqlUnnamed_;
    public String[] sqlComment_;
    public String[] sqlUDTname_;
    public String[] sqlUDTclassName_;
    public short[] sqlxKeymem_;
    public short[] sqlxGenerated_;
    public short[] sqlxParmmode_;
    public String[] sqlxCorname_;
    public String[] sqlxName_;
    public String[] sqlxBasename_;
    public int[] sqlxUpdatable_;
    public String[] sqlxSchema_;
    public String[] sqlxRdbnam_;
    public transient int[][] protocolTypesCache_ = null;
    public transient int[] types_;
    public transient int[] clientParamtertype_;
    private transient LogWriter logWriter_;
    transient int resultSetConcurrency_;
    private transient Hashtable<String, Integer> columnNameToIndexCache_;
    private transient boolean statementClosed_ = false;

    void markClosed() {
        this.statementClosed_ = true;
        this.nullDataForGC();
    }

    private void checkForClosedStatement() throws SqlException {
        if (this.statementClosed_) {
            throw new SqlException(this.logWriter_, new ClientMessageId("XCL31.S"), new Object[0]);
        }
    }

    public ColumnMetaData(LogWriter logWriter) {
        this.logWriter_ = logWriter;
    }

    public ColumnMetaData(LogWriter logWriter, int upperBound) {
        this.logWriter_ = logWriter;
        this.initializeCache(upperBound);
    }

    public void initializeCache(int upperBound) {
        this.columns_ = upperBound;
        this.nullable_ = new boolean[upperBound];
        this.types_ = new int[upperBound];
        this.clientParamtertype_ = new int[upperBound];
        this.sqlPrecision_ = new int[upperBound];
        this.sqlScale_ = new int[upperBound];
        this.sqlLength_ = new long[upperBound];
        this.sqlType_ = new int[upperBound];
        this.sqlCcsid_ = new int[upperBound];
        this.sqlName_ = new String[upperBound];
        this.sqlxParmmode_ = new short[upperBound];
        this.sqlUDTname_ = new String[upperBound];
        this.sqlUDTclassName_ = new String[upperBound];
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            this.checkForClosedStatement();
            return this.columns_;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            return this.sqlxGenerated_[column - 1] == 2;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            int type = this.types_[column - 1];
            return type == 1 || type == 12 || type == -1 || type == 2005;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            return true;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            return false;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.nullable_[column - 1]) {
                return 1;
            }
            return 0;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            int type = this.types_[column - 1];
            return type == 5 || type == 4 || type == -5 || type == 6 || type == 7 || type == 8 || type == 2 || type == 3;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            int jdbcType = this.types_[column - 1];
            switch (jdbcType) {
                case 16: {
                    return 5;
                }
                case 4: {
                    return 11;
                }
                case 5: {
                    return 6;
                }
                case -5: {
                    return 20;
                }
                case 7: {
                    return 15;
                }
                case 6: 
                case 8: {
                    return 24;
                }
                case 2: 
                case 3: {
                    int scale = this.getScale(column);
                    int precision = this.getPrecision(column);
                    return scale == 0 ? precision + 1 : (scale == precision ? precision + 3 : precision + 2);
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return (int)this.sqlLength_[column - 1];
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 29;
                }
                case 2000: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    int size = (int)(2L * this.sqlLength_[column - 1]);
                    if (size < 0) {
                        size = Integer.MAX_VALUE;
                    }
                    return size;
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlLabel_ != null && this.sqlLabel_[column - 1] != null) {
                return this.sqlLabel_[column - 1];
            }
            if (this.sqlName_ == null || this.sqlName_[column - 1] == null) {
                this.assignColumnName(column);
            }
            return this.sqlName_[column - 1];
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlName_ == null || this.sqlName_[column - 1] == null) {
                this.assignColumnName(column);
            }
            return this.sqlName_[column - 1];
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlxSchema_ == null || this.sqlxSchema_[column - 1] == null) {
                return "";
            }
            return this.sqlxSchema_[column - 1];
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            int jdbcType = this.types_[column - 1];
            switch (jdbcType) {
                case 16: {
                    return 1;
                }
                case 2: 
                case 3: {
                    return this.sqlPrecision_[column - 1];
                }
                case 5: {
                    return 5;
                }
                case 4: {
                    return 10;
                }
                case -5: {
                    return 19;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    return (int)this.sqlLength_[column - 1];
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 29;
                }
                case 2000: {
                    return 0;
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            return this.sqlScale_[column - 1];
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlxBasename_ == null || this.sqlxBasename_[column - 1] == null) {
                return "";
            }
            return this.sqlxBasename_[column - 1];
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            return "";
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            return this.types_[column - 1];
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            int jdbcType = this.types_[column - 1];
            int sqlType = this.sqlType_[column - 1];
            switch (sqlType) {
                case 2436: 
                case 2437: {
                    return "BOOLEAN";
                }
                case 384: 
                case 385: {
                    return "DATE";
                }
                case 388: 
                case 389: {
                    return "TIME";
                }
                case 392: 
                case 393: {
                    return "TIMESTAMP";
                }
                case 404: 
                case 405: {
                    return "BLOB";
                }
                case 408: 
                case 409: {
                    return "CLOB";
                }
                case 448: 
                case 449: {
                    if (jdbcType == -3) {
                        return "VARCHAR FOR BIT DATA";
                    }
                    return "VARCHAR";
                }
                case 452: 
                case 453: {
                    if (jdbcType == -2) {
                        return "CHAR FOR BIT DATA";
                    }
                    return "CHAR";
                }
                case 456: 
                case 457: {
                    if (jdbcType == -4) {
                        return "LONG VARCHAR FOR BIT DATA";
                    }
                    return "LONG VARCHAR";
                }
                case 460: 
                case 461: {
                    return "SBCS";
                }
                case 480: 
                case 481: {
                    if (jdbcType == 8) {
                        return "DOUBLE";
                    }
                    if (jdbcType == 7) {
                        return "REAL";
                    }
                }
                case 484: 
                case 485: {
                    return "DECIMAL";
                }
                case 492: 
                case 493: {
                    return "BIGINT";
                }
                case 496: 
                case 497: {
                    return "INTEGER";
                }
                case 500: 
                case 501: {
                    return "SMALLINT";
                }
                case 504: 
                case 505: {
                    return "NUMERIC";
                }
                case 2000: 
                case 2001: {
                    return this.sqlUDTname_[column - 1];
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlxUpdatable_ == null) {
                return this.resultSetConcurrency_ == 1007;
            }
            return this.sqlxUpdatable_[column - 1] == 0;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlxUpdatable_ == null) {
                return this.resultSetConcurrency_ == 1008;
            }
            return this.sqlxUpdatable_[column - 1] == 1;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            if (this.sqlxUpdatable_ == null) {
                return false;
            }
            return this.sqlxUpdatable_[column - 1] == 1;
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(column);
            int jdbcType = this.types_[column - 1];
            switch (jdbcType) {
                case 16: {
                    return "java.lang.Boolean";
                }
                case -7: {
                    return "java.lang.Boolean";
                }
                case -6: {
                    return "java.lang.Integer";
                }
                case 5: {
                    return "java.lang.Integer";
                }
                case 4: {
                    return "java.lang.Integer";
                }
                case -5: {
                    return "java.lang.Long";
                }
                case 6: {
                    return "java.lang.Double";
                }
                case 7: {
                    return "java.lang.Float";
                }
                case 8: {
                    return "java.lang.Double";
                }
                case 2: 
                case 3: {
                    return "java.math.BigDecimal";
                }
                case -1: 
                case 1: 
                case 12: {
                    return "java.lang.String";
                }
                case 91: {
                    return "java.sql.Date";
                }
                case 92: {
                    return "java.sql.Time";
                }
                case 93: {
                    return "java.sql.Timestamp";
                }
                case -4: 
                case -3: 
                case -2: {
                    return "byte[]";
                }
                case 2002: {
                    return "java.sql.Struct";
                }
                case 2003: {
                    return "java.sql.Array";
                }
                case 2004: {
                    return "java.sql.Blob";
                }
                case 2005: {
                    return "java.sql.Clob";
                }
                case 2006: {
                    return "java.sql.Ref";
                }
                case 2000: {
                    return this.sqlUDTclassName_[column - 1];
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"), new Object[0]);
        }
        catch (SqlException e) {
            throw e.getSQLException();
        }
    }

    void checkForValidColumnIndex(int column) throws SqlException {
        if (column < 1 || column > this.columns_) {
            throw new SqlException(this.logWriter_, new ClientMessageId("XCL14.S"), column, this.columns_);
        }
    }

    public void setLogWriter(LogWriter logWriter) {
        this.logWriter_ = logWriter;
    }

    private void nullDataForGC() {
        this.columns_ = 0;
        this.nullable_ = null;
        this.types_ = null;
        this.sqldRdbnam_ = null;
        this.sqldSchema_ = null;
        this.sqlPrecision_ = null;
        this.sqlScale_ = null;
        this.sqlLength_ = null;
        this.sqlType_ = null;
        this.sqlCcsid_ = null;
        this.sqlName_ = null;
        this.sqlLabel_ = null;
        this.sqlUnnamed_ = null;
        this.sqlComment_ = null;
        this.sqlUDTname_ = null;
        this.sqlUDTclassName_ = null;
        this.sqlxKeymem_ = null;
        this.sqlxGenerated_ = null;
        this.sqlxParmmode_ = null;
        this.sqlxCorname_ = null;
        this.sqlxName_ = null;
        this.sqlxBasename_ = null;
        this.sqlxUpdatable_ = null;
        this.sqlxSchema_ = null;
        this.sqlxRdbnam_ = null;
        this.clientParamtertype_ = null;
        this.types_ = null;
    }

    boolean hasLobColumns() {
        for (int i = 0; i < this.columns_; ++i) {
            switch (Utils.getNonNullableSqlType(this.sqlType_[i])) {
                case 404: 
                case 408: {
                    return true;
                }
            }
        }
        return false;
    }

    int findColumnX(String columnName) throws SqlException {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        } else {
            Integer index = this.columnNameToIndexCache_.get(columnName);
            if (index != null) {
                return index;
            }
        }
        for (int col = 0; col < this.columns_; ++col) {
            if (this.sqlName_ == null || this.sqlName_[col] == null || !this.sqlName_[col].equalsIgnoreCase(columnName)) continue;
            this.columnNameToIndexCache_.put(columnName, col + 1);
            return col + 1;
        }
        throw new SqlException(this.logWriter_, new ClientMessageId("XIE08.S"), columnName);
    }

    private void assignColumnName(int column) {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        }
        String columnName = Integer.toString(column);
        this.columnNameToIndexCache_.put(columnName, column);
        this.sqlName_[column - 1] = columnName;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this);
        }
        catch (ClassCastException cce) {
            throw new SqlException(null, new ClientMessageId("XJ128.S"), iface).getSQLException();
        }
    }
}

