/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.impl.sql.execute.TablePrivilegeInfo;
import org.apache.derby.shared.common.error.StandardException;

class TablePrivilegesNode
extends QueryTreeNode {
    private boolean[] actionAllowed = new boolean[6];
    private ResultColumnList[] columnLists = new ResultColumnList[6];
    private FormatableBitSet[] columnBitSets = new FormatableBitSet[6];
    private TableDescriptor td;
    private List<Provider> descriptorList;

    TablePrivilegesNode(ContextManager cm) {
        super(cm);
    }

    void addAll() {
        for (int i = 0; i < 6; ++i) {
            this.actionAllowed[i] = true;
            this.columnLists[i] = null;
        }
    }

    void addAction(int action, ResultColumnList privilegeColumnList) {
        this.actionAllowed[action] = true;
        if (privilegeColumnList == null) {
            this.columnLists[action] = null;
        } else if (this.columnLists[action] == null) {
            this.columnLists[action] = privilegeColumnList;
        } else {
            this.columnLists[action].appendResultColumns(privilegeColumnList, false);
        }
    }

    void bind(TableDescriptor td, boolean isGrant) throws StandardException {
        this.td = td;
        for (int action = 0; action < 6; ++action) {
            if (this.columnLists[action] != null) {
                this.columnBitSets[action] = this.columnLists[action].bindResultColumnsByName(td, null);
            }
            if (td.getTableType() != 2 || action == 0 || !this.actionAllowed[action]) continue;
            throw StandardException.newException("42509", td.getQualifiedName());
        }
        if (isGrant && td.getTableType() == 2) {
            this.bindPrivilegesForView(td);
        }
    }

    PrivilegeInfo makePrivilegeInfo() {
        return new TablePrivilegeInfo(this.td, this.actionAllowed, this.columnBitSets, this.descriptorList);
    }

    private void bindPrivilegesForView(TableDescriptor td) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        ViewDescriptor vd = dd.getViewDescriptor(td);
        DependencyManager dm = dd.getDependencyManager();
        ProviderInfo[] pis = dm.getPersistentProviderInfos(vd);
        this.descriptorList = new ArrayList<Provider>();
        int siz = pis.length;
        for (int i = 0; i < siz; ++i) {
            Provider provider = (Provider)pis[i].getDependableFinder().getDependable(dd, pis[i].getObjectId());
            if (!(provider instanceof TableDescriptor) && !(provider instanceof ViewDescriptor) && !(provider instanceof AliasDescriptor)) continue;
            this.descriptorList.add(provider);
        }
    }
}

