/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.velocity.Template;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.DirectiveConstants;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.Node;
import org.slf4j.Logger;

public abstract class Directive
implements DirectiveConstants,
Cloneable {
    private int line = 0;
    private int column = 0;
    private boolean provideScope = false;
    private Template template;
    protected Logger log = null;
    protected RuntimeServices rsvc = null;

    public abstract String getName();

    public abstract int getType();

    public void setLocation(int n, int n2) {
        this.line = n;
        this.column = n2;
    }

    public void setLocation(int n, int n2, Template template) {
        this.setLocation(n, n2);
        this.template = template;
    }

    public Template getTemplate() {
        return this.template;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getTemplateName() {
        return this.template.getName();
    }

    public String getScopeName() {
        return this.getName();
    }

    public boolean isScopeProvided() {
        return this.provideScope;
    }

    public void init(RuntimeServices runtimeServices, InternalContextAdapter internalContextAdapter, Node node) throws TemplateInitException {
        this.rsvc = runtimeServices;
        this.log = this.rsvc.getLog("directive." + this.getName());
        String string = this.getScopeName() + '.' + "provide.scope.control";
        this.provideScope = this.rsvc.getBoolean(string, this.provideScope);
    }

    public void checkArgs(ArrayList<Integer> arrayList, Token token, String string) throws ParseException {
    }

    public abstract boolean render(InternalContextAdapter var1, Writer var2, Node var3) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException;

    protected void preRender(InternalContextAdapter internalContextAdapter) {
        if (this.isScopeProvided()) {
            String string = this.getScopeName();
            Object object = internalContextAdapter.get(string);
            internalContextAdapter.put(string, this.makeScope(object));
        }
    }

    protected Scope makeScope(Object object) {
        return new Scope(this, object);
    }

    protected void postRender(InternalContextAdapter internalContextAdapter) {
        if (this.isScopeProvided()) {
            String string = this.getScopeName();
            Object object = internalContextAdapter.get(string);
            try {
                Scope scope = (Scope)object;
                if (scope.getParent() != null) {
                    internalContextAdapter.put(string, scope.getParent());
                } else if (scope.getReplaced() != null) {
                    internalContextAdapter.put(string, scope.getReplaced());
                } else {
                    internalContextAdapter.remove(string);
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

