/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationHandlers;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.UnitDescriptor;
import org.apache.torque.generator.configuration.source.SourceSaxHandler;
import org.apache.torque.generator.source.SourceProvider;
import org.apache.torque.generator.source.jdbc.JdbcMetadataSourceProvider;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JdbcMetadataSourceSaxHandler
extends SourceSaxHandler {
    private SourceProvider sourceProvider;

    public JdbcMetadataSourceSaxHandler(ConfigurationProvider configurationProvider, UnitDescriptor unitDescriptor, ConfigurationHandlers configurationHandlers) {
        super(configurationProvider, unitDescriptor, configurationHandlers);
    }

    @Override
    public void startElement(String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        if (rawName.equals("source")) {
            String urlOption = attributes.getValue("urlOption");
            String driverOption = attributes.getValue("driverOption");
            String usernameOption = attributes.getValue("usernameOption");
            String passwordOption = attributes.getValue("passwordOption");
            String schemaOption = attributes.getValue("schemaOption");
            try {
                this.sourceProvider = new JdbcMetadataSourceProvider(urlOption, driverOption, usernameOption, passwordOption, schemaOption);
            }
            catch (ConfigurationException e) {
                throw new SAXException("Could not parse Source Tag: " + e.getMessage(), e);
            }
        }
        super.startElement(uri, localName, rawName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String rawName) throws SAXException {
        super.endElement(uri, localName, rawName);
        if (rawName.equals("source")) {
            this.finished();
        }
    }

    @Override
    public SourceProvider getSourceProvider() {
        return this.sourceProvider;
    }
}

