/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceException;
import org.apache.torque.generator.source.SourceImpl;
import org.apache.torque.generator.source.stream.SourceToXml;
import org.apache.torque.generator.source.stream.StreamSourceFormat;

public class FileSource
extends SourceImpl {
    private static Log log = LogFactory.getLog(FileSource.class);
    private final StreamSourceFormat format;
    private final File path;
    private final ControllerState controllerState;
    private byte[] contentMd5Sum;

    public FileSource(StreamSourceFormat format, File path, ControllerState controllerState) {
        if (path == null) {
            throw new NullPointerException("path must not be null");
        }
        if (format == null) {
            throw new NullPointerException("format must not be null");
        }
        if (controllerState == null) {
            throw new NullPointerException("controllerState must not be null");
        }
        this.format = format;
        this.path = path;
        this.controllerState = controllerState;
    }

    public StreamSourceFormat getSourceFormat() {
        return this.format;
    }

    public File getPath() {
        return this.path;
    }

    @Override
    public SourceElement createRootElement() throws SourceException {
        SourceElement result;
        if (log.isDebugEnabled()) {
            log.debug((Object)"start creating root Element");
        }
        try (FileInputStream inputStream = new FileInputStream(this.path);){
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(inputStream, messageDigest);
            log.debug((Object)("Reading file " + this.path.getAbsolutePath() + " of type " + this.format.getKey()));
            result = this.format.parse(digestInputStream, this.controllerState);
            this.contentMd5Sum = messageDigest.digest();
        }
        catch (FileNotFoundException e) {
            throw new SourceException("File not found: " + this.path.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new SourceException("Could not close: " + this.path.getAbsolutePath(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SourceException("MD5 message Digest not implemented", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("finished creating root Element, source is\n" + new SourceToXml().toXml(result, true)));
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.path.getAbsolutePath();
    }

    @Override
    public File getSourceFile() {
        return this.path;
    }

    @Override
    public Date getLastModified() {
        long lastModified = this.path.lastModified();
        if (lastModified == 0L) {
            return null;
        }
        return new Date(lastModified);
    }

    @Override
    public byte[] getContentChecksum() {
        if (this.contentMd5Sum == null) {
            try {
                this.getRootElement();
            }
            catch (SourceException sourceException) {
                // empty catch block
            }
        }
        if (this.contentMd5Sum == null) {
            return null;
        }
        return Arrays.copyOf(this.contentMd5Sum, this.contentMd5Sum.length);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(path=").append(this.path).append(",type=").append(this.format);
        return result.toString();
    }
}

