/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;

public class PackageResources {
    private static final String FILE_URL_PREFIX = "file:";
    private static Log log = LogFactory.getLog(PackageResources.class);
    private final List<JarFile> jarFiles = new ArrayList<JarFile>();
    private final List<File> directories = new ArrayList<File>();
    private final String packagePath;

    public PackageResources(String packageToFind, ClassLoader classLoader) throws ConfigurationException {
        Enumeration<URL> dirUrls;
        if (packageToFind == null) {
            throw new NullPointerException("packagePath must not be null");
        }
        this.packagePath = packageToFind.startsWith("/") ? packageToFind.substring(1) : packageToFind;
        try {
            dirUrls = classLoader.getResources(this.packagePath);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not scan class path", e);
        }
        while (dirUrls.hasMoreElements()) {
            URL dirUrl = dirUrls.nextElement();
            String dirUrlString = dirUrl.toExternalForm();
            if (dirUrlString.startsWith("jar")) {
                String jarFilePath = dirUrl.getFile();
                if (jarFilePath.startsWith(FILE_URL_PREFIX)) {
                    jarFilePath = jarFilePath.substring(FILE_URL_PREFIX.length());
                }
                jarFilePath = jarFilePath.substring(0, jarFilePath.indexOf("!"));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("package " + this.packagePath + " found in jar file" + jarFilePath));
                }
                try {
                    JarFile jarFile = new JarFile(jarFilePath);
                    this.jarFiles.add(jarFile);
                    continue;
                }
                catch (IOException e) {
                    log.error((Object)("Could not open jar File " + jarFilePath));
                    throw new ConfigurationException(e);
                }
            }
            File directory = new File(dirUrl.getFile());
            if (!directory.exists()) {
                throw new ConfigurationException("Could not read directory " + this.packagePath + " in classpath; directory URL is " + String.valueOf(dirUrl) + " file is " + dirUrl.getFile());
            }
            this.directories.add(directory);
        }
    }

    public List<JarFile> getJarFiles() {
        return this.jarFiles;
    }

    public List<File> getDirectories() {
        return this.directories;
    }

    public boolean isEmpty() {
        return this.jarFiles.isEmpty() && this.directories.isEmpty();
    }

    public Collection<String> getAllResourcesEndingWith(String suffix, boolean recurse) {
        ArrayList<String> result = new ArrayList<String>();
        for (JarFile jarFile : this.jarFiles) {
            String dirNameInJar = this.packagePath;
            if (dirNameInJar.startsWith("/")) {
                dirNameInJar = dirNameInJar.substring(1);
            }
            result.addAll(PackageResources.getFilesInJarDirectoryWithSuffix(dirNameInJar, jarFile, suffix, recurse));
        }
        for (File directory : this.directories) {
            result.addAll(PackageResources.getFilesInDirectoryWithSuffix(directory, suffix, "", recurse));
        }
        return result;
    }

    static Collection<String> getFilesInDirectoryWithSuffix(File directoryToScan, String suffix, String prefixToResult, boolean recurse) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Analyzing directory " + String.valueOf(directoryToScan) + " with subdirectory " + prefixToResult + " for files with suffix " + suffix));
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!directoryToScan.isDirectory()) {
            log.debug((Object)("Directory " + directoryToScan.getAbsolutePath() + "is not a directory, no outlet definitions will be read (template outlets may still be available through scanning the templates directory)"));
            return result;
        }
        String[] filenames = directoryToScan.list();
        if (filenames == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(String.valueOf(directoryToScan) + " does not exist, returning the empty list"));
            }
            return result;
        }
        for (String filename : filenames) {
            File file = new File(directoryToScan, filename);
            if (file.isDirectory()) {
                if (!recurse) continue;
                result.addAll(PackageResources.getFilesInDirectoryWithSuffix(file, suffix, prefixToResult + filename + "/", recurse));
                continue;
            }
            String rawName = file.getName();
            if (suffix != null && !rawName.endsWith(suffix)) continue;
            result.add(prefixToResult + filename);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following files " + String.valueOf(result)));
        }
        return result;
    }

    static Collection<String> getFilesInJarDirectoryWithSuffix(String directory, JarFile jarFile, String suffix, boolean searchSubdirectories) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Analyzing jar file " + jarFile.getName() + " seeking directory " + directory + " for files with suffix " + suffix));
        }
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String rawName;
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() || !(rawName = jarEntry.getName()).startsWith(directory + "/")) continue;
            String name = rawName.substring(directory.length() + 1);
            if (suffix != null && !name.endsWith(suffix) || name.indexOf("/") != -1 && !searchSubdirectories) continue;
            result.add(name);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found the following files " + String.valueOf(result)));
        }
        return result;
    }
}

