/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;

abstract class BasePackBitmapIndex
implements PackBitmapIndex {
    private final ObjectIdOwnerMap<StoredBitmap> bitmaps;

    BasePackBitmapIndex(ObjectIdOwnerMap<StoredBitmap> bitmaps) {
        this.bitmaps = bitmaps;
    }

    @Override
    public EWAHCompressedBitmap getBitmap(AnyObjectId objectId) {
        StoredBitmap sb = this.bitmaps.get(objectId);
        return sb != null ? sb.getBitmap() : null;
    }

    ObjectIdOwnerMap<StoredBitmap> getBitmaps() {
        return this.bitmaps;
    }

    @Override
    public int getBaseBitmapCount() {
        int bases = 0;
        for (StoredBitmap sb : this.getBitmaps()) {
            if (!sb.isBase()) continue;
            ++bases;
        }
        return bases;
    }

    @Override
    public long getBaseBitmapSizeInBytes() {
        long baseSize = 0L;
        for (StoredBitmap sb : this.getBitmaps()) {
            if (!sb.isBase()) continue;
            baseSize += sb.getCurrentSizeInBytes();
        }
        return baseSize;
    }

    @Override
    public int getXorBitmapCount() {
        int xored = 0;
        for (StoredBitmap sb : this.getBitmaps()) {
            if (sb.isBase()) continue;
            ++xored;
        }
        return xored;
    }

    @Override
    public long getXorBitmapSizeInBytes() {
        long xorSize = 0L;
        for (StoredBitmap sb : this.getBitmaps()) {
            if (sb.isBase()) continue;
            xorSize += sb.getCurrentSizeInBytes();
        }
        return xorSize;
    }

    static final class StoredBitmap
    extends ObjectIdOwnerMap.Entry {
        private volatile Object bitmapContainer;
        private final int flags;

        StoredBitmap(AnyObjectId objectId, EWAHCompressedBitmap bitmap, StoredBitmap xorBitmap, int flags) {
            super(objectId);
            this.bitmapContainer = xorBitmap == null ? bitmap : new XorCompressedBitmap(bitmap, xorBitmap);
            this.flags = flags;
        }

        EWAHCompressedBitmap getBitmap() {
            EWAHCompressedBitmap bitmap = this.getBitmapWithoutCaching();
            this.bitmapContainer = bitmap;
            return bitmap;
        }

        EWAHCompressedBitmap getBitmapWithoutCaching() {
            Object r = this.bitmapContainer;
            if (r instanceof EWAHCompressedBitmap) {
                return (EWAHCompressedBitmap)r;
            }
            XorCompressedBitmap xb = (XorCompressedBitmap)r;
            EWAHCompressedBitmap out = xb.bitmap;
            while (true) {
                if ((r = xb.xorBitmap.bitmapContainer) instanceof EWAHCompressedBitmap) {
                    out = out.xor((EWAHCompressedBitmap)r);
                    out.trim();
                    return out;
                }
                xb = (XorCompressedBitmap)r;
                out = out.xor(xb.bitmap);
            }
        }

        int getFlags() {
            return this.flags;
        }

        boolean isBase() {
            return this.bitmapContainer instanceof EWAHCompressedBitmap;
        }

        long getCurrentSizeInBytes() {
            Object r = this.bitmapContainer;
            if (r instanceof EWAHCompressedBitmap) {
                return ((EWAHCompressedBitmap)r).sizeInBytes();
            }
            XorCompressedBitmap xor = (XorCompressedBitmap)r;
            return xor.bitmap.sizeInBytes();
        }
    }

    private static final class XorCompressedBitmap {
        final EWAHCompressedBitmap bitmap;
        final StoredBitmap xorBitmap;

        XorCompressedBitmap(EWAHCompressedBitmap b, StoredBitmap xb) {
            this.bitmap = b;
            this.xorBitmap = xb;
        }
    }
}

