/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.hc.annotation.HealthCheckService;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HealthCheckService(name="Thread Usage")
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Config.class, factory=false)
public class ThreadUsageCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUsageCheck.class);
    public static final String HC_NAME = "Thread Usage";
    public static final String HC_LABEL = "Health Check: Thread Usage";
    private long samplePeriodInMs;
    private long cpuPercentageThresholdWarn;

    @Activate
    protected final void activate(Config config) {
        this.samplePeriodInMs = config.samplePeriodInMs();
        this.cpuPercentageThresholdWarn = config.cpuPercentageThresholdWarn();
        LOG.debug("Activated thread usage HC samplePeriodInMs={}ms cpuPercentageThresholdWarn={}%", (Object)this.samplePeriodInMs, (Object)this.cpuPercentageThresholdWarn);
    }

    public Result execute() {
        FormattingResultLog log = new FormattingResultLog();
        log.debug("Checking threads for exceeding {}% CPU time within time period of {}ms", new Object[]{this.cpuPercentageThresholdWarn, this.samplePeriodInMs});
        try {
            ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
            List<ThreadTimeInfo> threadTimeInfos = this.collectThreadTimeInfos(log, threadMxBean);
            Collections.sort(threadTimeInfos);
            float totalCpuTimePercentage = 0.0f;
            for (int i = 0; i < threadTimeInfos.size(); ++i) {
                ThreadTimeInfo threadInfo = threadTimeInfos.get(i);
                float cpuTimePercentage = (float)threadInfo.getCpuTime() / ((float)this.samplePeriodInMs * 1000000.0f) * 100.0f;
                totalCpuTimePercentage += cpuTimePercentage;
                String msg = String.format("%4.1f", Float.valueOf(cpuTimePercentage)) + "% used by thread \"" + threadInfo.name + "\"";
                if (i < 3 || i < 10 && cpuTimePercentage > 15.0f) {
                    log.info(msg, new Object[0]);
                    continue;
                }
                log.debug(msg, new Object[0]);
            }
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            boolean isHighCpuTime = totalCpuTimePercentage > (float)(this.cpuPercentageThresholdWarn * (long)availableProcessors);
            Result.Status status = isHighCpuTime ? Result.Status.WARN : Result.Status.OK;
            double cpuTimePerProcessor = totalCpuTimePercentage / (float)availableProcessors;
            String msg = threadTimeInfos.size() + " threads using " + String.format("%.1f", Float.valueOf(totalCpuTimePercentage)) + "% CPU Time (" + String.format("%.1f", cpuTimePerProcessor) + "% per single core having " + availableProcessors + " cores)";
            if (isHighCpuTime) {
                msg = msg + ">" + this.cpuPercentageThresholdWarn + "% threshold for WARN";
            }
            log.add(new ResultLog.Entry(status, msg));
            this.checkForDeadlock(log, threadMxBean);
        }
        catch (Exception e) {
            LOG.error("Could not analyse thread usage " + e, (Throwable)e);
            log.healthCheckError("Could not analyse thread usage", new Object[]{e});
        }
        return new Result((ResultLog)log);
    }

    List<ThreadTimeInfo> collectThreadTimeInfos(FormattingResultLog log, ThreadMXBean threadMxBean) {
        ThreadTimeInfo threadTimeInfo;
        long[] allThreadIds;
        HashMap<Long, ThreadTimeInfo> threadTimeInfos = new HashMap<Long, ThreadTimeInfo>();
        for (long threadId : allThreadIds = threadMxBean.getAllThreadIds()) {
            long threadCpuTimeStart;
            threadTimeInfo = new ThreadTimeInfo();
            threadTimeInfo.start = threadCpuTimeStart = threadMxBean.getThreadCpuTime(threadId);
            ThreadInfo threadInfo = threadMxBean.getThreadInfo(threadId);
            threadTimeInfo.name = threadInfo != null ? threadInfo.getThreadName() : "Thread id " + threadId + " (name not resolvable)";
            threadTimeInfos.put(threadId, threadTimeInfo);
        }
        try {
            Thread.sleep(this.samplePeriodInMs);
        }
        catch (InterruptedException e) {
            log.warn("Could not sleep configured samplePeriodInMs={} to gather thread load", new Object[]{this.samplePeriodInMs});
        }
        for (long threadId : allThreadIds) {
            long threadCpuTimeStop;
            threadTimeInfo = (ThreadTimeInfo)threadTimeInfos.get(threadId);
            if (threadTimeInfo == null) continue;
            threadTimeInfo.stop = threadCpuTimeStop = threadMxBean.getThreadCpuTime(threadId);
        }
        ArrayList<ThreadTimeInfo> threads = new ArrayList<ThreadTimeInfo>(threadTimeInfos.values());
        return threads;
    }

    void checkForDeadlock(FormattingResultLog log, ThreadMXBean threadMxBean) {
        long[] findDeadlockedThreads = threadMxBean.findDeadlockedThreads();
        if (findDeadlockedThreads != null) {
            for (long threadId : findDeadlockedThreads) {
                log.critical("Thread " + threadMxBean.getThreadInfo(threadId).getThreadName() + " is DEADLOCKED", new Object[0]);
            }
        }
    }

    static class ThreadTimeInfo
    implements Comparable<ThreadTimeInfo> {
        long start;
        long stop;
        String name;

        ThreadTimeInfo() {
        }

        long getCpuTime() {
            long cpuTime = this.stop - this.start;
            if (cpuTime < 0L) {
                cpuTime = 0L;
            }
            return cpuTime;
        }

        @Override
        public int compareTo(ThreadTimeInfo otherThreadTimeInfo) {
            if (otherThreadTimeInfo == null) {
                return -1;
            }
            return (int)(otherThreadTimeInfo.getCpuTime() - this.getCpuTime());
        }
    }

    @ObjectClassDefinition(name="Health Check: Thread Usage", description="Checks for thread usage and deadlocks")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="Name of this health check")
        public String hc_name() default "Thread Usage";

        @AttributeDefinition(name="Tags", description="List of tags for this health check, used to select subsets of health checks for execution e.g. by a composite health check.")
        public String[] hc_tags() default {};

        @AttributeDefinition(name="Sample Period", description="Period to measure usage per thread")
        public long samplePeriodInMs() default 200L;

        @AttributeDefinition(name="CPU Time Threshold for WARN in %", description="Will WARN once this threshold is reached in average for all threads. This value is multiplied by number of available cores as reported by Runtime.getRuntime().availableProcessors()")
        public long cpuPercentageThresholdWarn() default 95L;
    }
}

