/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector.source;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsLimitPushDown;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.predicate.PredicateConverter;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.types.logical.RowType;

public abstract class FlinkTableSource
implements ScanTableSource,
SupportsFilterPushDown,
SupportsProjectionPushDown,
SupportsLimitPushDown {
    private final Table table;
    @Nullable
    protected Predicate predicate;
    @Nullable
    protected int[][] projectFields;
    @Nullable
    protected Long limit;

    public FlinkTableSource(Table table) {
        this(table, null, null, null);
    }

    public FlinkTableSource(Table table, @Nullable Predicate predicate, @Nullable int[][] projectFields, @Nullable Long limit) {
        this.table = table;
        this.predicate = predicate;
        this.projectFields = projectFields;
        this.limit = limit;
    }

    public SupportsFilterPushDown.Result applyFilters(List<ResolvedExpression> filters) {
        ArrayList<Predicate> converted = new ArrayList<Predicate>();
        RowType rowType = this.table.rowType();
        for (ResolvedExpression filter : filters) {
            PredicateConverter.convert(rowType, filter).ifPresent(converted::add);
        }
        this.predicate = converted.isEmpty() ? null : PredicateBuilder.and(converted);
        return SupportsFilterPushDown.Result.of(filters, filters);
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields) {
        this.projectFields = projectedFields;
    }

    public void applyLimit(long limit) {
        this.limit = limit;
    }
}

