/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.geode.CancelException;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.AttributesFactory;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.HasCachePerfStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionArguments;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.internal.MBeanJMXAdapter;
import org.apache.geode.management.internal.MBeanProxyFactory;
import org.apache.geode.management.internal.ManagementCacheListener;
import org.apache.geode.management.internal.ManagementResourceRepo;
import org.apache.geode.management.internal.Manager;
import org.apache.geode.management.internal.MemberMessenger;
import org.apache.geode.management.internal.NotificationCacheListener;
import org.apache.geode.management.internal.NotificationKey;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.logging.log4j.Logger;

public class FederatingManager
extends Manager {
    private static final Logger logger = LogService.getLogger();
    private final SystemManagementService service;
    private final AtomicReference<Exception> latestException = new AtomicReference();
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final MBeanProxyFactory proxyFactory;
    private final MemberMessenger messenger;
    private ExecutorService executorService;

    @VisibleForTesting
    FederatingManager(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock, MBeanProxyFactory proxyFactory, MemberMessenger messenger, ExecutorService executorService) {
        this(repo, system, service, cache, statisticsFactory, statisticsClock, proxyFactory, messenger, () -> executorService);
    }

    FederatingManager(ManagementResourceRepo repo, InternalDistributedSystem system, SystemManagementService service, InternalCache cache, StatisticsFactory statisticsFactory, StatisticsClock statisticsClock, MBeanProxyFactory proxyFactory, MemberMessenger messenger, Supplier<ExecutorService> executorServiceSupplier) {
        super(repo, system, cache, statisticsFactory, statisticsClock);
        this.service = service;
        this.proxyFactory = proxyFactory;
        this.messenger = messenger;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    @Override
    public synchronized void startManager() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting the Federating Manager.... ");
            }
            this.executorService = this.executorServiceSupplier.get();
            this.running = true;
            this.startManagingActivity();
            this.messenger.broadcastManagerInfo();
        }
        catch (Exception e) {
            this.running = false;
            throw new ManagementException(e);
        }
    }

    @Override
    public synchronized void stopManager() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping the Federating Manager.... ");
        }
        this.stopManagingActivity();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public MemberMessenger getMessenger() {
        return this.messenger;
    }

    void removeMember(DistributedMember member, boolean crashed) {
        this.executeTask(new RemoveMemberTask(member, crashed));
    }

    void suspectMember(DistributedMember member, InternalDistributedMember whoSuspected, String reason) {
        this.service.memberSuspect((InternalDistributedMember)member, whoSuspected, reason);
    }

    long getLastUpdateTime(ObjectName objectName) {
        return this.proxyFactory.getLastUpdateTime(objectName);
    }

    <T> T findProxy(ObjectName objectName, Class<T> interfaceClass) {
        return this.proxyFactory.findProxy(objectName, interfaceClass);
    }

    Set<ObjectName> findAllProxies(DistributedMember member) {
        return this.proxyFactory.findAllProxies(member);
    }

    private void stopManagingActivity() {
        try {
            this.executorService.shutdownNow();
            for (DistributedMember distributedMember : this.repo.getMonitoringRegionMap().keySet()) {
                this.removeMemberArtifacts(distributedMember, false);
            }
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
    }

    private synchronized void executeTask(Runnable task) {
        try {
            this.executorService.execute(task);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startManagingActivity() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        ArrayList<GIITask> giiTaskList = new ArrayList<GIITask>();
        for (InternalDistributedMember member : this.system.getDistributionManager().getOtherDistributionManagerIds()) {
            giiTaskList.add(new GIITask(member));
        }
        try {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation started  : ");
            }
            List futureTaskList = this.executorService.invokeAll(giiTaskList);
            for (Future futureTask : futureTaskList) {
                try {
                    String memberId;
                    DistributedMember returnedMember = (DistributedMember)futureTask.get();
                    String string = memberId = returnedMember != null ? returnedMember.getId() : null;
                    if (futureTask.isDone() && isDebugEnabled) {
                        logger.debug("Monitoring Resource Created for : {}", (Object)memberId);
                    }
                    if (!futureTask.isCancelled() || !isDebugEnabled) continue;
                    logger.debug("Monitoring resource Creation Failed for : {}", (Object)memberId);
                }
                catch (ExecutionException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("ExecutionException during Management GII", (Throwable)e);
                }
                catch (CancellationException e) {
                    if (!isDebugEnabled) continue;
                    logger.debug("InterruptedException while creating Monitoring resource with error", (Throwable)new ManagementException(e));
                }
            }
        }
        catch (InterruptedException e) {
            if (isDebugEnabled) {
                logger.debug("InterruptedException while creating Monitoring resource with error", (Throwable)new ManagementException(e));
            }
        }
        finally {
            if (isDebugEnabled) {
                logger.debug("Management Resource creation completed");
            }
        }
    }

    @VisibleForTesting
    void addMember(InternalDistributedMember member) {
        GIITask giiTask = new GIITask(member);
        this.executeTask(() -> {
            try {
                giiTask.call();
            }
            catch (RuntimeException e) {
                logger.warn("Error federating new member {}", (Object)member.getId(), (Object)e);
                this.latestException.set(e);
            }
        });
    }

    @VisibleForTesting
    void removeMemberArtifacts(DistributedMember member, boolean crashed) {
        Region<String, Object> monitoringRegion = this.repo.getEntryFromMonitoringRegionMap(member);
        Region<NotificationKey, Notification> notificationRegion = this.repo.getEntryFromNotifRegionMap(member);
        if (monitoringRegion == null && notificationRegion == null) {
            return;
        }
        this.repo.romoveEntryFromMonitoringRegionMap(member);
        this.repo.removeEntryFromNotifRegionMap(member);
        if (!this.cache.isClosed()) {
            try {
                if (monitoringRegion != null) {
                    this.proxyFactory.removeAllProxies(member, monitoringRegion);
                    monitoringRegion.localDestroyRegion();
                }
            }
            catch (CancelException | RegionDestroyedException cacheRuntimeException) {
                // empty catch block
            }
            try {
                if (notificationRegion != null) {
                    notificationRegion.localDestroyRegion();
                }
            }
            catch (CancelException | RegionDestroyedException cacheRuntimeException) {
                // empty catch block
            }
        }
        if (!this.system.getDistributedMember().equals(member)) {
            try {
                this.service.memberDeparted((InternalDistributedMember)member, crashed);
            }
            catch (CancelException | RegionDestroyedException cacheRuntimeException) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    public MBeanProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @VisibleForTesting
    synchronized Exception getAndResetLatestException() {
        return this.latestException.getAndSet(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void addMemberArtifacts(InternalDistributedMember member) {
        InternalDistributedMember internalDistributedMember = member;
        synchronized (internalDistributedMember) {
            block24: {
                String appender = MBeanJMXAdapter.getUniqueIDForMember(member);
                String monitoringRegionName = "_monitoringRegion_" + appender;
                String notificationRegionName = "_notificationRegion_" + appender;
                if (this.cache.getInternalRegion(monitoringRegionName) != null && this.cache.getInternalRegion(notificationRegionName) != null) {
                    return;
                }
                try {
                    Region<NotificationKey, Notification> proxyNotificationRegion;
                    Region<String, Object> proxyMonitoringRegion;
                    if (Thread.currentThread().isInterrupted()) break block24;
                    InternalRegionArguments internalRegionArguments = new InternalRegionArguments();
                    internalRegionArguments.setIsUsedForMetaRegion(true);
                    HasCachePerfStats monitoringRegionStats = new HasCachePerfStats(){

                        @Override
                        public CachePerfStats getCachePerfStats() {
                            return new CachePerfStats(FederatingManager.this.cache.getDistributedSystem(), "RegionStats-managementRegionStats", FederatingManager.this.statisticsClock);
                        }

                        @Override
                        public boolean hasOwnStats() {
                            return true;
                        }
                    };
                    internalRegionArguments.setCachePerfStatsHolder(monitoringRegionStats);
                    AttributesFactory<String, Object> monitorAttributesFactory = new AttributesFactory<String, Object>();
                    monitorAttributesFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    monitorAttributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                    monitorAttributesFactory.setConcurrencyChecksEnabled(false);
                    ManagementCacheListener managementCacheListener = new ManagementCacheListener(this.proxyFactory);
                    monitorAttributesFactory.addCacheListener(managementCacheListener);
                    RegionAttributes monitoringRegionAttrs = monitorAttributesFactory.create();
                    AttributesFactory<NotificationKey, Notification> notificationAttributesFactory = new AttributesFactory<NotificationKey, Notification>();
                    notificationAttributesFactory.setScope(Scope.DISTRIBUTED_NO_ACK);
                    notificationAttributesFactory.setDataPolicy(DataPolicy.REPLICATE);
                    notificationAttributesFactory.setConcurrencyChecksEnabled(false);
                    notificationAttributesFactory.setEvictionAttributes(EvictionAttributes.createLRUEntryAttributes(10, EvictionAction.LOCAL_DESTROY));
                    NotificationCacheListener notifListener = new NotificationCacheListener(this.proxyFactory);
                    notificationAttributesFactory.addCacheListener(notifListener);
                    RegionAttributes notifRegionAttrs = notificationAttributesFactory.create();
                    try {
                        if (!this.running) {
                            return;
                        }
                        proxyMonitoringRegion = this.cache.createInternalRegion(monitoringRegionName, monitoringRegionAttrs, internalRegionArguments);
                    }
                    catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error During Internal Region creation", (Throwable)e);
                        }
                        throw new ManagementException(e);
                    }
                    boolean proxyNotificationRegionCreated = false;
                    try {
                        if (!this.running) {
                            return;
                        }
                        proxyNotificationRegion = this.cache.createInternalRegion(notificationRegionName, notifRegionAttrs, internalRegionArguments);
                        proxyNotificationRegionCreated = true;
                    }
                    catch (IOException | ClassNotFoundException | RegionExistsException | TimeoutException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error During Internal Region creation", (Throwable)e);
                        }
                        throw new ManagementException(e);
                    }
                    finally {
                        if (!proxyNotificationRegionCreated) {
                            proxyMonitoringRegion.localDestroyRegion();
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Management Region created with Name : {}", (Object)proxyMonitoringRegion.getName());
                        logger.debug("Notification Region created with Name : {}", (Object)proxyNotificationRegion.getName());
                    }
                    this.repo.putEntryInMonitoringRegionMap(member, proxyMonitoringRegion);
                    this.repo.putEntryInNotifRegionMap(member, proxyNotificationRegion);
                    try {
                        if (!this.running) {
                            return;
                        }
                        this.proxyFactory.createAllProxies(member, proxyMonitoringRegion);
                        managementCacheListener.markReady();
                        notifListener.markReady();
                    }
                    catch (Exception e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Error During GII Proxy creation", (Throwable)e);
                        }
                        throw new ManagementException(e);
                    }
                }
                catch (Exception e) {
                    throw new ManagementException(e);
                }
            }
            this.service.memberJoined(member);
            this.messenger.sendManagerInfo(member);
        }
    }

    private class RemoveMemberTask
    implements Runnable {
        private final DistributedMember member;
        private final boolean crashed;

        private RemoveMemberTask(DistributedMember member, boolean crashed) {
            this.member = member;
            this.crashed = crashed;
        }

        @Override
        public void run() {
            FederatingManager.this.removeMemberArtifacts(this.member, this.crashed);
        }
    }

    private class GIITask
    implements Callable<InternalDistributedMember> {
        private final InternalDistributedMember member;

        private GIITask(InternalDistributedMember member) {
            this.member = member;
        }

        @Override
        public InternalDistributedMember call() {
            FederatingManager.this.addMemberArtifacts(this.member);
            return this.member;
        }
    }
}

