/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_BigtableWriteOptions
extends BigtableWriteOptions {
    private final @Nullable ValueProvider<String> tableId;
    private final @Nullable Duration attemptTimeout;
    private final @Nullable Duration operationTimeout;
    private final @Nullable Long maxElementsPerBatch;
    private final @Nullable Long maxBytesPerBatch;
    private final @Nullable Long maxOutstandingElements;
    private final @Nullable Long maxOutstandingBytes;
    private final @Nullable Integer throttlingTargetMs;
    private final @Nullable Integer throttlingReportTargetMs;
    private final @Nullable Boolean flowControl;
    private final @Nullable Duration closeWaitTimeout;

    private AutoValue_BigtableWriteOptions(@Nullable ValueProvider<String> tableId, @Nullable Duration attemptTimeout, @Nullable Duration operationTimeout, @Nullable Long maxElementsPerBatch, @Nullable Long maxBytesPerBatch, @Nullable Long maxOutstandingElements, @Nullable Long maxOutstandingBytes, @Nullable Integer throttlingTargetMs, @Nullable Integer throttlingReportTargetMs, @Nullable Boolean flowControl, @Nullable Duration closeWaitTimeout) {
        this.tableId = tableId;
        this.attemptTimeout = attemptTimeout;
        this.operationTimeout = operationTimeout;
        this.maxElementsPerBatch = maxElementsPerBatch;
        this.maxBytesPerBatch = maxBytesPerBatch;
        this.maxOutstandingElements = maxOutstandingElements;
        this.maxOutstandingBytes = maxOutstandingBytes;
        this.throttlingTargetMs = throttlingTargetMs;
        this.throttlingReportTargetMs = throttlingReportTargetMs;
        this.flowControl = flowControl;
        this.closeWaitTimeout = closeWaitTimeout;
    }

    @Override
    @Nullable ValueProvider<String> getTableId() {
        return this.tableId;
    }

    @Override
    @Nullable Duration getAttemptTimeout() {
        return this.attemptTimeout;
    }

    @Override
    @Nullable Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    @Nullable Long getMaxElementsPerBatch() {
        return this.maxElementsPerBatch;
    }

    @Override
    @Nullable Long getMaxBytesPerBatch() {
        return this.maxBytesPerBatch;
    }

    @Override
    @Nullable Long getMaxOutstandingElements() {
        return this.maxOutstandingElements;
    }

    @Override
    @Nullable Long getMaxOutstandingBytes() {
        return this.maxOutstandingBytes;
    }

    @Override
    @Nullable Integer getThrottlingTargetMs() {
        return this.throttlingTargetMs;
    }

    @Override
    @Nullable Integer getThrottlingReportTargetMs() {
        return this.throttlingReportTargetMs;
    }

    @Override
    @Nullable Boolean getFlowControl() {
        return this.flowControl;
    }

    @Override
    @Nullable Duration getCloseWaitTimeout() {
        return this.closeWaitTimeout;
    }

    public String toString() {
        return "BigtableWriteOptions{tableId=" + this.tableId + ", attemptTimeout=" + this.attemptTimeout + ", operationTimeout=" + this.operationTimeout + ", maxElementsPerBatch=" + this.maxElementsPerBatch + ", maxBytesPerBatch=" + this.maxBytesPerBatch + ", maxOutstandingElements=" + this.maxOutstandingElements + ", maxOutstandingBytes=" + this.maxOutstandingBytes + ", throttlingTargetMs=" + this.throttlingTargetMs + ", throttlingReportTargetMs=" + this.throttlingReportTargetMs + ", flowControl=" + this.flowControl + ", closeWaitTimeout=" + this.closeWaitTimeout + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableWriteOptions) {
            BigtableWriteOptions that = (BigtableWriteOptions)o;
            return (this.tableId == null ? that.getTableId() == null : this.tableId.equals(that.getTableId())) && (this.attemptTimeout == null ? that.getAttemptTimeout() == null : this.attemptTimeout.equals((Object)that.getAttemptTimeout())) && (this.operationTimeout == null ? that.getOperationTimeout() == null : this.operationTimeout.equals((Object)that.getOperationTimeout())) && (this.maxElementsPerBatch == null ? that.getMaxElementsPerBatch() == null : this.maxElementsPerBatch.equals(that.getMaxElementsPerBatch())) && (this.maxBytesPerBatch == null ? that.getMaxBytesPerBatch() == null : this.maxBytesPerBatch.equals(that.getMaxBytesPerBatch())) && (this.maxOutstandingElements == null ? that.getMaxOutstandingElements() == null : this.maxOutstandingElements.equals(that.getMaxOutstandingElements())) && (this.maxOutstandingBytes == null ? that.getMaxOutstandingBytes() == null : this.maxOutstandingBytes.equals(that.getMaxOutstandingBytes())) && (this.throttlingTargetMs == null ? that.getThrottlingTargetMs() == null : this.throttlingTargetMs.equals(that.getThrottlingTargetMs())) && (this.throttlingReportTargetMs == null ? that.getThrottlingReportTargetMs() == null : this.throttlingReportTargetMs.equals(that.getThrottlingReportTargetMs())) && (this.flowControl == null ? that.getFlowControl() == null : this.flowControl.equals(that.getFlowControl())) && (this.closeWaitTimeout == null ? that.getCloseWaitTimeout() == null : this.closeWaitTimeout.equals((Object)that.getCloseWaitTimeout()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.tableId == null ? 0 : this.tableId.hashCode();
        h$ *= 1000003;
        h$ ^= this.attemptTimeout == null ? 0 : this.attemptTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.operationTimeout == null ? 0 : this.operationTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxElementsPerBatch == null ? 0 : this.maxElementsPerBatch.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxBytesPerBatch == null ? 0 : this.maxBytesPerBatch.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxOutstandingElements == null ? 0 : this.maxOutstandingElements.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxOutstandingBytes == null ? 0 : this.maxOutstandingBytes.hashCode();
        h$ *= 1000003;
        h$ ^= this.throttlingTargetMs == null ? 0 : this.throttlingTargetMs.hashCode();
        h$ *= 1000003;
        h$ ^= this.throttlingReportTargetMs == null ? 0 : this.throttlingReportTargetMs.hashCode();
        h$ *= 1000003;
        h$ ^= this.flowControl == null ? 0 : this.flowControl.hashCode();
        h$ *= 1000003;
        return h$ ^= this.closeWaitTimeout == null ? 0 : this.closeWaitTimeout.hashCode();
    }

    @Override
    BigtableWriteOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BigtableWriteOptions.Builder {
        private @Nullable ValueProvider<String> tableId;
        private @Nullable Duration attemptTimeout;
        private @Nullable Duration operationTimeout;
        private @Nullable Long maxElementsPerBatch;
        private @Nullable Long maxBytesPerBatch;
        private @Nullable Long maxOutstandingElements;
        private @Nullable Long maxOutstandingBytes;
        private @Nullable Integer throttlingTargetMs;
        private @Nullable Integer throttlingReportTargetMs;
        private @Nullable Boolean flowControl;
        private @Nullable Duration closeWaitTimeout;

        Builder() {
        }

        private Builder(BigtableWriteOptions source) {
            this.tableId = source.getTableId();
            this.attemptTimeout = source.getAttemptTimeout();
            this.operationTimeout = source.getOperationTimeout();
            this.maxElementsPerBatch = source.getMaxElementsPerBatch();
            this.maxBytesPerBatch = source.getMaxBytesPerBatch();
            this.maxOutstandingElements = source.getMaxOutstandingElements();
            this.maxOutstandingBytes = source.getMaxOutstandingBytes();
            this.throttlingTargetMs = source.getThrottlingTargetMs();
            this.throttlingReportTargetMs = source.getThrottlingReportTargetMs();
            this.flowControl = source.getFlowControl();
            this.closeWaitTimeout = source.getCloseWaitTimeout();
        }

        @Override
        BigtableWriteOptions.Builder setTableId(ValueProvider<String> tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setAttemptTimeout(Duration attemptTimeout) {
            this.attemptTimeout = attemptTimeout;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setOperationTimeout(Duration operationTimeout) {
            this.operationTimeout = operationTimeout;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setMaxElementsPerBatch(long maxElementsPerBatch) {
            this.maxElementsPerBatch = maxElementsPerBatch;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setMaxBytesPerBatch(long maxBytesPerBatch) {
            this.maxBytesPerBatch = maxBytesPerBatch;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setMaxOutstandingElements(long maxOutstandingElements) {
            this.maxOutstandingElements = maxOutstandingElements;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setMaxOutstandingBytes(long maxOutstandingBytes) {
            this.maxOutstandingBytes = maxOutstandingBytes;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setThrottlingTargetMs(int throttlingTargetMs) {
            this.throttlingTargetMs = throttlingTargetMs;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setThrottlingReportTargetMs(int throttlingReportTargetMs) {
            this.throttlingReportTargetMs = throttlingReportTargetMs;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setFlowControl(boolean flowControl) {
            this.flowControl = flowControl;
            return this;
        }

        @Override
        BigtableWriteOptions.Builder setCloseWaitTimeout(Duration closeWaitTimeout) {
            this.closeWaitTimeout = closeWaitTimeout;
            return this;
        }

        @Override
        BigtableWriteOptions build() {
            return new AutoValue_BigtableWriteOptions(this.tableId, this.attemptTimeout, this.operationTimeout, this.maxElementsPerBatch, this.maxBytesPerBatch, this.maxOutstandingElements, this.maxOutstandingBytes, this.throttlingTargetMs, this.throttlingReportTargetMs, this.flowControl, this.closeWaitTimeout);
        }
    }
}

