/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.construction.PTransformMatchers;
import org.apache.beam.sdk.util.construction.PTransformReplacements;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.ParDoTranslation;
import org.apache.beam.sdk.util.construction.ReplacementOutputs;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class SplittableParDo<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor WatermarkEstimatorStateT>
extends PTransform<PCollection<InputT>, PCollectionTuple> {
    private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
    private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;
    private final @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTagsToCoders;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_PROCESS_URN = "beam:runners_core:transforms:splittable_process:v1";
    public static final @UnknownKeyFor @NonNull @Initialized String SPLITTABLE_GBKIKWI_URN = "beam:runners_core:transforms:splittable_gbkikwi:v1";
    public static final @UnknownKeyFor @NonNull @Initialized PTransformOverride PRIMITIVE_BOUNDED_READ_OVERRIDE = PTransformOverride.of(PTransformMatchers.classEqualTo(Read.Bounded.class), new BoundedReadOverrideFactory());
    public static final @UnknownKeyFor @NonNull @Initialized PTransformOverride PRIMITIVE_UNBOUNDED_READ_OVERRIDE = PTransformOverride.of(PTransformMatchers.classEqualTo(Read.Unbounded.class), new UnboundedReadOverrideFactory());

    private SplittableParDo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTagsToCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
        Preconditions.checkArgument((boolean)DoFnSignatures.getSignature(doFn.getClass()).processElement().isSplittable(), (Object)"fn must be a splittable DoFn");
        this.doFn = doFn;
        this.sideInputs = sideInputs;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.outputTagsToCoders = outputTagsToCoders;
        this.sideInputMapping = sideInputMapping;
    }

    public static <InputT, OutputT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SplittableParDo<InputT, OutputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> forAppliedParDo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> parDo) {
        Preconditions.checkArgument((parDo != null ? 1 : 0) != 0, (Object)"parDo must not be null");
        try {
            HashMap outputTagsToCoders = Maps.newHashMap();
            for (Map.Entry<TupleTag<?>, PCollection<?>> entry : parDo.getOutputs().entrySet()) {
                outputTagsToCoders.put(entry.getKey(), entry.getValue().getCoder());
            }
            return new SplittableParDo(ParDoTranslation.getDoFn(parDo), ParDoTranslation.getSideInputs(parDo), ParDoTranslation.getMainOutputTag(parDo), ParDoTranslation.getAdditionalOutputTags(parDo), outputTagsToCoders, ParDoTranslation.getSideInputMapping(parDo));
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> input) {
        Coder restrictionCoder = DoFnInvokers.invokerFor(this.doFn).invokeGetRestrictionCoder(input.getPipeline().getCoderRegistry());
        Coder watermarkEstimatorStateCoder = DoFnInvokers.invokerFor(this.doFn).invokeGetWatermarkEstimatorStateCoder(input.getPipeline().getCoderRegistry());
        KvCoder splitCoder = KvCoder.of(input.getCoder(), restrictionCoder);
        PCollection keyedRestrictions = (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Pair with initial restriction", ParDo.of(new PairWithRestrictionFn(this.doFn, this.sideInputMapping)).withSideInputs(this.sideInputs))).setCoder(splitCoder).apply("Split restriction", ParDo.of(new SplitRestrictionFn(this.doFn, this.sideInputMapping)).withSideInputs(this.sideInputs))).setCoder(splitCoder).apply("Explode windows", ParDo.of(new ExplodeWindowsFn()))).apply("Assign unique key", WithKeys.of(new RandomUniqueKeyFn()));
        return (PCollectionTuple)keyedRestrictions.apply("ProcessKeyedElements", new ProcessKeyedElements(this.doFn, input.getCoder(), restrictionCoder, watermarkEstimatorStateCoder, input.getWindowingStrategy(), this.sideInputs, this.mainOutputTag, this.additionalOutputTags, this.outputTagsToCoders, this.sideInputMapping));
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
        return PCollectionViews.toAdditionalInputs(this.sideInputs);
    }

    public static void convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        if (!ExperimentalOptions.hasExperiment(pipeline.getOptions(), "use_sdf_read") && !ExperimentalOptions.hasExperiment(pipeline.getOptions(), "use_unbounded_sdf_wrapper") || ExperimentalOptions.hasExperiment(pipeline.getOptions(), "beam_fn_api_use_deprecated_read") || ExperimentalOptions.hasExperiment(pipeline.getOptions(), "use_deprecated_read")) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReads(pipeline);
        }
    }

    public static void convertReadBasedSplittableDoFnsToPrimitiveReads(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        pipeline.replaceAll((List<PTransformOverride>)ImmutableList.of((Object)PRIMITIVE_BOUNDED_READ_OVERRIDE, (Object)PRIMITIVE_UNBOUNDED_READ_OVERRIDE));
    }

    public static class PrimitiveUnboundedRead<@UnknownKeyFor T>
    extends PrimitiveRead<T> {
        public PrimitiveUnboundedRead(@UnknownKeyFor @NonNull @Initialized Read.Unbounded<T> originalTransform) {
            super(originalTransform, originalTransform.getSource());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED, this.getSource().getOutputCoder());
        }

        public @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, @UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark> getSource() {
            return (UnboundedSource)this.source;
        }
    }

    public static class PrimitiveBoundedRead<@UnknownKeyFor T>
    extends PrimitiveRead<T> {
        public PrimitiveBoundedRead(@UnknownKeyFor @NonNull @Initialized Read.Bounded<T> originalTransform) {
            super(originalTransform, originalTransform.getSource());
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED, this.getSource().getOutputCoder());
        }

        public @UnknownKeyFor @NonNull @Initialized BoundedSource<T> getSource() {
            return (BoundedSource)this.source;
        }
    }

    private static abstract class PrimitiveRead<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> originalTransform;
        protected final @UnknownKeyFor @NonNull @Initialized Object source;

        public PrimitiveRead(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> originalTransform, @UnknownKeyFor @NonNull @Initialized Object source) {
            this.originalTransform = originalTransform;
            this.source = source;
        }

        @Override
        public void validate(@Nullable @UnknownKeyFor @Initialized PipelineOptions options) {
            this.originalTransform.validate(options);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
            return this.originalTransform.getAdditionalInputs();
        }

        @Override
        public <CoderT> @UnknownKeyFor @NonNull @Initialized Coder<CoderT> getDefaultOutputCoder(@UnknownKeyFor @NonNull @Initialized PBegin input, @UnknownKeyFor @NonNull @Initialized PCollection<CoderT> output) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            return this.originalTransform.getDefaultOutputCoder(input, output);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.originalTransform.getName();
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.originalTransform.populateDisplayData(builder);
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }
    }

    private static class UnboundedReadOverrideFactory<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Unbounded<T>> {
        private UnboundedReadOverrideFactory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized Read.Unbounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(transform.getPipeline().begin(), new PrimitiveUnboundedRead<T>(transform.getTransform()));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class BoundedReadOverrideFactory<@UnknownKeyFor T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Bounded<T>> {
        private BoundedReadOverrideFactory() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>, @UnknownKeyFor @NonNull @Initialized Read.Bounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(transform.getPipeline().begin(), new PrimitiveBoundedRead<T>(transform.getTransform()));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class SplitRestrictionFn<@UnknownKeyFor InputT, @UnknownKeyFor RestrictionT>
    extends DoFn<KV<InputT, RestrictionT>, KV<InputT, RestrictionT>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DoFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> splittableFn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
        private transient /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized DoFnInvoker<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> invoker;

        SplitRestrictionFn(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DoFn<InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> splittableFn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
            this.splittableFn = splittableFn;
            this.sideInputMapping = sideInputMapping;
        }

        @DoFn.Setup
        public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.invoker = DoFnInvokers.tryInvokeSetupFor(this.splittableFn, options);
        }

        @DoFn.ProcessElement
        public void processElement(final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, final @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
            this.invoker.invokeSplitRestriction(new DoFnInvoker.BaseArgumentProvider<InputT, RestrictionT>(){

                @Override
                public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, RestrictionT> doFn) {
                    return ((KV)c.element()).getKey();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object restriction() {
                    return ((KV)c.element()).getValue();
                }

                @Override
                public /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> restrictionTracker() {
                    return invoker.invokeNewTracker(this);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                    PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                    if (view == null) {
                        throw new IllegalArgumentException("calling getSideInput() with unknown view");
                    }
                    return c.sideInput(view);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, RestrictionT> doFn) {
                    return c.timestamp();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, RestrictionT> doFn) {
                    return c.pane();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
                    return w;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<RestrictionT> outputReceiver(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, RestrictionT> doFn) {
                    return new DoFn.OutputReceiver<RestrictionT>(){

                        @Override
                        public void output(RestrictionT part) {
                            c.output(KV.of(((KV)c.element()).getKey(), part));
                        }

                        @Override
                        public void outputWithTimestamp(RestrictionT part, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                    return SplitRestrictionFn.class.getSimpleName() + ".invokeSplitRestriction";
                }
            });
        }

        @DoFn.Teardown
        public void tearDown() {
            this.invoker.invokeTeardown();
            this.invoker = null;
        }
    }

    private static class PairWithRestrictionFn<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT>
    extends DoFn<InputT, KV<InputT, RestrictionT>> {
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;
        private transient @Nullable @UnknownKeyFor @Initialized DoFnInvoker<InputT, OutputT> invoker;

        PairWithRestrictionFn(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
            this.fn = fn;
            this.sideInputMapping = sideInputMapping;
        }

        @DoFn.Setup
        public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            this.invoker = DoFnInvokers.tryInvokeSetupFor(this.fn, options);
        }

        @DoFn.ProcessElement
        public void processElement(final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, final @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
            c.output(KV.of(c.element(), this.invoker.invokeGetInitialRestriction(new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                @Override
                public InputT element(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return c.element();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Instant timestamp(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return c.timestamp();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Object sideInput(@UnknownKeyFor @NonNull @Initialized String tagId) {
                    PCollectionView view = (PCollectionView)sideInputMapping.get(tagId);
                    if (view == null) {
                        throw new IllegalArgumentException("calling getSideInput() with unknown view");
                    }
                    return c.sideInput(view);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> doFn) {
                    return c.pane();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized BoundedWindow window() {
                    return w;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String getErrorContext() {
                    return PairWithRestrictionFn.class.getSimpleName() + ".invokeGetInitialRestriction";
                }
            })));
        }

        @DoFn.Teardown
        public void tearDown() {
            this.invoker.invokeTeardown();
            this.invoker = null;
        }
    }

    private static class RandomUniqueKeyFn<@UnknownKeyFor T>
    implements SerializableFunction<T, byte[]> {
        private RandomUniqueKeyFn() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(T input) {
            byte[] key = new byte[128];
            ThreadLocalRandom.current().nextBytes(key);
            return key;
        }
    }

    public static class ProcessKeyedElementsTranslator
    implements PTransformTranslation.TransformPayloadTranslator<ProcessKeyedElements<?, ?, ?, ?>> {
        public static  @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator create() {
            return new ProcessKeyedElementsTranslator();
        }

        private ProcessKeyedElementsTranslator() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return "beam:transform:sdf_process_keyed_elements:v1";
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized ProcessKeyedElements<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> transform, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            final ProcessKeyedElements<?, ?, ?, ?> pke = transform.getTransform();
            final DoFn<?, ?> fn = pke.getFn();
            final DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
            final String restrictionCoderId = components.registerCoder(pke.getRestrictionCoder());
            RunnerApi.ParDoPayload payload = ParDoTranslation.payloadForParDoLike(new ParDoTranslation.ParDoLike(){

                @Override
                public // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translateDoFn(@UnknownKeyFor @NonNull @Initialized SdkComponents newComponents) {
                    return ParDoTranslation.translateDoFn(fn, pke.getMainOutputTag(), pke.getSideInputMapping(), DoFnSchemaInformation.create(), newComponents);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RunnerApi.SideInput> translateSideInputs(@UnknownKeyFor @NonNull @Initialized SdkComponents components) {
                    return ParDoTranslation.translateSideInputs(pke.getSideInputs(), components);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
                 @UnknownKeyFor @NonNull @Initialized RunnerApi.StateSpec> translateStateSpecs(@UnknownKeyFor @NonNull @Initialized SdkComponents components) {
                    return ImmutableMap.of();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized ParDoTranslation.ParDoLikeTimerFamilySpecs translateTimerFamilySpecs(@UnknownKeyFor @NonNull @Initialized SdkComponents newComponents) {
                    return ParDoTranslation.ParDoLikeTimerFamilySpecs.create((Map<String, RunnerApi.TimerFamilySpec>)ImmutableMap.of(), null);
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean isStateful() {
                    return false;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean isSplittable() {
                    return true;
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean isRequiresStableInput() {
                    return signature.processElement().requiresStableInput();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean isRequiresTimeSortedInput() {
                    return signature.processElement().requiresTimeSortedInput();
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized boolean requestsFinalization() {
                    return signature.startBundle() != null && signature.startBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.processElement() != null && signature.processElement().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.finishBundle() != null && signature.finishBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer());
                }

                @Override
                public @UnknownKeyFor @NonNull @Initialized String translateRestrictionCoderId(@UnknownKeyFor @NonNull @Initialized SdkComponents newComponents) {
                    return restrictionCoderId;
                }
            }, components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(pke)).setPayload(payload.toByteString()).build();
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends  @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(ProcessKeyedElements.class, (Object)new ProcessKeyedElementsTranslator()).build();
        }
    }

    public static class ProcessKeyedElements<@UnknownKeyFor InputT, @UnknownKeyFor OutputT, @UnknownKeyFor RestrictionT, @UnknownKeyFor WatermarkEstimatorStateT>
    extends PTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> {
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn;
        private final @UnknownKeyFor @NonNull @Initialized Coder<InputT> elementCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<RestrictionT> restrictionCoder;
        private final @UnknownKeyFor @NonNull @Initialized Coder<WatermarkEstimatorStateT> watermarkEstimatorStateCoder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag;
        private final @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTagsToCoders;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping;

        public ProcessKeyedElements(@UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<InputT> elementCoder, @UnknownKeyFor @NonNull @Initialized Coder<RestrictionT> restrictionCoder, @UnknownKeyFor @NonNull @Initialized Coder<WatermarkEstimatorStateT> watermarkEstimatorStateCoder, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTagsToCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputMapping) {
            this.fn = fn;
            this.elementCoder = elementCoder;
            this.restrictionCoder = restrictionCoder;
            this.watermarkEstimatorStateCoder = watermarkEstimatorStateCoder;
            this.windowingStrategy = windowingStrategy;
            this.sideInputs = sideInputs;
            this.mainOutputTag = mainOutputTag;
            this.additionalOutputTags = additionalOutputTags;
            this.outputTagsToCoders = outputTagsToCoders;
            this.sideInputMapping = sideInputMapping;
        }

        public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
            return this.fn;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<InputT> getElementCoder() {
            return this.elementCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<RestrictionT> getRestrictionCoder() {
            return this.restrictionCoder;
        }

        public @UnknownKeyFor @NonNull @Initialized Coder<WatermarkEstimatorStateT> getWatermarkEstimatorStateCoder() {
            return this.watermarkEstimatorStateCoder;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<InputT, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getInputWindowingStrategy() {
            return this.windowingStrategy;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
            return this.sideInputs;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputMapping() {
            return this.sideInputMapping;
        }

        public @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> getMainOutputTag() {
            return this.mainOutputTag;
        }

        public @UnknownKeyFor @NonNull @Initialized TupleTagList getAdditionalOutputTags() {
            return this.additionalOutputTags;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getOutputTagsToCoders() {
            return this.outputTagsToCoders;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionTuple expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized KV<InputT, RestrictionT>>> input) {
            return ProcessKeyedElements.createPrimitiveOutputFor(input, this.fn, this.mainOutputTag, this.additionalOutputTags, this.outputTagsToCoders, this.windowingStrategy);
        }

        public static <OutputT> @UnknownKeyFor @NonNull @Initialized PCollectionTuple createPrimitiveOutputFor(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> input, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn, @UnknownKeyFor @NonNull @Initialized TupleTag<OutputT> mainOutputTag, @UnknownKeyFor @NonNull @Initialized TupleTagList additionalOutputTags, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputTagsToCoders, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy) {
            DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
            PCollectionTuple outputs = PCollectionTuple.ofPrimitiveOutputsInternal(input.getPipeline(), TupleTagList.of(mainOutputTag).and(additionalOutputTags.getAll()), outputTagsToCoders, windowingStrategy, input.isBounded().and(signature.isBoundedPerElement()));
            outputs.get(mainOutputTag).setTypeDescriptor(fn.getOutputTypeDescriptor());
            return outputs;
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }
    }

    private static class ExplodeWindowsFn<@UnknownKeyFor InputT>
    extends DoFn<InputT, InputT> {
        private ExplodeWindowsFn() {
        }

        @DoFn.ProcessElement
        public void process(@UnknownKeyFor @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            c.output(c.element());
        }
    }

    public static class OverrideFactory<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements PTransformOverrideFactory<PCollection<InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.PTransformReplacement<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple> getReplacementTransform(@UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<InputT>, @UnknownKeyFor @NonNull @Initialized PCollectionTuple, @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InputT, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), SplittableParDo.forAppliedParDo(transform));
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PTransformOverrideFactory.ReplacementOutput> mapOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs, @UnknownKeyFor @NonNull @Initialized PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, newOutput);
        }
    }
}

