/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.metrics.reporter.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public abstract class AbstractReporterConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractReporterConfig.class);

    protected static <T> T loadFromFile(String fileName, Class<T> clazz) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(clazz));
        FileInputStream input = new FileInputStream(new File(fileName));
        return (T)yaml.load((InputStream)input);
    }

    public static <T> boolean validate(T obj) {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Set violations = factory.getValidator().validate(obj, new Class[0]);
        TreeSet<String> errors = new TreeSet<String>();
        for (ConstraintViolation v : violations) {
            errors.add(String.format("%s %s (was %s)", v.getPropertyPath(), v.getMessage(), v.getInvalidValue()));
        }
        if (errors.isEmpty()) {
            return true;
        }
        log.error("Failed to validate: {}", errors);
        return false;
    }

    public static class ReporterConfigurationException
    extends RuntimeException {
        public ReporterConfigurationException(String msg) {
            super(msg);
        }
    }
}

