/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.UserCodeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BlobLibraryCacheManager
implements LibraryCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(BlobLibraryCacheManager.class);
    private final Object lockObject = new Object();
    @GuardedBy(value="lockObject")
    private final Map<JobID, LibraryCacheEntry> cacheEntries = new HashMap<JobID, LibraryCacheEntry>();
    @GuardedBy(value="lockObject")
    private final PermanentBlobService blobService;
    private final ClassLoaderFactory classLoaderFactory;

    public BlobLibraryCacheManager(PermanentBlobService blobService, ClassLoaderFactory classLoaderFactory) {
        this.blobService = (PermanentBlobService)Preconditions.checkNotNull((Object)blobService);
        this.classLoaderFactory = (ClassLoaderFactory)Preconditions.checkNotNull((Object)classLoaderFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibraryCacheManager.ClassLoaderLease registerClassLoaderLease(JobID jobId) {
        Object object = this.lockObject;
        synchronized (object) {
            return this.cacheEntries.computeIfAbsent(jobId, jobID -> new LibraryCacheEntry(jobId)).obtainLease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfReferenceHolders(JobID jobId) {
        Object object = this.lockObject;
        synchronized (object) {
            LibraryCacheEntry entry = this.cacheEntries.get(jobId);
            return entry == null ? 0 : entry.getReferenceCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfManagedJobs() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.cacheEntries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lockObject;
        synchronized (object) {
            for (LibraryCacheEntry entry : this.cacheEntries.values()) {
                entry.releaseClassLoader();
            }
            this.cacheEntries.clear();
        }
    }

    public static ClassLoaderFactory defaultClassLoaderFactory(FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstPatterns, @Nullable FatalErrorHandler fatalErrorHandlerJvmMetaspaceOomError, boolean checkClassLoaderLeak) {
        return new DefaultClassLoaderFactory(classLoaderResolveOrder, alwaysParentFirstPatterns, BlobLibraryCacheManager.createClassLoadingExceptionHandler(fatalErrorHandlerJvmMetaspaceOomError), checkClassLoaderLeak);
    }

    private static Consumer<Throwable> createClassLoadingExceptionHandler(@Nullable FatalErrorHandler fatalErrorHandlerJvmMetaspaceOomError) {
        return fatalErrorHandlerJvmMetaspaceOomError != null ? classLoadingException -> {
            if (ExceptionUtils.isMetaspaceOutOfMemoryError((Throwable)classLoadingException)) {
                fatalErrorHandlerJvmMetaspaceOomError.onFatalError(classLoadingException);
            }
        } : FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER;
    }

    private static final class ResolvedClassLoader
    implements UserCodeClassLoader {
        private final URLClassLoader classLoader;
        private final Set<PermanentBlobKey> libraries;
        private final Set<String> classPaths;
        private final Map<String, Runnable> releaseHooks;

        private ResolvedClassLoader(URLClassLoader classLoader, Collection<PermanentBlobKey> requiredLibraries, Collection<URL> requiredClassPaths) {
            this.classLoader = classLoader;
            this.classPaths = new HashSet<String>(requiredClassPaths.size());
            for (URL url : requiredClassPaths) {
                this.classPaths.add(url.toString());
            }
            this.libraries = new HashSet<PermanentBlobKey>(requiredLibraries);
            this.releaseHooks = new HashMap<String, Runnable>();
        }

        public ClassLoader asClassLoader() {
            return this.classLoader;
        }

        public void registerReleaseHookIfAbsent(String releaseHookName, Runnable releaseHook) {
            this.releaseHooks.putIfAbsent(releaseHookName, releaseHook);
        }

        private void verifyClassLoader(Collection<PermanentBlobKey> requiredLibraries, Collection<URL> requiredClassPaths) {
            if (this.libraries.size() != requiredLibraries.size() || !new HashSet<PermanentBlobKey>(requiredLibraries).containsAll(this.libraries)) {
                throw new IllegalStateException("The library registration references a different set of library BLOBs than previous registrations for this job:\nold:" + this.libraries + "\nnew:" + requiredLibraries);
            }
            if (this.classPaths.size() != requiredClassPaths.size() || !requiredClassPaths.stream().map(URL::toString).collect(Collectors.toSet()).containsAll(this.classPaths)) {
                throw new IllegalStateException("The library registration references a different set of library BLOBs than previous registrations for this job:\nold:" + this.classPaths + "\nnew:" + requiredClassPaths);
            }
        }

        private void releaseClassLoader() {
            this.runReleaseHooks();
            try {
                this.classLoader.close();
            }
            catch (IOException e) {
                LOG.warn("Failed to release user code class loader for " + Arrays.toString(this.libraries.toArray()));
            }
        }

        private void runReleaseHooks() {
            Set<Map.Entry<String, Runnable>> hooks = this.releaseHooks.entrySet();
            if (!hooks.isEmpty()) {
                for (Map.Entry<String, Runnable> hookEntry : hooks) {
                    try {
                        LOG.debug("Running class loader shutdown hook: {}.", (Object)hookEntry.getKey());
                        hookEntry.getValue().run();
                    }
                    catch (Throwable t) {
                        LOG.warn("Failed to run release hook '{}' for user code class loader.", (Object)hookEntry.getValue(), (Object)t);
                    }
                }
                this.releaseHooks.clear();
            }
        }
    }

    private static final class DefaultClassLoaderLease
    implements LibraryCacheManager.ClassLoaderLease {
        private final LibraryCacheEntry libraryCacheEntry;
        private boolean isClosed;

        private DefaultClassLoaderLease(LibraryCacheEntry libraryCacheEntry) {
            this.libraryCacheEntry = libraryCacheEntry;
            this.isClosed = false;
        }

        @Override
        public UserCodeClassLoader getOrResolveClassLoader(Collection<PermanentBlobKey> requiredJarFiles, Collection<URL> requiredClasspaths) throws IOException {
            this.verifyIsNotClosed();
            return this.libraryCacheEntry.getOrResolveClassLoader(requiredJarFiles, requiredClasspaths);
        }

        private void verifyIsNotClosed() {
            Preconditions.checkState((!this.isClosed ? 1 : 0) != 0, (Object)"The ClassLoaderHandler has already been closed.");
        }

        @Override
        public void release() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.libraryCacheEntry.release();
        }

        private static DefaultClassLoaderLease create(LibraryCacheEntry libraryCacheEntry) {
            return new DefaultClassLoaderLease(libraryCacheEntry);
        }
    }

    private final class LibraryCacheEntry {
        private final JobID jobId;
        @GuardedBy(value="lockObject")
        private int referenceCount;
        @Nullable
        @GuardedBy(value="lockObject")
        private ResolvedClassLoader resolvedClassLoader;
        @GuardedBy(value="lockObject")
        private boolean isReleased;

        private LibraryCacheEntry(JobID jobId) {
            this.jobId = jobId;
            this.referenceCount = 0;
            this.resolvedClassLoader = null;
            this.isReleased = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UserCodeClassLoader getOrResolveClassLoader(Collection<PermanentBlobKey> libraries, Collection<URL> classPaths) throws IOException {
            Object object = BlobLibraryCacheManager.this.lockObject;
            synchronized (object) {
                this.verifyIsNotReleased();
                if (this.resolvedClassLoader == null) {
                    this.resolvedClassLoader = new ResolvedClassLoader(this.createUserCodeClassLoader(this.jobId, libraries, classPaths), libraries, classPaths);
                } else {
                    this.resolvedClassLoader.verifyClassLoader(libraries, classPaths);
                }
                return this.resolvedClassLoader;
            }
        }

        @GuardedBy(value="lockObject")
        private URLClassLoader createUserCodeClassLoader(JobID jobId, Collection<PermanentBlobKey> requiredJarFiles, Collection<URL> requiredClasspaths) throws IOException {
            try {
                URL[] libraryURLs = new URL[requiredJarFiles.size() + requiredClasspaths.size()];
                int count = 0;
                for (PermanentBlobKey key : requiredJarFiles) {
                    libraryURLs[count] = BlobLibraryCacheManager.this.blobService.getFile(jobId, key).toURI().toURL();
                    ++count;
                }
                Iterator<Serializable> iterator = requiredClasspaths.iterator();
                while (iterator.hasNext()) {
                    URL url;
                    libraryURLs[count] = url = (URL)iterator.next();
                    ++count;
                }
                return BlobLibraryCacheManager.this.classLoaderFactory.createClassLoader(libraryURLs);
            }
            catch (Exception e) {
                ExceptionUtils.tryRethrowIOException((Throwable)e);
                throw new IOException("Library cache could not register the user code libraries.", e);
            }
        }

        @GuardedBy(value="lockObject")
        public int getReferenceCount() {
            return this.referenceCount;
        }

        @GuardedBy(value="lockObject")
        private DefaultClassLoaderLease obtainLease() {
            this.verifyIsNotReleased();
            ++this.referenceCount;
            return DefaultClassLoaderLease.create(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release() {
            Object object = BlobLibraryCacheManager.this.lockObject;
            synchronized (object) {
                if (this.isReleased) {
                    return;
                }
                if (this.referenceCount > 0) {
                    --this.referenceCount;
                }
                if (this.referenceCount == 0) {
                    this.releaseClassLoader();
                    BlobLibraryCacheManager.this.cacheEntries.remove(this.jobId);
                }
            }
        }

        @GuardedBy(value="lockObject")
        private void releaseClassLoader() {
            if (this.resolvedClassLoader != null) {
                this.resolvedClassLoader.releaseClassLoader();
                this.resolvedClassLoader = null;
            }
            this.isReleased = true;
        }

        @GuardedBy(value="lockObject")
        private void verifyIsNotReleased() {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0, (Object)"The LibraryCacheEntry has already been released.");
        }
    }

    private static final class DefaultClassLoaderFactory
    implements ClassLoaderFactory {
        private final FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder;
        private final String[] alwaysParentFirstPatterns;
        private final Consumer<Throwable> classLoadingExceptionHandler;
        private final boolean checkClassLoaderLeak;

        private DefaultClassLoaderFactory(FlinkUserCodeClassLoaders.ResolveOrder classLoaderResolveOrder, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler, boolean checkClassLoaderLeak) {
            this.classLoaderResolveOrder = classLoaderResolveOrder;
            this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
            this.classLoadingExceptionHandler = classLoadingExceptionHandler;
            this.checkClassLoaderLeak = checkClassLoaderLeak;
        }

        @Override
        public URLClassLoader createClassLoader(URL[] libraryURLs) {
            return FlinkUserCodeClassLoaders.create((FlinkUserCodeClassLoaders.ResolveOrder)this.classLoaderResolveOrder, (URL[])libraryURLs, (ClassLoader)FlinkUserCodeClassLoaders.class.getClassLoader(), (String[])this.alwaysParentFirstPatterns, this.classLoadingExceptionHandler, (boolean)this.checkClassLoaderLeak);
        }
    }

    @FunctionalInterface
    public static interface ClassLoaderFactory {
        public URLClassLoader createClassLoader(URL[] var1);
    }
}

