/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.util.List;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.ShardingFunction;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_WriteFiles<UserT, DestinationT, OutputT>
extends WriteFiles<UserT, DestinationT, OutputT> {
    private final FileBasedSink<UserT, DestinationT, OutputT> sink;
    private final @Nullable PTransform<PCollection<UserT>, PCollectionView<Integer>> computeNumShards;
    private final @Nullable ValueProvider<Integer> numShardsProvider;
    private final boolean windowedWrites;
    private final boolean withAutoSharding;
    private final int maxNumWritersPerBundle;
    private final boolean skipIfEmpty;
    private final @Nullable Integer batchSize;
    private final @Nullable Integer batchSizeBytes;
    private final @Nullable Duration batchMaxBufferingDuration;
    private final List<PCollectionView<?>> sideInputs;
    private final @Nullable ShardingFunction<UserT, DestinationT> shardingFunction;
    private final ErrorHandler<BadRecord, ?> badRecordErrorHandler;
    private final BadRecordRouter badRecordRouter;

    private AutoValue_WriteFiles(FileBasedSink<UserT, DestinationT, OutputT> sink, @Nullable PTransform<PCollection<UserT>, PCollectionView<Integer>> computeNumShards, @Nullable ValueProvider<Integer> numShardsProvider, boolean windowedWrites, boolean withAutoSharding, int maxNumWritersPerBundle, boolean skipIfEmpty, @Nullable Integer batchSize, @Nullable Integer batchSizeBytes, @Nullable Duration batchMaxBufferingDuration, List<PCollectionView<?>> sideInputs, @Nullable ShardingFunction<UserT, DestinationT> shardingFunction, ErrorHandler<BadRecord, ?> badRecordErrorHandler, BadRecordRouter badRecordRouter) {
        this.sink = sink;
        this.computeNumShards = computeNumShards;
        this.numShardsProvider = numShardsProvider;
        this.windowedWrites = windowedWrites;
        this.withAutoSharding = withAutoSharding;
        this.maxNumWritersPerBundle = maxNumWritersPerBundle;
        this.skipIfEmpty = skipIfEmpty;
        this.batchSize = batchSize;
        this.batchSizeBytes = batchSizeBytes;
        this.batchMaxBufferingDuration = batchMaxBufferingDuration;
        this.sideInputs = sideInputs;
        this.shardingFunction = shardingFunction;
        this.badRecordErrorHandler = badRecordErrorHandler;
        this.badRecordRouter = badRecordRouter;
    }

    @Override
    public FileBasedSink<UserT, DestinationT, OutputT> getSink() {
        return this.sink;
    }

    @Override
    public @Nullable PTransform<PCollection<UserT>, PCollectionView<Integer>> getComputeNumShards() {
        return this.computeNumShards;
    }

    @Override
    public @Nullable ValueProvider<Integer> getNumShardsProvider() {
        return this.numShardsProvider;
    }

    @Override
    public boolean getWindowedWrites() {
        return this.windowedWrites;
    }

    @Override
    public boolean getWithAutoSharding() {
        return this.withAutoSharding;
    }

    @Override
    int getMaxNumWritersPerBundle() {
        return this.maxNumWritersPerBundle;
    }

    @Override
    boolean getSkipIfEmpty() {
        return this.skipIfEmpty;
    }

    @Override
    @Nullable Integer getBatchSize() {
        return this.batchSize;
    }

    @Override
    @Nullable Integer getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    @Override
    @Nullable Duration getBatchMaxBufferingDuration() {
        return this.batchMaxBufferingDuration;
    }

    @Override
    List<PCollectionView<?>> getSideInputs() {
        return this.sideInputs;
    }

    @Override
    public @Nullable ShardingFunction<UserT, DestinationT> getShardingFunction() {
        return this.shardingFunction;
    }

    @Override
    public ErrorHandler<BadRecord, ?> getBadRecordErrorHandler() {
        return this.badRecordErrorHandler;
    }

    @Override
    public BadRecordRouter getBadRecordRouter() {
        return this.badRecordRouter;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WriteFiles) {
            WriteFiles that = (WriteFiles)o;
            return this.sink.equals(that.getSink()) && (this.computeNumShards == null ? that.getComputeNumShards() == null : this.computeNumShards.equals(that.getComputeNumShards())) && (this.numShardsProvider == null ? that.getNumShardsProvider() == null : this.numShardsProvider.equals(that.getNumShardsProvider())) && this.windowedWrites == that.getWindowedWrites() && this.withAutoSharding == that.getWithAutoSharding() && this.maxNumWritersPerBundle == that.getMaxNumWritersPerBundle() && this.skipIfEmpty == that.getSkipIfEmpty() && (this.batchSize == null ? that.getBatchSize() == null : this.batchSize.equals(that.getBatchSize())) && (this.batchSizeBytes == null ? that.getBatchSizeBytes() == null : this.batchSizeBytes.equals(that.getBatchSizeBytes())) && (this.batchMaxBufferingDuration == null ? that.getBatchMaxBufferingDuration() == null : this.batchMaxBufferingDuration.equals((Object)that.getBatchMaxBufferingDuration())) && this.sideInputs.equals(that.getSideInputs()) && (this.shardingFunction == null ? that.getShardingFunction() == null : this.shardingFunction.equals(that.getShardingFunction())) && this.badRecordErrorHandler.equals(that.getBadRecordErrorHandler()) && this.badRecordRouter.equals(that.getBadRecordRouter());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.sink.hashCode();
        h$ *= 1000003;
        h$ ^= this.computeNumShards == null ? 0 : this.computeNumShards.hashCode();
        h$ *= 1000003;
        h$ ^= this.numShardsProvider == null ? 0 : this.numShardsProvider.hashCode();
        h$ *= 1000003;
        h$ ^= this.windowedWrites ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.withAutoSharding ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.maxNumWritersPerBundle;
        h$ *= 1000003;
        h$ ^= this.skipIfEmpty ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.batchSize == null ? 0 : this.batchSize.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchSizeBytes == null ? 0 : this.batchSizeBytes.hashCode();
        h$ *= 1000003;
        h$ ^= this.batchMaxBufferingDuration == null ? 0 : this.batchMaxBufferingDuration.hashCode();
        h$ *= 1000003;
        h$ ^= this.sideInputs.hashCode();
        h$ *= 1000003;
        h$ ^= this.shardingFunction == null ? 0 : this.shardingFunction.hashCode();
        h$ *= 1000003;
        h$ ^= this.badRecordErrorHandler.hashCode();
        h$ *= 1000003;
        return h$ ^= this.badRecordRouter.hashCode();
    }

    @Override
    WriteFiles.Builder<UserT, DestinationT, OutputT> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<UserT, DestinationT, OutputT>
    extends WriteFiles.Builder<UserT, DestinationT, OutputT> {
        private FileBasedSink<UserT, DestinationT, OutputT> sink;
        private @Nullable PTransform<PCollection<UserT>, PCollectionView<Integer>> computeNumShards;
        private @Nullable ValueProvider<Integer> numShardsProvider;
        private Boolean windowedWrites;
        private Boolean withAutoSharding;
        private Integer maxNumWritersPerBundle;
        private Boolean skipIfEmpty;
        private @Nullable Integer batchSize;
        private @Nullable Integer batchSizeBytes;
        private @Nullable Duration batchMaxBufferingDuration;
        private List<PCollectionView<?>> sideInputs;
        private @Nullable ShardingFunction<UserT, DestinationT> shardingFunction;
        private ErrorHandler<BadRecord, ?> badRecordErrorHandler;
        private BadRecordRouter badRecordRouter;

        Builder() {
        }

        private Builder(WriteFiles<UserT, DestinationT, OutputT> source) {
            this.sink = source.getSink();
            this.computeNumShards = source.getComputeNumShards();
            this.numShardsProvider = source.getNumShardsProvider();
            this.windowedWrites = source.getWindowedWrites();
            this.withAutoSharding = source.getWithAutoSharding();
            this.maxNumWritersPerBundle = source.getMaxNumWritersPerBundle();
            this.skipIfEmpty = source.getSkipIfEmpty();
            this.batchSize = source.getBatchSize();
            this.batchSizeBytes = source.getBatchSizeBytes();
            this.batchMaxBufferingDuration = source.getBatchMaxBufferingDuration();
            this.sideInputs = source.getSideInputs();
            this.shardingFunction = source.getShardingFunction();
            this.badRecordErrorHandler = source.getBadRecordErrorHandler();
            this.badRecordRouter = source.getBadRecordRouter();
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setSink(FileBasedSink<UserT, DestinationT, OutputT> sink) {
            if (sink == null) {
                throw new NullPointerException("Null sink");
            }
            this.sink = sink;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setComputeNumShards(@Nullable PTransform<PCollection<UserT>, PCollectionView<Integer>> computeNumShards) {
            this.computeNumShards = computeNumShards;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setNumShardsProvider(@Nullable ValueProvider<Integer> numShardsProvider) {
            this.numShardsProvider = numShardsProvider;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setWindowedWrites(boolean windowedWrites) {
            this.windowedWrites = windowedWrites;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setWithAutoSharding(boolean withAutoSharding) {
            this.withAutoSharding = withAutoSharding;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setMaxNumWritersPerBundle(int maxNumWritersPerBundle) {
            this.maxNumWritersPerBundle = maxNumWritersPerBundle;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setSkipIfEmpty(boolean skipIfEmpty) {
            this.skipIfEmpty = skipIfEmpty;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setBatchSize(@Nullable Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setBatchSizeBytes(@Nullable Integer batchSizeBytes) {
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setBatchMaxBufferingDuration(@Nullable Duration batchMaxBufferingDuration) {
            this.batchMaxBufferingDuration = batchMaxBufferingDuration;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setSideInputs(List<PCollectionView<?>> sideInputs) {
            if (sideInputs == null) {
                throw new NullPointerException("Null sideInputs");
            }
            this.sideInputs = sideInputs;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setShardingFunction(@Nullable ShardingFunction<UserT, DestinationT> shardingFunction) {
            this.shardingFunction = shardingFunction;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setBadRecordErrorHandler(ErrorHandler<BadRecord, ?> badRecordErrorHandler) {
            if (badRecordErrorHandler == null) {
                throw new NullPointerException("Null badRecordErrorHandler");
            }
            this.badRecordErrorHandler = badRecordErrorHandler;
            return this;
        }

        @Override
        WriteFiles.Builder<UserT, DestinationT, OutputT> setBadRecordRouter(BadRecordRouter badRecordRouter) {
            if (badRecordRouter == null) {
                throw new NullPointerException("Null badRecordRouter");
            }
            this.badRecordRouter = badRecordRouter;
            return this;
        }

        @Override
        WriteFiles<UserT, DestinationT, OutputT> build() {
            if (this.sink == null || this.windowedWrites == null || this.withAutoSharding == null || this.maxNumWritersPerBundle == null || this.skipIfEmpty == null || this.sideInputs == null || this.badRecordErrorHandler == null || this.badRecordRouter == null) {
                StringBuilder missing = new StringBuilder();
                if (this.sink == null) {
                    missing.append(" sink");
                }
                if (this.windowedWrites == null) {
                    missing.append(" windowedWrites");
                }
                if (this.withAutoSharding == null) {
                    missing.append(" withAutoSharding");
                }
                if (this.maxNumWritersPerBundle == null) {
                    missing.append(" maxNumWritersPerBundle");
                }
                if (this.skipIfEmpty == null) {
                    missing.append(" skipIfEmpty");
                }
                if (this.sideInputs == null) {
                    missing.append(" sideInputs");
                }
                if (this.badRecordErrorHandler == null) {
                    missing.append(" badRecordErrorHandler");
                }
                if (this.badRecordRouter == null) {
                    missing.append(" badRecordRouter");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_WriteFiles(this.sink, this.computeNumShards, this.numShardsProvider, this.windowedWrites, this.withAutoSharding, this.maxNumWritersPerBundle, this.skipIfEmpty, this.batchSize, this.batchSizeBytes, this.batchMaxBufferingDuration, this.sideInputs, this.shardingFunction, this.badRecordErrorHandler, this.badRecordRouter);
        }
    }
}

