/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.cypherbuilder.CypherBuilder;
import org.apache.hop.neo4j.transforms.cypherbuilder.CypherBuilderData;
import org.apache.hop.neo4j.transforms.cypherbuilder.Parameter;
import org.apache.hop.neo4j.transforms.cypherbuilder.ReturnValue;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.IOperation;
import org.apache.hop.neo4j.transforms.cypherbuilder.operation.ReturnOperation;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Neo4jCypherBuilder", name="i18n::CypherBuilderMeta.name", description="i18n::CypherBuilderMeta.description", image="neo4j_cypher.svg", categoryDescription="Neo4j", keywords={"i18n::CypherBuilderMeta.keyword"}, documentationUrl="/pipeline/transforms/neo4j-cypher-builder.html")
public class CypherBuilderMeta
extends BaseTransformMeta<CypherBuilder, CypherBuilderData> {
    public static final String ROWS_UNWIND_MAP_ENTRY = "rows";
    @HopMetadataProperty(hopMetadataPropertyType=HopMetadataPropertyType.GRAPH_CONNECTION)
    private String connectionName;
    @HopMetadataProperty
    private String batchSize;
    @HopMetadataProperty
    private String unwindAlias;
    @HopMetadataProperty
    private String retries;
    @HopMetadataProperty(groupKey="parameters", key="parameter")
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @HopMetadataProperty(groupKey="operations", key="operation")
    private List<IOperation> operations = new ArrayList<IOperation>();

    public CypherBuilderMeta() {
    }

    public CypherBuilderMeta(CypherBuilderMeta meta) {
        this();
        this.connectionName = meta.connectionName;
        this.batchSize = meta.batchSize;
        this.unwindAlias = meta.unwindAlias;
        this.retries = meta.retries;
        meta.parameters.forEach(p -> this.parameters.add(p.clone()));
        meta.operations.forEach(o -> this.operations.add(o.clone()));
    }

    public void setDefault() {
        this.batchSize = "1000";
        this.unwindAlias = "row";
        this.retries = "10";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (StringUtils.isNotEmpty((String)variables.resolve(this.unwindAlias))) {
            inputRowMeta.clear();
        }
        for (IOperation operation : this.operations) {
            if (!(operation instanceof ReturnOperation)) continue;
            ReturnOperation returnOperation = (ReturnOperation)operation;
            List<ReturnValue> returnValues = returnOperation.getReturnValues();
            for (ReturnValue returnValue : returnValues) {
                IValueMeta valueMeta = returnValue.createValueMeta();
                valueMeta.setOrigin(name);
                valueMeta.setComments(returnValue.getNeoType());
                inputRowMeta.addValueMeta(valueMeta);
            }
        }
    }

    public String getCypher(IVariables variables) throws HopException {
        String realUnwindAlias = variables.resolve(this.unwindAlias);
        StringBuilder cypher = new StringBuilder();
        if (StringUtils.isNotEmpty((String)realUnwindAlias)) {
            cypher.append("UNWIND $").append(ROWS_UNWIND_MAP_ENTRY).append(" AS ").append(realUnwindAlias).append(" ").append(Const.CR);
        }
        for (IOperation operation : this.operations) {
            cypher.append(operation.getCypherClause(realUnwindAlias, this.parameters));
            cypher.append(Const.CR);
        }
        return cypher.toString();
    }

    public boolean needsWriteTransaction() {
        for (IOperation operation : this.operations) {
            if (!operation.needsWriteTransaction()) continue;
            return true;
        }
        return false;
    }

    public CypherBuilderMeta clone() {
        return new CypherBuilderMeta(this);
    }

    public IOperation findOperation(String operationName) {
        for (IOperation operation : this.operations) {
            if (operation.getName() == null || !operation.getName().equals(operationName)) continue;
            return operation;
        }
        return null;
    }

    public String[] getParameterNames() {
        Object[] names = new String[this.parameters.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.parameters.get(i).getName();
        }
        Arrays.sort(names);
        return names;
    }

    public String[] getOperationNames() {
        String[] names = new String[this.operations.size()];
        for (int i = 0; i < names.length; ++i) {
            IOperation operation = this.operations.get(i);
            names[i] = Const.NVL((String)operation.getName(), (String)operation.getOperationType().getDescription());
        }
        return names;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getUnwindAlias() {
        return this.unwindAlias;
    }

    public void setUnwindAlias(String unwindAlias) {
        this.unwindAlias = unwindAlias;
    }

    public String getRetries() {
        return this.retries;
    }

    public void setRetries(String retries) {
        this.retries = retries;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<IOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<IOperation> operations) {
        this.operations = operations;
    }
}

