/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.guardrails;

import javax.annotation.Nullable;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.guardrails.GuardrailsConfig;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.FBUtilities;

public interface GuardrailsConfigProvider {
    public static final String CUSTOM_IMPLEMENTATION_PROPERTY = "cassandra.custom_guardrails_config_provider_class";
    public static final GuardrailsConfigProvider instance = System.getProperty("cassandra.custom_guardrails_config_provider_class") == null ? new Default() : GuardrailsConfigProvider.build(System.getProperty("cassandra.custom_guardrails_config_provider_class"));

    public GuardrailsConfig getOrCreate(@Nullable ClientState var1);

    public static GuardrailsConfigProvider build(String customImpl) {
        return (GuardrailsConfigProvider)FBUtilities.construct(customImpl, "custom guardrails config provider");
    }

    public static class Default
    implements GuardrailsConfigProvider {
        @Override
        public GuardrailsConfig getOrCreate(@Nullable ClientState state) {
            return DatabaseDescriptor.getGuardrailsConfig();
        }
    }
}

