/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.CommandLineArguments;
import com.ibm.as400.access.PSLoad;
import com.ibm.as400.access.PSLoadBalancer;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.Verbose;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

class PSConfig {
    private static final String OPTION_BALANCE_THRESHOLD = "balanceThreshold";
    private static final String OPTION_CONFIGURATION = "configuration";
    private static final String OPTION_JDBC_DRIVERS = "jdbcDrivers";
    private static final String OPTION_MAX_CONNECTIONS = "maxConnections";
    private static final String OPTION_PEERS = "peers";
    private static final String OPTION_VERBOSE = "verbose";
    static final Vector expectedOptions_ = new Vector();
    static final Hashtable shortcuts_ = new Hashtable();
    private PSLoad load_;
    private PSLoadBalancer loadBalancer_;
    private String name_;
    private Properties properties_;

    public PSConfig(PSLoad load, PSLoadBalancer loadBalancer) {
        this.load_ = load;
        this.loadBalancer_ = loadBalancer;
        this.name_ = null;
        this.properties_ = new Properties();
    }

    public void apply(CommandLineArguments cla) throws IOException {
        Trace.loadTraceProperties();
        String optionValue = cla.getOptionValue(OPTION_VERBOSE);
        if (optionValue != null) {
            this.setVerbose(optionValue);
            this.properties_.put(OPTION_VERBOSE, optionValue);
        }
        if ((optionValue = cla.getOptionValue(OPTION_CONFIGURATION)) != null) {
            this.setName(optionValue);
            this.load();
        }
        if ((optionValue = cla.getOptionValue(OPTION_VERBOSE)) != null) {
            this.setVerbose(optionValue);
            this.properties_.put(OPTION_VERBOSE, optionValue);
        }
        if ((optionValue = cla.getOptionValue(OPTION_BALANCE_THRESHOLD)) != null) {
            this.load_.setBalanceThreshold(Integer.parseInt(optionValue));
            this.properties_.put(OPTION_BALANCE_THRESHOLD, optionValue);
        }
        if ((optionValue = cla.getOptionValue(OPTION_JDBC_DRIVERS)) != null) {
            this.registerJDBCDrivers(optionValue);
            this.properties_.put(OPTION_JDBC_DRIVERS, optionValue);
        }
        if ((optionValue = cla.getOptionValue(OPTION_MAX_CONNECTIONS)) != null) {
            this.load_.setMaxConnections(Integer.parseInt(optionValue));
            this.properties_.put(OPTION_MAX_CONNECTIONS, optionValue);
        }
        if ((optionValue = cla.getOptionValue(OPTION_PEERS)) != null) {
            this.loadBalancer_.setPeers(optionValue);
            this.properties_.put(OPTION_PEERS, optionValue);
        }
    }

    public void apply(Properties configurationProperties) {
        Trace.loadTraceProperties();
        boolean verboseBefore = Verbose.isVerbose();
        Enumeration<?> list = configurationProperties.propertyNames();
        while (list.hasMoreElements()) {
            String optionName = (String)list.nextElement();
            String optionValue = configurationProperties.getProperty(optionName);
            if (Trace.isTraceProxyOn()) {
                Trace.log(6, "Changing option " + optionName + " to " + optionValue + ".");
                continue;
            }
            if (optionName.equalsIgnoreCase(OPTION_BALANCE_THRESHOLD)) {
                this.load_.setBalanceThreshold(Integer.parseInt(optionValue));
                this.properties_.put(OPTION_BALANCE_THRESHOLD, optionValue);
                continue;
            }
            if (optionName.equalsIgnoreCase(OPTION_JDBC_DRIVERS)) {
                this.registerJDBCDrivers(optionValue);
                this.properties_.put(OPTION_JDBC_DRIVERS, optionValue);
                continue;
            }
            if (optionName.equalsIgnoreCase(OPTION_MAX_CONNECTIONS)) {
                this.load_.setMaxConnections(Integer.parseInt(optionValue));
                this.properties_.put(OPTION_MAX_CONNECTIONS, optionValue);
                continue;
            }
            if (optionName.equalsIgnoreCase(OPTION_PEERS)) {
                this.loadBalancer_.setPeers(optionValue);
                this.properties_.put(OPTION_PEERS, optionValue);
                continue;
            }
            if (optionName.equalsIgnoreCase(OPTION_VERBOSE)) {
                this.setVerbose(optionValue);
                this.properties_.put(OPTION_VERBOSE, optionValue);
                continue;
            }
            if (optionName.trim().length() <= 0) continue;
            throw new IllegalArgumentException(ResourceBundleLoader.getText("PROXY_OPTION_NOT_VALID", optionName));
        }
        boolean verboseAfter = Verbose.isVerbose();
        if (verboseBefore || verboseAfter) {
            Verbose.forcePrintln(ResourceBundleLoader.getText("PROXY_CONFIGURATION_UPDATED"));
        }
    }

    public String getName() {
        return this.name_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public void load() throws IOException {
        Properties configurationProperties = new Properties();
        try (InputStream input = null;){
            input = new BufferedInputStream(new FileInputStream(this.name_));
            configurationProperties.load(input);
            this.apply(configurationProperties);
        }
    }

    private void registerJDBCDrivers(String jdbcDrivers) {
        StringTokenizer tokenizer = new StringTokenizer(jdbcDrivers, ";, ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                Class<?> driverClass = Class.forName(token);
                boolean found = false;
                Enumeration<Driver> list = DriverManager.getDrivers();
                while (list.hasMoreElements() && !found) {
                    Driver enumDriver = list.nextElement();
                    if (!enumDriver.getClass().equals(driverClass)) continue;
                    found = true;
                }
                if (!found) {
                    DriverManager.registerDriver((Driver)Class.forName(token).newInstance());
                }
                Verbose.println(ResourceBundleLoader.getText("PROXY_JDBC_DRIVER_REGISTERED", token));
            }
            catch (Exception e) {
                if (Trace.isTraceErrorOn()) {
                    Trace.log(2, "JDBC driver not found.", (Throwable)e);
                }
                Verbose.println(ResourceBundleLoader.getText("PROXY_JDBC_DRIVER_NOT_REGISTERED", token));
            }
        }
    }

    public void setName(String name) {
        this.name_ = name;
    }

    private void setVerbose(String verbose) {
        if (verbose.length() == 0 || verbose.equalsIgnoreCase("true")) {
            Verbose.setVerbose(true);
        } else if (verbose.equalsIgnoreCase("false")) {
            Verbose.setVerbose(false);
        } else {
            throw new IllegalArgumentException(ResourceBundleLoader.getText("PROXY_OPTION_VALUE_NOT_VALID", new String[]{OPTION_VERBOSE, verbose}));
        }
    }

    static void usage(PrintStream out) {
        String usage = ResourceBundleLoader.getText("PROXY_SERVER_USAGE");
        String optionslc = ResourceBundleLoader.getText("PROXY_SERVER_OPTIONSLC");
        String optionsuc = ResourceBundleLoader.getText("PROXY_SERVER_OPTIONSUC");
        String shortcuts = ResourceBundleLoader.getText("PROXY_SERVER_SHORTCUTS");
        out.println(usage + ":");
        out.println();
        out.println("  com.ibm.as400.access.ProxyServer [ " + optionslc + " ]");
        out.println();
        out.println(optionsuc + ":");
        out.println();
        out.println("  -balanceThreshold balanceThreshold");
        out.println("  -configuration configuration");
        out.println("  -jdbcDrivers jdbcDriver1[;jdbcDriver2;...]");
        out.println("  -maxConnections maxConnections");
        out.println("  -peers hostname1[:port1][;hostname2[:port2];...");
        out.println("  -port port");
        out.println("  -securePort securePort");
        out.println("  -verbose [true|false]");
        out.println("  -help");
        out.println();
        out.println(shortcuts + ":");
        out.println();
        out.println("  -bt balanceThreshold");
        out.println("  -c configuration");
        out.println("  -jd jdbcDriver1[;jdbcDriver2;...]");
        out.println("  -mc maxConnections");
        out.println("  -pe hostname1[:port1][;hostname2[:port2];...");
        out.println("  -po port");
        out.println("  -sp securePort");
        out.println("  -v [true|false]");
        out.println("  -h");
        out.println("  -?");
    }

    static {
        expectedOptions_.addElement("-balanceThreshold");
        expectedOptions_.addElement("-configuration");
        expectedOptions_.addElement("-jdbcDrivers");
        expectedOptions_.addElement("-maxConnections");
        expectedOptions_.addElement("-peers");
        expectedOptions_.addElement("-port");
        expectedOptions_.addElement("-securePort");
        expectedOptions_.addElement("-verbose");
        expectedOptions_.addElement("-help");
        shortcuts_.put("-bt", "-balanceThreshold");
        shortcuts_.put("-c", "-configuration");
        shortcuts_.put("-jd", "-jdbcDrivers");
        shortcuts_.put("-mc", "-maxConnections");
        shortcuts_.put("-pe", "-peers");
        shortcuts_.put("-po", "-port");
        shortcuts_.put("-sp", "-securePort");
        shortcuts_.put("-v", "-verbose");
        shortcuts_.put("-h", "-help");
        shortcuts_.put("-?", "-help");
    }
}

