/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400Message;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.MessagePropertiesPane;
import com.ibm.as400.vaccess.MessageUtilities;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.Icon;

public class VMessage
implements VObject,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("MESSAGE_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VMessage16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VMessage32.gif", description_);
    private AS400Message message_ = null;
    private transient VPropertiesPane propertiesPane_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;
    public static final Object ID_PROPERTY = "ID";
    public static final Object SEVERITY_PROPERTY = "Severity";
    public static final Object TEXT_PROPERTY = "Text";
    public static final Object TYPE_PROPERTY = "Type";

    VMessage(AS400Message message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        this.message_ = message;
        this.initializeTransient();
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public VAction[] getActions() {
        return null;
    }

    @Override
    public VAction getDefaultAction() {
        return null;
    }

    @Override
    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    @Override
    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    @Override
    public synchronized Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (propertyIdentifier == ID_PROPERTY) {
            return this.message_.getID();
        }
        if (propertyIdentifier == TEXT_PROPERTY) {
            return this.message_.getText();
        }
        if (propertyIdentifier == SEVERITY_PROPERTY) {
            return this.message_.getSeverity();
        }
        if (propertyIdentifier == TYPE_PROPERTY) {
            return MessageUtilities.getTypeText(this.message_.getType());
        }
        return null;
    }

    @Override
    public String getText() {
        String id = this.message_.getID();
        if (id == null) {
            return "";
        }
        return id;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.propertiesPane_ = new MessagePropertiesPane(this, this.message_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    @Override
    public void load() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public String toString() {
        String id = this.message_.getID();
        if (id == null) {
            return "";
        }
        return id;
    }
}

