/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VPropertiesAction
implements VAction,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String applyText_ = ResourceLoader.getText("DLG_APPLY");
    private static final String cancelText_ = ResourceLoader.getText("DLG_CANCEL");
    private static final String okText_ = ResourceLoader.getText("DLG_OK");
    private static final String propertiesActionText_ = ResourceLoader.getText("ACTION_PROPERTIES");
    private static final String propertiesDialogText_ = ResourceLoader.getText("DLG_PROPERTIES_TITLE");
    private boolean enabled_ = true;
    private VObject object_ = null;
    private static Hashtable visibleDialogs_ = new Hashtable();
    transient ErrorEventSupport errorEventSupport_;
    transient VObjectEventSupport objectEventSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public VPropertiesAction() {
        this.initializeTransient();
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    void applyChanges(VPropertiesPane propertiesPane) {
        try {
            propertiesPane.applyChanges();
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
    }

    static void disposeDialog(VObject object) {
        JDialog dialog = (JDialog)visibleDialogs_.get(object);
        dialog.dispose();
        visibleDialogs_.remove(object);
    }

    public VObject getObject() {
        return this.object_;
    }

    @Override
    public String getText() {
        return propertiesActionText_;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled_;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
    }

    @Override
    public void perform(VActionContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this.enabled_ && this.object_ != null) {
            VPropertiesPane propertiesPane;
            final VPropertiesPane propertiesPane2 = propertiesPane = this.object_.getPropertiesPane();
            final VObject object2 = this.object_;
            if (propertiesPane != null) {
                if (visibleDialogs_.containsKey(this.object_)) {
                    JDialog dialog = (JDialog)visibleDialogs_.get(this.object_);
                    dialog.toFront();
                    dialog.requestFocus();
                } else {
                    JButton applyButton;
                    String title = ResourceLoader.substitute(propertiesDialogText_, this.object_.getText());
                    propertiesPane.addErrorListener(this.errorEventSupport_);
                    propertiesPane.addVObjectListener(this.objectEventSupport_);
                    propertiesPane.addWorkingListener(this.workingEventSupport_);
                    final JButton applyButton2 = applyButton = new JButton(applyText_);
                    applyButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            VPropertiesAction.this.applyChanges(propertiesPane2);
                            applyButton2.setEnabled(false);
                        }
                    });
                    applyButton.setEnabled(false);
                    JButton cancelButton = new JButton(cancelText_);
                    cancelButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            propertiesPane2.removeErrorListener(VPropertiesAction.this.errorEventSupport_);
                            propertiesPane2.removeVObjectListener(VPropertiesAction.this.objectEventSupport_);
                            propertiesPane2.removeWorkingListener(VPropertiesAction.this.workingEventSupport_);
                            VPropertiesAction.disposeDialog(object2);
                        }
                    });
                    JButton okButton = new JButton(okText_);
                    okButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            VPropertiesAction.this.applyChanges(propertiesPane2);
                            propertiesPane2.removeErrorListener(VPropertiesAction.this.errorEventSupport_);
                            propertiesPane2.removeVObjectListener(VPropertiesAction.this.objectEventSupport_);
                            propertiesPane2.removeWorkingListener(VPropertiesAction.this.workingEventSupport_);
                            VPropertiesAction.disposeDialog(object2);
                        }
                    });
                    JPanel buttonPanel = new JPanel();
                    buttonPanel.setLayout(new FlowLayout(2));
                    buttonPanel.add(okButton);
                    buttonPanel.add(cancelButton);
                    buttonPanel.add(applyButton);
                    okButton.setSelected(true);
                    Component component = propertiesPane.getComponent();
                    JDialog dialog = new JDialog(context.getFrame(), title, false);
                    dialog.getContentPane().setLayout(new BorderLayout());
                    dialog.getContentPane().add("South", buttonPanel);
                    dialog.getContentPane().add("Center", component);
                    dialog.setResizable(false);
                    dialog.pack();
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent event) {
                            VPropertiesAction.disposeDialog(object2);
                        }
                    });
                    propertiesPane.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent event) {
                            applyButton2.setEnabled(true);
                        }
                    });
                    VPropertiesAction.showDialog(object2, dialog);
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    public void setObject(VObject object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        this.object_ = object;
    }

    static void showDialog(VObject object, JDialog dialog) {
        visibleDialogs_.put(object, dialog);
        dialog.show();
    }

    public String toString() {
        return propertiesActionText_;
    }
}

