/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pipeline;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.FileUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="PIPELINE", image="ui/images/pipeline.svg", name="i18n::ActionPipeline.Name", description="i18n::ActionPipeline.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionPipeline.keyword"}, documentationUrl="/workflow/actions/pipeline.html", actionTransformTypes={ActionTransformType.HOP_FILE, ActionTransformType.HOP_PIPELINE})
public class ActionPipeline
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionPipeline.class;
    @HopMetadataProperty(key="filename", hopMetadataPropertyType=HopMetadataPropertyType.FILE_REFERENCE)
    private String filename;
    @HopMetadataProperty(key="params_from_previous")
    private boolean paramsFromPrevious;
    @HopMetadataProperty(key="exec_per_row")
    private boolean execPerRow;
    @HopMetadataProperty(key="clear_rows")
    private boolean clearResultRows;
    @HopMetadataProperty(key="clear_files")
    private boolean clearResultFiles;
    @HopMetadataProperty(key="create_parent_folder")
    private boolean createParentFolder;
    @HopMetadataProperty(key="set_logfile")
    private boolean setLogfile;
    @HopMetadataProperty(key="set_append_logfile")
    private boolean setAppendLogfile;
    @HopMetadataProperty(key="logfile")
    private String logfile;
    @HopMetadataProperty(key="logext")
    private String logext;
    @HopMetadataProperty(key="add_date")
    private boolean addDate;
    @HopMetadataProperty(key="add_time")
    private boolean addTime;
    @HopMetadataProperty(key="loglevel", storeWithCode=true)
    private LogLevel logFileLevel;
    @HopMetadataProperty(key="wait_until_finished")
    private boolean waitingToFinish = true;
    @HopMetadataProperty(key="parameters")
    private ParameterDefinition parameterDefinition = new ParameterDefinition();
    @HopMetadataProperty(key="run_configuration")
    private String runConfiguration;
    private IPipelineEngine<PipelineMeta> pipeline;

    public ActionPipeline(String name) {
        super(name, "");
    }

    public ActionPipeline() {
        this("");
        this.clear();
    }

    public ParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    public void setParameterDefinition(ParameterDefinition parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public String getLogFilename() {
        Object retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = (String)retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = (String)retval + "." + this.logext;
            }
        }
        return retval;
    }

    public void clear() {
        super.clear();
        this.filename = null;
        this.execPerRow = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.clearResultRows = false;
        this.clearResultFiles = false;
        this.setAppendLogfile = false;
        this.waitingToFinish = true;
        this.createParentFolder = false;
        this.logFileLevel = LogLevel.BASIC;
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setEntryNr((long)nr);
        LogChannelFileWriter logChannelFileWriter = null;
        LogLevel pipelineLogLevel = this.parentWorkflow.getLogLevel();
        String realLogFilename = "";
        if (this.setLogfile) {
            pipelineLogLevel = this.logFileLevel;
            realLogFilename = this.resolve(this.getLogFilename());
            if (Utils.isEmpty((CharSequence)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (!FileUtil.createParentFolder(PKG, (String)realLogFilename, (boolean)this.createParentFolder, (ILogChannel)this.getLogChannel())) {
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                logChannelFileWriter = new LogChannelFileWriter(this.getLogChannelId(), HopVfs.getFileObject((String)realLogFilename), this.setAppendLogfile);
                logChannelFileWriter.startLogging();
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Error.UnableOpenAppender", (String[])new String[]{realLogFilename, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPipeline.Log.OpeningPipeline", (String[])new String[]{this.resolve(this.getFilename())}));
        PipelineMeta pipelineMeta = null;
        try {
            pipelineMeta = this.getPipelineMeta(this.getMetadataProvider(), (IVariables)this);
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Exception.UnableToRunWorkflow", (String[])new String[]{this.parentWorkflowMeta.getName(), this.getName(), StringUtils.trim((String)e.getMessage())}), e);
            result.setNrErrors(1L);
            result.setResult(false);
            return result;
        }
        RowMetaAndData resultRow = null;
        boolean first = true;
        ArrayList rows = new ArrayList(result.getRows());
        for (int iteration = 0; first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L && !this.parentWorkflow.isStopped(); ++iteration) {
            if (this.execPerRow) {
                result.getRows().clear();
            }
            resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
            NamedParameters namedParam = new NamedParameters();
            for (Parameter parameter : this.parameterDefinition.getParameters()) {
                Object value;
                if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                namedParam.addParameterDefinition(parameter.getName(), "", "Action runtime");
                if (Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                    value = Const.NVL((String)this.resolve(parameter.getValue()), (String)"");
                    namedParam.setParameterValue(parameter.getName(), (String)value);
                    continue;
                }
                value = "";
                if (resultRow != null) {
                    value = resultRow.getString(parameter.getField(), "");
                }
                namedParam.setParameterValue(parameter.getName(), (String)value);
            }
            first = false;
            Result previousResult = result;
            try {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionPipeline.StartingPipeline", (String[])new String[]{this.getFilename(), this.getName(), this.getDescription()}));
                }
                if (this.clearResultRows) {
                    previousResult.setRows(new ArrayList());
                }
                if (this.clearResultFiles) {
                    previousResult.getResultFiles().clear();
                }
                if (this.execPerRow) {
                    ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                    newList.add(resultRow);
                    previousResult.getRows().addAll(newList);
                    if (this.paramsFromPrevious) {
                        for (Parameter parameter : this.parameterDefinition.getParameters()) {
                            if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                            if (Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                                namedParam.setParameterValue(parameter.getName(), Const.NVL((String)this.resolve(parameter.getValue()), (String)""));
                                continue;
                            }
                            String fieldValue = "";
                            if (resultRow != null) {
                                fieldValue = resultRow.getString(parameter.getField(), "");
                            }
                            namedParam.setParameterValue(parameter.getName(), Const.NVL((String)fieldValue, (String)""));
                        }
                    }
                } else if (this.paramsFromPrevious) {
                    for (Parameter parameter : this.parameterDefinition.getParameters()) {
                        if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                        if (Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                            namedParam.setParameterValue(parameter.getName(), Const.NVL((String)this.resolve(parameter.getValue()), (String)""));
                            continue;
                        }
                        String fieldValue = "";
                        if (resultRow != null) {
                            fieldValue = resultRow.getString(parameter.getField(), "");
                        }
                        namedParam.setParameterValue(parameter.getName(), Const.NVL((String)fieldValue, (String)""));
                    }
                }
                String[] parameterNames = pipelineMeta.listParameters();
                this.prepareFieldNamesParameters(this.parameterDefinition.getParameters(), (INamedParameters)namedParam, this);
                if (StringUtils.isEmpty((String)this.runConfiguration)) {
                    throw new HopException("This action needs a run configuration to use to execute the specified pipeline");
                }
                this.runConfiguration = this.resolve(this.runConfiguration);
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionPipeline.RunConfig.Message", (String[])new String[]{this.runConfiguration}));
                this.pipeline = PipelineEngineFactory.createPipelineEngine((IVariables)this, (String)this.runConfiguration, (IHopMetadataProvider)this.getMetadataProvider(), (PipelineMeta)pipelineMeta);
                this.pipeline.setParent((ILoggingObject)this);
                this.pipeline.setParentWorkflow(this.parentWorkflow);
                this.pipeline.setParentVariables((IVariables)this.parentWorkflow);
                this.pipeline.setLogLevel(pipelineLogLevel);
                this.pipeline.setPreviousResult(previousResult);
                this.pipeline.setMetadataProvider(this.getMetadataProvider());
                this.pipeline.initializeFrom(null);
                this.pipeline.copyParametersFromDefinitions((INamedParameterDefinitions)pipelineMeta);
                TransformWithMappingMeta.activateParams(this.pipeline, this.pipeline, (IVariables)this, (String[])parameterNames, (String[])this.parameterDefinition.getNames(), (String[])this.parameterDefinition.getValues(), (boolean)this.parameterDefinition.isPassingAllParameters());
                IWorkflowEngine rootWorkflow = this.parentWorkflow;
                while (rootWorkflow.getParentWorkflow() != null) {
                    rootWorkflow = rootWorkflow.getParentWorkflow();
                }
                try {
                    this.pipeline.execute();
                    if (this.isWaitingToFinish()) {
                        this.pipeline.waitUntilFinished();
                        if (this.parentWorkflow.isStopped() || this.pipeline.getErrors() != 0) {
                            this.pipeline.stopAll();
                            result.setNrErrors(1L);
                        }
                        this.updateResult(result);
                    }
                    if (!this.setLogfile) continue;
                    ResultFile resultFile = new ResultFile(1, HopVfs.getFileObject((String)realLogFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.Error.UnablePrepareExec", (String[])new String[0]), e);
                    result.setNrErrors(1L);
                }
                continue;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPipeline.ErrorUnableOpenPipeline", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
            }
        }
        if (this.setLogfile && logChannelFileWriter != null) {
            logChannelFileWriter.stopLogging();
            ResultFile resultFile = new ResultFile(1, logChannelFileWriter.getLogFile(), this.parentWorkflow.getWorkflowName(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (logChannelFileWriter.getException() != null) {
                this.logError("Unable to open log file [" + this.getLogFilename() + "] : ");
                this.logError(Const.getStackTracker((Throwable)logChannelFileWriter.getException()));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    protected void updateResult(Result result) {
        Result newResult = this.pipeline.getResult();
        result.clear();
        result.add(newResult);
        if (!Utils.isEmpty((List)newResult.getRows())) {
            result.setRows(newResult.getRows());
        }
    }

    public PipelineMeta getPipelineMeta(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        try {
            PipelineMeta pipelineMeta = null;
            CurrentDirectoryResolver r = new CurrentDirectoryResolver();
            IVariables tmpSpace = r.resolveCurrentDirectory(variables, this.parentWorkflow, this.getFilename());
            String realFilename = tmpSpace.resolve(this.getFilename());
            pipelineMeta = new PipelineMeta(realFilename, metadataProvider, (IVariables)this);
            if (pipelineMeta != null) {
                pipelineMeta.setMetadataProvider(metadataProvider);
            }
            return pipelineMeta;
        }
        catch (HopException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionPipeline.Exception.MetaDataLoad", (String[])new String[0]), (Throwable)e);
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<SqlStatement> getSqlStatements(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        this.copyFrom(variables);
        PipelineMeta pipelineMeta = this.getPipelineMeta(metadataProvider, (IVariables)this);
        return pipelineMeta.getSqlStatements(variables);
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.setLogfile) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "logfile", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        } else {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "pipeline-name", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "directory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = variables.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        this.copyFrom(variables);
        PipelineMeta pipelineMeta = this.getPipelineMeta(metadataProvider, variables);
        String proposedNewFilename = pipelineMeta.exportResources(variables, definitions, namingInterface, metadataProvider);
        String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
        pipelineMeta.setFilename(newFilename);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    public String getLogfile() {
        return this.logfile;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    public IPipelineEngine<PipelineMeta> getPipeline() {
        return this.pipeline;
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"ActionPipeline.ReferencedObject.Description", (String[])new String[0])};
    }

    private boolean isPipelineDefined() {
        return StringUtils.isNotEmpty((String)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isPipelineDefined()};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return this.getPipelineMeta(metadataProvider, variables);
    }

    public void setParentWorkflowMeta(WorkflowMeta parentWorkflowMeta) {
        super.setParentWorkflowMeta(parentWorkflowMeta);
    }

    public void prepareFieldNamesParameters(List<Parameter> parameters, INamedParameters namedParam, ActionPipeline actionPipeline) throws UnknownParamException {
        for (Parameter parameter : parameters) {
            String thisValue = namedParam.getParameterValue(parameter.getName());
            if (!Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                if (!Utils.isEmpty((CharSequence)Const.trim((String)parameter.getValue()))) continue;
                actionPipeline.setVariable(parameter.getName(), Const.NVL((String)thisValue, (String)""));
                continue;
            }
            actionPipeline.setVariable(parameter.getName(), Const.NVL((String)thisValue, (String)""));
        }
    }

    public boolean isExecPerRow() {
        return this.execPerRow;
    }

    public void setExecPerRow(boolean runEveryResultRow) {
        this.execPerRow = runEveryResultRow;
    }

    public boolean isAddDate() {
        return this.addDate;
    }

    public boolean isAddTime() {
        return this.addTime;
    }

    public void setAddDate(boolean addDate) {
        this.addDate = addDate;
    }

    public void setAddTime(boolean addTime) {
        this.addTime = addTime;
    }

    public String getLogext() {
        return this.logext;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public void setLogext(String logext) {
        this.logext = logext;
    }

    public boolean isSetLogfile() {
        return this.setLogfile;
    }

    public LogLevel getLogFileLevel() {
        return this.logFileLevel;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setSetLogfile(boolean setLogfile) {
        this.setLogfile = setLogfile;
    }

    public void setLogFileLevel(LogLevel logFileLevel) {
        this.logFileLevel = logFileLevel;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public boolean isParamsFromPrevious() {
        return this.paramsFromPrevious;
    }

    public boolean isSetAppendLogfile() {
        return this.setAppendLogfile;
    }

    public void setParamsFromPrevious(boolean paramsFromPrevious) {
        this.paramsFromPrevious = paramsFromPrevious;
    }

    public void setSetAppendLogfile(boolean setAppendLogfile) {
        this.setAppendLogfile = setAppendLogfile;
    }

    public boolean isClearResultRows() {
        return this.clearResultRows;
    }

    public boolean isClearResultFiles() {
        return this.clearResultFiles;
    }

    public void setClearResultRows(boolean clearResultRows) {
        this.clearResultRows = clearResultRows;
    }

    public void setClearResultFiles(boolean clearResultFiles) {
        this.clearResultFiles = clearResultFiles;
    }

    public static final class ParameterDefinition {
        @HopMetadataProperty(key="pass_all_parameters")
        private boolean passingAllParameters = true;
        @HopMetadataProperty(key="parameter")
        private List<Parameter> parameters = new ArrayList<Parameter>();

        public boolean isPassingAllParameters() {
            return this.passingAllParameters;
        }

        public void setPassingAllParameters(boolean passingAllParameters) {
            this.passingAllParameters = passingAllParameters;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
        }

        public String[] getNames() {
            ArrayList<String> list = new ArrayList<String>();
            for (Parameter parameter : this.parameters) {
                list.add(parameter.getName());
            }
            return list.toArray(new String[0]);
        }

        public String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (Parameter parameter : this.parameters) {
                list.add(parameter.getValue());
            }
            return list.toArray(new String[0]);
        }
    }

    public static final class Parameter {
        @HopMetadataProperty
        public String name;
        @HopMetadataProperty
        public String value;
        @HopMetadataProperty(key="stream_name")
        public String field;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getField() {
            return this.field;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setField(String field) {
            this.field = field;
        }
    }
}

