/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tableexists;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tableexists.TableExists;
import org.apache.hop.pipeline.transforms.tableexists.TableExistsData;

@Transform(id="TableExists", image="tableexists.svg", name="i18n::TableExists.Name", description="i18n::TableExists.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Validation", keywords={"i18n::TableExistsMeta.keyword"}, documentationUrl="/pipeline/transforms/tableexists.html", actionTransformTypes={ActionTransformType.RDBMS})
public class TableExistsMeta
extends BaseTransformMeta<TableExists, TableExistsData> {
    private static final Class<?> PKG = TableExistsMeta.class;
    @HopMetadataProperty(injectionKeyDescription="TableExistsMeta.Injection.Connection", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_CONNECTION)
    private String connection;
    @HopMetadataProperty(key="tablenamefield", injectionKeyDescription="TableExistsMeta.Injection.TableNameField", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TABLE)
    private String tableNameField;
    @HopMetadataProperty(key="resultfieldname", injectionKeyDescription="TableExistsMeta.Injection.ResultFieldName")
    private String resultFieldName;
    @HopMetadataProperty(key="schemaname", injectionKeyDescription="TableExistsMeta.Injection.SchemaName", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SCHEMA)
    private String schemaName;

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public String getTableNameField() {
        return this.tableNameField;
    }

    public void setTableNameField(String tablenamefield) {
        this.tableNameField = tablenamefield;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String name) {
        this.resultFieldName = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public void setDefault() {
        this.connection = null;
        this.schemaName = null;
        this.resultFieldName = "result";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.resultFieldName)) {
            ValueMetaBoolean v = new ValueMetaBoolean(variables.resolve(this.resultFieldName));
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        Object errorMessage = "";
        Database database = null;
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)metadataProvider.getSerializer(DatabaseMeta.class).load(variables.resolve(this.connection));
            if (databaseMeta != null) {
                CheckResult cr;
                database = new Database(loggingObject, variables, databaseMeta);
                database.connect();
                if (database == null) {
                    errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.InvalidConnection", (String[])new String[0]);
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (Utils.isEmpty((CharSequence)this.resultFieldName)) {
                    errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
                    cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (Utils.isEmpty((CharSequence)this.tableNameField)) {
                    errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.TableFieldMissing", (String[])new String[0]);
                    cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.TableFieldOK", (String[])new String[0]);
                    cr = new CheckResult(1, (String)errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                if (input.length > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
        catch (HopException e) {
            errorMessage = BaseMessages.getString(PKG, (String)"TableExistsMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
            CheckResult cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        finally {
            database.disconnect();
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

