/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.auth;

import org.apache.hop.core.auth.AuthenticationConsumerPluginType;
import org.apache.hop.core.auth.IAuthenticationConsumerType;
import org.apache.hop.core.auth.NoAuthenticationAuthenticationProvider;
import org.apache.hop.core.auth.core.AuthenticationFactoryException;
import org.apache.hop.core.auth.core.AuthenticationManager;
import org.apache.hop.core.auth.core.IAuthenticationConsumer;
import org.apache.hop.core.auth.core.IAuthenticationProvider;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.i18n.BaseMessages;

public class AuthenticationPersistenceManager {
    private static final Class<?> PKG = AuthenticationPersistenceManager.class;
    private static final ILogChannel log = new LogChannel((Object)AuthenticationPersistenceManager.class.getName());

    public static AuthenticationManager getAuthenticationManager() {
        AuthenticationManager manager = new AuthenticationManager();
        manager.registerAuthenticationProvider(new NoAuthenticationAuthenticationProvider());
        for (IPlugin plugin : PluginRegistry.getInstance().getPlugins(AuthenticationConsumerPluginType.class)) {
            try {
                Object pluginMain = PluginRegistry.getInstance().loadClass(plugin);
                if (pluginMain instanceof IAuthenticationConsumerType) {
                    IAuthenticationConsumerType iAuthenticationConsumerType = (IAuthenticationConsumerType)pluginMain;
                    Class<? extends IAuthenticationConsumer<?, ?>> consumerClass = iAuthenticationConsumerType.getConsumerClass();
                    manager.registerConsumerClass(consumerClass);
                    continue;
                }
                throw new HopPluginException(BaseMessages.getString(PKG, (String)"AuthenticationPersistenceManager.NotConsumerType", (Object[])new Object[]{pluginMain, IAuthenticationConsumerType.class}));
            }
            catch (AuthenticationFactoryException | HopPluginException e) {
                log.logError(e.getMessage(), (Throwable)e);
            }
        }
        return manager;
    }

    public static void persistAuthenticationProvider(IAuthenticationProvider authenticationProvider) {
    }
}

