/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.samplerows;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.samplerows.SampleRows;
import org.apache.hop.pipeline.transforms.samplerows.SampleRowsData;

@Transform(id="SampleRows", image="samplerows.svg", name="i18n::SampleRows.Name", description="i18n::SampleRows.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", keywords={"i18n::SampleRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/samplerows.html")
public class SampleRowsMeta
extends BaseTransformMeta<SampleRows, SampleRowsData> {
    private static final Class<?> PKG = SampleRowsMeta.class;
    @HopMetadataProperty(key="linesrange")
    private String linesRange;
    @HopMetadataProperty(key="linenumfield")
    private String lineNumberField;
    public static String DEFAULT_RANGE = "1";

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!Utils.isEmpty((CharSequence)this.lineNumberField)) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.lineNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public String getLinesRange() {
        return this.linesRange;
    }

    public void setLinesRange(String linesRange) {
        this.linesRange = linesRange;
    }

    public String getLineNumberField() {
        return this.lineNumberField;
    }

    public void setLineNumberField(String lineNumberField) {
        this.lineNumberField = lineNumberField;
    }

    public void setDefault() {
        this.linesRange = DEFAULT_RANGE;
        this.lineNumberField = null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = Utils.isEmpty((CharSequence)this.linesRange) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.LinesRangeMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.LinesRangeOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = prev == null || prev.isEmpty() ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SampleRowsMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }
}

