/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.formula.util;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transforms.formula.FormulaMetaFunction;
import org.apache.hop.pipeline.transforms.formula.FormulaPoi;
import org.apache.hop.pipeline.transforms.formula.util.FormulaFieldsExtractor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;

public class FormulaParser {
    private FormulaMetaFunction formulaMetaFunction;
    private IRowMeta rowMeta;
    private String formula;
    private List<String> formulaFieldList;
    private Object[] dataRow;
    private FormulaPoi.Evaluator evaluator;
    private HashMap<String, String> replaceMap;

    public FormulaParser(FormulaMetaFunction formulaMetaFunction, IRowMeta rowMeta, Object[] dataRow, FormulaPoi poi, IVariables variables, HashMap<String, String> replaceMap, List<String> formulaFieldList) {
        this.formulaMetaFunction = formulaMetaFunction;
        this.rowMeta = rowMeta;
        this.dataRow = dataRow;
        this.replaceMap = replaceMap;
        this.formula = variables.resolve(formulaMetaFunction.getFormula());
        this.formulaFieldList = formulaFieldList;
        boolean getNewList = false;
        for (String formulaField : formulaFieldList) {
            Set<String> replaceKeys = replaceMap.keySet();
            if (!replaceKeys.contains(formulaField)) continue;
            String realFieldName = replaceMap.get(formulaField);
            this.formula = this.formula.replace("[" + formulaField + "]", "[" + realFieldName + "]");
            getNewList = true;
        }
        if (getNewList) {
            this.formulaFieldList = FormulaFieldsExtractor.getFormulaFieldList(variables.resolve(this.formula));
        }
        this.evaluator = poi.evaluator(formulaFieldList.size() + 1);
        this.evaluator.evaluator().clearAllCachedResultValues();
    }

    public CellValue getFormulaValue() throws HopValueException {
        Cell formulaCell;
        String parsedFormula = this.formula;
        int fieldIndex = 65;
        int colIndex = 0;
        Row row = this.evaluator.row();
        if (row.getLastCellNum() > 0 && row.getLastCellNum() != this.formulaFieldList.size() + 1) {
            if (this.evaluator.row() != null) {
                this.evaluator.sheet().removeRow(this.evaluator.row());
            }
            row = this.evaluator.sheet().createRow(0);
            this.evaluator.row(row);
        }
        for (String formulaField : this.formulaFieldList) {
            char s = (char)fieldIndex;
            Cell cell = row.getLastCellNum() <= colIndex ? row.createCell(colIndex) : row.getCell(colIndex);
            int fieldPosition = this.rowMeta.indexOfValue(formulaField);
            parsedFormula = parsedFormula.replace("[" + formulaField + "]", s + "1");
            IValueMeta fieldMeta = this.rowMeta.getValueMeta(fieldPosition);
            if (this.dataRow[fieldPosition] != null) {
                if (fieldMeta.isString()) {
                    cell.setCellValue(this.rowMeta.getString(this.dataRow, fieldPosition));
                } else if (fieldMeta.isBoolean()) {
                    cell.setCellValue(this.rowMeta.getBoolean(this.dataRow, fieldPosition).booleanValue());
                } else if (fieldMeta.isBigNumber()) {
                    cell.setCellValue((RichTextString)new HSSFRichTextString(this.rowMeta.getString(this.dataRow, fieldPosition)));
                } else if (fieldMeta.isDate()) {
                    cell.setCellValue(this.rowMeta.getDate(this.dataRow, fieldPosition));
                } else if (fieldMeta.isInteger()) {
                    cell.setCellValue((double)this.rowMeta.getInteger(this.dataRow, fieldPosition).longValue());
                } else if (fieldMeta.isNumber()) {
                    cell.setCellValue(this.rowMeta.getNumber(this.dataRow, fieldPosition).doubleValue());
                } else {
                    cell.setCellValue(this.rowMeta.getString(this.dataRow, fieldPosition));
                }
            } else if (this.formulaMetaFunction.isSetNa()) {
                cell.setCellFormula("NA()");
            } else {
                cell.setBlank();
            }
            ++fieldIndex;
            ++colIndex;
        }
        if (row.getLastCellNum() <= colIndex) {
            formulaCell = row.createCell(colIndex);
            formulaCell.setCellFormula(parsedFormula);
        } else {
            formulaCell = row.getCell(colIndex);
        }
        return this.evaluator.evaluator().evaluate(formulaCell);
    }
}

